# swedish.tcl:
# Text for menu names and status bar help messages in Swedish.
# Part of Scid (Shane's Chess Information Database).
# Contributed by Martin Skjldebrand, martin@skjoldebrand.org
# Thanks to: Hans Eriksson, for looking over the translation file

addLanguage W Swedish 1

proc setLanguage_W {} {

# File menu:
menuText W File "Arkiv" 0
menuText W FileNew "Ny..." 0 {Skapa en ny Scid databas}
menuText W FileOpen "ppna..." 0 {ppna en befintlig Scid databas}
menuText W FileClose "Stng" 0 {Stng den aktiva Scid databasen}
menuText W FileFinder "Sk filer" 4 {ppna skdialogen}
menuText W FileBookmarks "Bokmrken" 0 {Hantera bokmrken (kortkommando: Ctrl+B)}
menuText W FileBookmarksAdd "Nytt bokmrke" 0 \
  {Markera den aktiva stllningen i partiet}
menuText W FileBookmarksFile "Spara bokmrke" 0 \
  {Spara bokmrket fr den aktiva stllningen i partiet}
menuText W FileBookmarksEdit "Redigera bokmrken..." 0 \
  {Redigera bokmrken}
menuText W FileBookmarksList "Visa bokmrken som lista" 19 \
  {Visar bokmrkena som lista, inte undermenyer}
menuText W FileBookmarksSub "Visa bokmrken i undermenyer" 17 \
  {Visar bokmrkena som undermenyer, inte lista}
menuText W FileMaint "Databasverktyg" 0 {Scids databasverktyg}
menuText W FileMaintWin "Verktygsfnster" 0 \
  {ppna/ stng verktygsfnstret}
menuText W FileMaintCompact "Komprimera databasen..." 0 \
  {Komprimera databasen, avlgsna raderade partier och oanvnda namn}
menuText W FileMaintClass "Klassificera partier enligt ECO..." 2 \
  {Klassificera om alla partier enligt ECO-systemet}
menuText W FileMaintSort "Sortera databasen..." 0 \
  {Sortera partierna i den aktiva databasen}
menuText W FileMaintDelete "Radera dubbletter..." 0 \
  {Sk dubbletter och markera de som raderingsbara}
menuText W FileMaintTwin "Sk dubbletter" 0 \
  {ppna/ stng dubblettfnstret fr att ska dubblettpartier}
menuText W FileMaintName "Stavningskontroll" 0 {Namnredigering och stavningskontroll}
menuText W FileMaintNameEditor "Redigera namn" 0 \
  {Redigera spelarnamn utifrn rttstavningsfilen}
menuText W FileMaintNamePlayer "Stavningskontrollera namn..." 22 \
  {Stavningskontrollera namn utifrn rttstavningsfilen}
menuText W FileMaintNameEvent "Stavningskontrollera evenemang..." 21 \
  {Stavningskontrollera evenemang utifrn rttstavningsfilen}
menuText W FileMaintNameSite "Stavningskontrollera platser..." 21 \
  {Stavningskontrollera platser utifrn rttstavningsfilen}
menuText W FileMaintNameRound "Stavningskontrollera ronder..." 21 \
  {Stavningskontrollera ronder utifrn rttstavningsfilen}
menuText W FileReadOnly "Enbart lsbar..." 8 \
  {Avlgsna temporrt redigeringsmjligheterna till databasen}
menuText W FileSwitch "Byt databas" 0 \
  {Byt till en annan ppnad databas} 
menuText W FileExit "Avsluta" 0 {Avsluta Scid}

# Edit menu:
menuText W Edit "Redigera" 0
menuText W EditAdd "Lgg till variant" 0 {Skapa en variant vid denna stllning}
menuText W EditDelete "Radera variant" 0 {Radera en variant vid denna stllning}
menuText W EditFirst "Skapa huvudvariant" 6 \
  {Gr en av varianterna till huvudvariant}
menuText W EditMain "Skapa nytt textdrag" 11 \
  {Gr en av varianterna till partifortsttning}
menuText W EditTrial "Testa variant" 6 \
  {Starta/ stoppa testlge, undersk en ide p brdet}
menuText W EditStrip "Ta bort" 3 {Avlgsna kommentarer eller varianter frn partiet}
menuText W EditStripComments "Kommentarer" 0 \
  {Avlgsna alla kommentarer och noteringar frn partiet}
menuText W EditStripVars "Varianter" 0 {Avlgsna alla varinter frn partiet}
menuText W EditStripBegin "Avlgsna tidigare drag" 9 \
  {Avlgsna dragen fram till den aktuella stllningen} 
menuText W EditStripEnd "Avlgsna resterande drag" 0 \
  {Avlgsna partiets resterande drag} 
menuText W EditReset "Tm Clipbase" 1 \
  {Tmmer den temporra databasen}
menuText W EditCopy "Kopiera partiet till Clipbase" 21 \
  {Kopierar det aktuella partiet till Clipbase}
menuText W EditPaste "Klistra in det senaste Clipbasepartiet" 8 \
  {Klistrar in det senaste tillagda i Clipbase i den aktiva databasen}
menuText W EditSetup "Skapa stllning..." 0 \
  {Skapa en utgngsstllning fr aktuellt parti}
menuText W EditCopyBoard "Kopiera stllning" 0 \
  {Kopiera den aktuella stllningen i FEN kod till urklippshanteraren} 
menuText W EditPasteBoard "Klistra in utgngsstllning" 10 \
  {Klistra in stllningen frn aktuellt parti i den temporra databasen}

# Game menu:
menuText W Game "Partier" 0
menuText W GameNew "Nytt parti" 0 \
  {terstll brdet infr ett nytt parti (raderar alla ndringar)}
menuText W GameFirst "Ladda det frsta partiet" 10 {Laddar det frsta partiet i filtret}
menuText W GamePrev "Ladda fregende parti" 7 {Ladda fregende parti i filtret}
menuText W GameReload "Brja om partiet" 0 \
  {terstll partiet (raderar alla ndringar)}
menuText W GameNext "Ladda nsta parti" 6 {Ladda nsta parti i filtret}
menuText W GameLast "Ladda det sista partiet" 10 {Ladda det sista partiet i filtret}
menuText W GameRandom "Ladda parti slumpmssigt" 14 \
  {Ladda ett av datorn slumpmssigt valt parti} 
menuText W GameNumber "Ladda parti nummer..." 6 \
  {Ladda ett parti genom att ange dess nummer}
menuText W GameReplace "Spara: Erstt parti..." 7 \
  {Spara partiet och erstt tidigare version}
menuText W GameAdd "Spara: Nytt parti..." 1 \
  {Spara ett nytt parti}
menuText W GameDeepest "Identifiera ppningen" 0 \
  {G till den mest detaljerade stllningen i ECO boken}
menuText W GameGotoMove "G till drag nummer..." 8 \
  {G till ett specifikt drag i partiet}
menuText W GameNovelty "Hitta nyhet..." 7 \
  {Hitta det frsta draget i partiet som inte spelats tidigare}

# Search Menu:
menuText W Search "Sk" 0
menuText W SearchReset "terstll skfilter" 0 {terstll skfiltret s att alla partiet ingr}
menuText W SearchNegate "Omvnt filter" 0 {Ta med partier som utesluts av filtret}
menuText W SearchCurrent "Aktuell position..." 8 {Sk partier med aktuell position p brdet}
menuText W SearchHeader "I huvud..." 2 {Anvnd fast information (spelare, evenemang, plats, mm)}
menuText W SearchMaterial "Material/stllning..." 0 {Skning baserad p material eller stllning}
menuText W SearchUsing "Anvnd skfil..." 10 {Anvnd en fil med lagrade skvillkor}

# Windows menu:
menuText W Windows "Fnster" 0
menuText W WindowsComment "Kommentarseditor" 0 {ppna/ stng kommentarseditorn}
menuText W WindowsGList "Partilista" 5 {ppna/ stng partilistan}
menuText W WindowsPGN "PGN fnster" 0 \
  {ppna/ stng PGN fnstret}
menuText W WindowsPList "Spelarfrteckning" 7 {ppna/ stng en frteckning ver spelarna i den aktiva databasen} 
menuText W WindowsTmt "Turneringar" 0 {Lista turneringar}
menuText W WindowsSwitcher "Databasvxlaren" 0 \
  {ppna/ stng databasvxlaren}
menuText W WindowsMaint "Verktygsfnster" 0 \
  {ppna/ stng verktygsfnstret}
menuText W WindowsECO "ECO fnster" 0 {ppna/ stng ECO blddraren}
menuText W WindowsRepertoire "Repetoareditor" 0 \
  {ppna/ stng spelppningsfnstret}
menuText W WindowsStats "Statistikfnster" 0 \
  {ppna/ stng statistikfnstret}
menuText W WindowsTree "Trdfnster" 2 {ppna/ stng varianttrdets fnster}
menuText W WindowsTB "Slutspelsdatabas" 2 \
  {ppna/ stng slutspelsdatabasfnstret}

# Tools menu:
menuText W Tools "Verktyg" 0
menuText W ToolsAnalysis "Analysmotor..." 6 \
  {Starta/ stoppa en analysmotor}
menuText W ToolsAnalysis2 "Analysmotor 2..." 12 \
  {Starta/ stoppa en andra analysmotor}
menuText W ToolsCross "Resultattabell" 0 {Visa en resultattabell fr den aktuella turneringen}
menuText W ToolsEmail "Eposthanterare" 0 \
  {ppna/ stng eposthanteraren}
menuText W ToolsFilterGraph "Filterdiagram" 7 \
  {ppna/ stng filterdiagramfnstret} 
menuText W ToolsOpReport "ppningsrapport" 0 \
  {Skapa en ppningsrapport utifrn den aktuella stllningen}
menuText W ToolsTracker "Sk material"  0 {ppnar dialog fr att ska efter en viss materiell balans} 
menuText W ToolsPInfo "Spelarinformation"  0 \
  {ppna/ uppdatera spelarinformation}
menuText W ToolsPlayerReport "Spelarrapport..." 3 \
  {Skapa en spelarrapport}
menuText W ToolsRating "Rankingdiagram" 0 \
  {Skapa ett ranking diagram fr spelarna i partiet}
menuText W ToolsScore "Resultatdiagram" 8 {Visa resultatdiagrammet}
menuText W ToolsExpCurrent "Exportera aktuellt parti" 1 \
  {Spara aktuellt parti till en textfil}
menuText W ToolsExpCurrentPGN "Exportera till PGN..." 15 \
  {Spara aktuellt parti till en PGN-fil}
menuText W ToolsExpCurrentHTML "Exportera till HTML..." 15 \
  {Spara aktuellt parti till en HTML-fil}
menuText W ToolsExpCurrentLaTeX "Exportera till LaTeX..." 15 \
  {Spara aktuellt parti till en LaTeX-fil}
menuText W ToolsExpFilter "Exportera alla filtrerade partier" 15 \
  {Spara alla filterade partier till en textfil}
menuText W ToolsExpFilterPGN "Exportera till PGN..." 15 \
  {Spara alla filterade partier till en PGN-fil}
menuText W ToolsExpFilterHTML "Exportera till HTML..." 15 \
  {Spara alla filterade partier till en HTML-fil}
menuText W ToolsExpFilterLaTeX "Exportera till LaTeX..." 15 \
  {Spara alla filterade partier till en LaTeX-fil}
menuText W ToolsImportOne "Importera ett parti i PGN-format..." 0 \
  {Importera ett parti i PGN-format}
menuText W ToolsImportFile "Importera flera partier i PGN-format..." 16 \
  {Importera flera partier i PGN-format frn en fil}

# Options menu:
menuText W Options "Alternativ" 2
menuText W OptionsBoard "Brdet" 0 {ndra brdets utseende}
menuText W OptionsBoardSize "Brdstorlek" 0 {ndra brdets storlek}
menuText W OptionsBoardPieces "Pjsutseende" 1 {ndra pjsernas utseende} 
menuText W OptionsBoardColors "Frger..." 0 {ndra brdets frger}
menuText W OptionsBoardNames "Spelarnamn..." 0 {Redigera spelares namn}
menuText W OptionsExport "Export" 0 {ndra exportalternativ}
menuText W OptionsFonts "Typsnitt" 0 {ndra typsnitt}
menuText W OptionsFontsRegular "Normal" 0 {ndra det normala typsnittet}
menuText W OptionsFontsMenu "Menu" 0 {ndra menytypsnittet}
menuText W OptionsFontsSmall "Liten" 0 {ndra det lilla typsnittet}
menuText W OptionsFontsFixed "Fixerad" 0 {ndra det fixerade typsnittet}
menuText W OptionsGInfo "Partiinformation" 0 {Alternativ fr partiinformation}
menuText W OptionsLanguage "Sprk" 0 {Vlj sprk}
menuText W OptionsMoves "Drag" 0 {Alternativ fr dragangivelse}
menuText W OptionsMovesAsk "Frga fre erstt drag" 0 \
  {Frga innan du erstter befintliga drag}
menuText W OptionsMovesAnimate "Animation time" 1 \
  {Ange tid mellan varje drag nr dragen grs automatiskt}
menuText W OptionsMovesDelay "Frdrjning vid automatspel..." 1 \
  {Ange frdrjning mellan dragen nr datorn spelar sjlv}
menuText W OptionsMovesCoord "Koordinater" 0 \
  {Acceptera koordinater ("g1f3") vid dragangivelse}
menuText W OptionsMovesSuggest "Visa freslagna drag" 0 \
  {Visa/ Dlj freslagna drag}
menuText W OptionsMovesKey "Tangentkomplettering" 0 \
  {Stt p/ stng av dragkomplettering vid tangentinmatning}
menuText W OptionsNumbers "Talformat" 3 {Vlj hur tal visas}
menuText W OptionsStartup "Start" 3 {Vlj vilka fnster som ska ppnas vid start}
menuText W OptionsWindows "Fnster" 1 {Fnsteralternativ}
menuText W OptionsWindowsIconify "Minimera automatiskt" 5 \
  {Minimera alla fnster nr huvufnstret minimeras}
menuText W OptionsWindowsRaise "Autofokus" 0 \
  {Visa ter vissa fnster (t ex. resultatrknare) automatiskt nr de dljs}
menuText W OptionsToolbar "Verktygsflt" 0 \
  {Visa/ dlj huvudfnstrets verktygsflt}
menuText W OptionsECO "Ladda ECO fil..." 7 {Ladda ECO-klassificeringen vid start}
menuText W OptionsSpell "Ladda Rttstavningsfil..." 7 \
  {Ladda rttstavningsfilen vid start}
menuText W OptionsTable "Katalog fr slutspelsdatabaser..." 0 \
  {Vlj en fil som innehller en slutspelsdatabas; alla vriga filer i samma katalog kommer att anvndas}
menuText W OptionsRecent "Senast anvnda filer..." 16 \
  {ndra antalet senast anvnda filer som visas i Arkivmenyn} 
menuText W OptionsSave "Spara alternativ" 7 \
  "Spara alla alternativ till en instllnignsfil"
menuText W OptionsAutoSave "Autospara vid avslut" 1 \
  {Spara alla alternativ nr du avslutar Scid}

# Help menu:
menuText W Help "Hjlp" 0
menuText W HelpContents "Innehll" 0 {Visa innehll} 
menuText W HelpIndex "Index" 0 {Hjlpsystemets indexsida}
menuText W HelpGuide "Snabbguide" 0 {Visa snabbguiden}
menuText W HelpHints "Tips" 0 {Visa tips}
menuText W HelpContact "Kontaktinformation" 0 {Visa kontaktinformation}
menuText W HelpTip "Dagens tips" 0 {Anvndbara Scid tips}
menuText W HelpStartup "Startfnster" 5 {Visa startfnstret}
menuText W HelpAbout "Om Scid" 0 {Information om Scid}

# Game info box popup menu:
menuText W GInfoHideNext "Dlj nsta drag" 0
menuText W GInfoMaterial "Visa materialvrden" 0
menuText W GInfoFEN "Visa FEN" 5
menuText W GInfoMarks "Visa frgade flt och pilar" 22 
menuText W GInfoWrap "Radbrytning" 0
menuText W GInfoFullComment "Visa fullstndiga kommentarer" 18
menuText W GInfoPhotos "Visa bilder" 5 ;
menuText W GInfoTBNothing "Slutspelsdatabaser: inget" 20
menuText W GInfoTBResult "Slutspelsdatabaser: endast resultat" 28
menuText W GInfoTBAll "Slutspelsdatabaser: resultat och bsta drag" 33
menuText W GInfoDelete "terta/Radera detta parti" 0
menuText W GInfoMark "(Av-)Markera detta parti" 5

# Main window buttons:
helpMsg W .button.start {G till brjan av partiet  (kortkommando: Home)}
helpMsg W .button.end {G till slutet av partiet  (kortkommando: End)}
helpMsg W .button.back {Back ett drag (kortkommando: Vnsterpil)}
helpMsg W .button.forward {G fram ett drag  (kortkommando: Hgerpil)}
helpMsg W .button.intoVar {G in i variant (kortkommando: v)}
helpMsg W .button.exitVar {G ur variant  (kortkommando: z)}
helpMsg W .button.flip {Rotera brdet  (kortkommando: .)}
helpMsg W .button.coords {Visa (inte) koordinater  (kortkommando: 0)}
helpMsg W .button.stm {Visa (inte) vilka sida som r vid draget}
helpMsg W .button.autoplay {Autospel  (kortkommando: Ctrl+Z)}

# General buttons:
translate W Back {Tillbaka}
translate W Browse {Blddra}
translate W Cancel {Avbryt}
translate W Clear {Rensa}
translate W Close {Stng}
translate W Contents {Innehll}
translate W Defaults {Standard}
translate W Delete {Radera}
translate W Graph {Diagram}
translate W Help {Hjlp}
translate W Import {Importera}
translate W Index {Index}
translate W LoadGame {Ladda parti}
translate W BrowseGame {Blddra genom partier}
translate W MergeGame {Sl samman partier}
translate W Preview {Frhandsgranska}
translate W Revert {ngra inmatning}
translate W Save {Spara}
translate W Search {Sk}
translate W Stop {Stoppa}
translate W Store {Spara}
translate W Update {Uppdatera}
translate W ChangeOrient {ndra fnstrets orientering}
translate W None {Ingen}
translate W First {Frsta}
translate W Current {Aktuella}
translate W Last {Sista}

# General messages:
translate W game {parti}
translate W games {partier}
translate W move {drag}
translate W moves {drag}
translate W all {alla}
translate W Yes {Ja}
translate W No {Nej}
translate W Both {Bda}
translate W King {Kung}
translate W Queen {Dam}
translate W Rook {Torn}
translate W Bishop {Lpare}
translate W Knight {Springare}
translate W Pawn {Bonde}
translate W White {Vit}
translate W Black {Svart}
translate W Player {Spelare}
translate W Rating {Ranking}
translate W RatingDiff {Rankingskillnad (Vit - Svart)}
translate W AverageRating {Medelranking} 
translate W Event {Evenemang}
translate W Site {Plats}
translate W Country {Land}
translate W IgnoreColors {Ignorera frger}
translate W Date {Datum}
translate W EventDate {Evenemangsdatum}
translate W Decade {Decenium}
translate W Year {r}
translate W Month {Mnad}
translate W Months {Januari Februari Mars April Maj Juni
  Juli Augusti September Oktober November December}
translate W Days {Sn Mn Tis Ons Tors Fre Lr}
translate W YearToToday {Idag}
translate W Result {Resultat}
translate W Round {Rond}
translate W Length {Lngd}
translate W ECOCode {ECO kod}
translate W ECO {ECO}
translate W Deleted {Raderad}
translate W SearchResults {Skresultat}
translate W OpeningTheDatabase {ppnar databas}
translate W Database {Databas}
translate W Filter {Filter}
translate W noGames {inga partier}
translate W allGames {alla partier}
translate W empty {tom}
translate W clipbase {temporr databas}
translate W score {resultat}
translate W StartPos {Utgngsstllning}
translate W Total {Totalt}

# Standard error messages:
translate W ErrNotOpen {Databasen r inte ppen.}
translate W ErrReadOnly {Databasen r skrivskyddad. Du kan inte ndra den.}
translate W ErrSearchInterrupted {Sknigen avbrts; resultatet r inte fullstndigt.}

# Game information:
translate W twin {dubblett}
translate W deleted {raderad}
translate W comment {kommentar}
translate W hidden {dold}
translate W LastMove {Senaste draget}
translate W NextMove {Nsta}
translate W GameStart {Utgngsstllning}
translate W LineStart {Varianten brjar}
translate W GameEnd {Slutstllning}
translate W LineEnd {Varianten slut}

# Player information:
translate W PInfoAll {Resultat fr <b>alla</b> partier}
translate W PInfoFilter {Resultat fr <b>filtrerade</b> partier}
translate W PInfoAgainst {Resultat mot}
translate W PInfoMostWhite {De vanligaste ppningarna som vit}
translate W PInfoMostBlack {De vanligaste ppningarna som svart}
translate W PInfoRating {Rankinghistoria}
translate W PInfoBio {Biografisk information}
translate W PInfoEditRatings {Redigera ranking} 

# Tablebase information:
translate W Draw {Remi}
translate W stalemate {patt}
translate W withAllMoves {med alla drag}
translate W withAllButOneMove {med alla drag utom ett}
translate W with {med}
translate W only {bara}
translate W lose {frlust}
translate W loses {frluster}
translate W allOthersLose {alla andra frlorar}
translate W matesIn {med matt i}
translate W hasCheckmated {har satt matt}
translate W longest {lngst}
translate W WinningMoves {Vinstdrag} 
translate W DrawingMoves {Remidrag} 
translate W LosingMoves {Frlustdrag} 
translate W UnknownMoves {Oknt resultat} 

# Tip of the day:
translate W Tip {Tips}
translate W TipAtStartup {Tips vid start}

# Tree window menus:
menuText W TreeFile "Fil" 0
menuText W TreeFileSave "Spara cachefil" 0 {Spara trdcache (.stc) filen}
menuText W TreeFileFill "Fyll cache fil" 0 \
  {Fyll cachefilen med vanliga ppningar}
menuText W TreeFileBest "Lista bsta partier" 0 {Visa lista ver de bstra partierna i trdet}
menuText W TreeFileGraph "Diagramfnster" 0 {Visa diagrammet fr denna gren i trdet}
menuText W TreeFileCopy "Kopiera trd till urklipp" 1 \
  {Kopierar trdrelaterad statistik till urklipp}
menuText W TreeFileClose "Stng trdfnstret" 0 {Stng trdfnstret}
menuText W TreeSort "Sortera" 0
menuText W TreeSortAlpha "Alfabetiskt" 0
menuText W TreeSortECO "ECO kod" 0
menuText W TreeSortFreq "Frekvens" 0
menuText W TreeSortScore "Resultat" 0
menuText W TreeOpt "Options" 0
menuText W TreeOptLock "Ls" 0 {Ls/ ls upp trdet fr den aktuella databasen}
menuText W TreeOptTraining "Trna" 0 {Stt p/ stng av trningslge}
menuText W TreeOptAutosave "Spara cache filen automatiskt" 0 \
  {Spara cache filen automatiskt nr trdfnstret stngs}
menuText W TreeHelp "Hjlp" 0
menuText W TreeHelpTree "Trdhjlp" 0
menuText W TreeHelpIndex "Hjlp index" 0
translate W SaveCache {Spara cache}
translate W Training {Trna}
translate W LockTree {Ls}
translate W TreeLocked {Lst}
translate W TreeBest {Bst}
translate W TreeBestGames {Bsta partier i trdet}
# Note: the next message is the tree window title row. After editing it,
# check the tree window to make sure it lines up with the actual columns.
translate W TreeTitleRow \
  { Drag      ECO     Frekvens      Res.    Elo~  Niv  r~   %Remi} 
translate W TreeElapsedTime {Tid} 
translate W TreeFoundInCache {  (Hittades i cachen)} 
translate W TreeTotal {TOTALT:     } 

# Finder window:
menuText W FinderFile "Fil" 0
menuText W FinderFileSubdirs "Sk i underkataloger" 0
menuText W FinderFileClose "Stng File Finder" 0
menuText W FinderSort "Sortera" 0
menuText W FinderSortType "Typ" 0
menuText W FinderSortSize "Storlek" 0
menuText W FinderSortMod "Frndrad" 0
menuText W FinderSortName "Namn" 0
menuText W FinderSortPath "Skvg" 0
menuText W FinderTypes "Typer" 0
menuText W FinderTypesScid "Scid databaser" 0
menuText W FinderTypesOld "Scid databaser i ldre format" 0
menuText W FinderTypesPGN "PGN filer" 0
menuText W FinderTypesEPD "EPD filer" 0
menuText W FinderTypesRep "ppningsfiler" 0
menuText W FinderHelp "Hjlp" 0
menuText W FinderHelpFinder "Hjlp fr File Finder" 0
menuText W FinderHelpIndex "Hjlpindex" 0
translate W FileFinder {File Finder}
translate W FinderDir {Katalog}
translate W FinderDirs {Kataloger}
translate W FinderFiles {Filer}
translate W FinderUpDir {upp}

# Player finder:
menuText W PListFile "Fil" 0
menuText W PListFileUpdate "Uppdatera" 0
menuText W PListFileClose "Stng spelarfrteckningen" 1 
menuText W PListSort "Sortera" 0
menuText W PListSortName "Namn" 0
menuText W PListSortElo "Elo" 0
menuText W PListSortGames "Partier" 0
menuText W PListSortOldest "ldst" 0 
menuText W PListSortNewest "Yngst" 0

# Tournament finder:
menuText W TmtFile "Fil" 0
menuText W TmtFileUpdate "Uppdatera" 0
menuText W TmtFileClose "Stng turneringshanteraren" 0
menuText W TmtSort "Sortera" 0
menuText W TmtSortDate "Datum" 0
menuText W TmtSortPlayers "Spelare" 0
menuText W TmtSortGames "Partier" 0
menuText W TmtSortElo "Elo" 0
menuText W TmtSortSite "Plats" 0
menuText W TmtSortEvent "Evenemang" 1
menuText W TmtSortWinner "Vinnare" 0
translate W TmtLimit "Listbegrnsningar"
translate W TmtMeanElo "Lgsta snitt Elo"
translate W TmtNone "Inga turneringar hittades."

# Graph windows:
menuText W GraphFile "Fil" 0
menuText W GraphFileColor "Spara som Postscript (frg)" 8
menuText W GraphFileGrey "Spara som Postscript (grskala)" 8
menuText W GraphFileClose "Stng fnster" 6
menuText W GraphOptions "Alternativ" 0
menuText W GraphOptionsWhite "Vit" 0
menuText W GraphOptionsBlack "Svart" 0
menuText W GraphOptionsBoth "Bda" 1
menuText W GraphOptionsPInfo "Spelarinformation" 0
translate W GraphFilterTitle "Filterdiagram: antal per 1000 partier"

# Analysis window:
translate W AddVariation {Lgg till variant}
translate W AddMove {Lgg till drag}
translate W Annotate {Kommentera}
translate W AnalysisCommand {Analysera}
translate W PreviousChoices {Fregende val}
translate W AnnotateTime {Ange tid mellan drag i sekunder}
translate W AnnotateWhich {Lgg till varianter}
translate W AnnotateAll {fr bda sidors drag}
translate W AnnotateWhite {Endast vits drag}
translate W AnnotateBlack {Endast svarts drag}
translate W AnnotateNotBest {Nr partidraget inte r det bsta}
translate W LowPriority {Kr som lgprioriterad process} 

# Analysis Engine open dialog:
translate W EngineList {Lista ver schackprogram}
translate W EngineName {Namn}
translate W EngineCmd {Startkommando}
translate W EngineArgs {Parametrar} 
translate W EngineDir {Katalog}
translate W EngineElo {Elo}
translate W EngineTime {Datum}
translate W EngineNew {Ny}
translate W EngineEdit {Redigera}
translate W EngineRequired {Fet stil indikerar obligatoriska flt; vriga flt r frivilliga} 

# Stats window menus:
menuText W StatsFile "Fil" 0
menuText W StatsFilePrint "Skriv ut till fil..." 0
menuText W StatsFileClose "Stng fnster" 0
menuText W StatsOpt "Alternativ" 0

# PGN window menus:
menuText W PgnFile "Fil" 0
menuText W PgnFileCopy "Kopiera partiet till urklippsdatabasen" 0
menuText W PgnFilePrint "Skriv ut till..." 0
menuText W PgnFileClose "Stng PGN fnster" 0
menuText W PgnOpt "Presentation" 0
menuText W PgnOptColor "Frg" 0
menuText W PgnOptShort "Kort (3-raders) huvud" 0
menuText W PgnOptSymbols "Symbolbaserad kommentar" 1
menuText W PgnOptIndentC "Indragna kommentarer" 0
menuText W PgnOptIndentV "Indragna varianter" 7
menuText W PgnOptColumn "Spaltstil (ett drag per rad)" 1
menuText W PgnOptSpace "Utrymme efter dragnummer" 1
menuText W PgnOptStripMarks "Avlgnsa koder fr frgade flt och pilar" 1 
menuText W PgnColor "Frger" 0
menuText W PgnColorHeader "Huvud..." 0
menuText W PgnColorAnno "Noteringar..." 0
menuText W PgnColorComments "Kommentarer..." 0
menuText W PgnColorVars "Varianter..." 0
menuText W PgnColorBackground "Bakgrund..." 0
menuText W PgnHelp "Hjlp" 0
menuText W PgnHelpPgn "PGN hjlp" 0
menuText W PgnHelpIndex "Index" 0
translate W PgnWindowTitle {PGN version av partiet} 

# Crosstable window menus:
menuText W CrosstabFile "Fil" 0
menuText W CrosstabFileText "Skriv ut till textfil..." 9
menuText W CrosstabFileHtml "Skriv ut till HTML-fil..." 9
menuText W CrosstabFileLaTeX "Skriv ut till LaTeX-fil..." 9
menuText W CrosstabFileClose "Stng resultattabellsfnstret" 0
menuText W CrosstabEdit "Redigera" 0
menuText W CrosstabEditEvent "Evenemang" 0
menuText W CrosstabEditSite "Plats" 0
menuText W CrosstabEditDate "Datum" 0
menuText W CrosstabOpt "Presentation" 0
menuText W CrosstabOptAll "Alla-mter-alla" 0
menuText W CrosstabOptSwiss "Schweizer" 0
menuText W CrosstabOptKnockout "Knock Out" 0
menuText W CrosstabOptAuto "Auto" 1
menuText W CrosstabOptAges "lder i r" 8
menuText W CrosstabOptNats "Nationalitet" 0
menuText W CrosstabOptRatings "Ranking" 0
menuText W CrosstabOptTitles "Titlar" 0
menuText W CrosstabOptBreaks "Tie-break pong" 4
menuText W CrosstabOptDeleted "Inkludera raderade partier" 8 
menuText W CrosstabOptColors "Frg (endast Schweizer)" 0
menuText W CrosstabOptColumnNumbers "Numrerade kolumner (Endast alla-mot-alla)" 2 
menuText W CrosstabOptGroup "Gruppresultat" 0
menuText W CrosstabSort "Sortera" 0
menuText W CrosstabSortName "Namn" 0
menuText W CrosstabSortRating "Ranking" 0
menuText W CrosstabSortScore "Resultat" 0
menuText W CrosstabColor "Frg" 0
menuText W CrosstabColorPlain "Ren text" 0
menuText W CrosstabColorHyper "Hypertext" 0
menuText W CrosstabHelp "Hjlp" 0
menuText W CrosstabHelpCross "Hjlp fr resultattabell" 0
menuText W CrosstabHelpIndex "Hjlpindex" 0
translate W SetFilter {Bestm filter}
translate W AddToFilter {Utka filter}
translate W Swiss {Schweizer}
translate W Category {Kategori} 

# Opening report window menus:
menuText W OprepFile "Fil" 0
menuText W OprepFileText "Skriv ut till textfil..." 9
menuText W OprepFileHtml "Skriv ut till HTML-fil..." 9
menuText W OprepFileLaTeX "Skriv ut till LaTeX-fil..." 9
menuText W OprepFileOptions "Alternativ..." 0
menuText W OprepFileClose "Stng rapportfnstret" 0
menuText W OprepFavorites "Favoriter" 1 
menuText W OprepFavoritesAdd "Lgg till rapport..." 0 
menuText W OprepFavoritesEdit "Redigera favoritrapport..." 0 
menuText W OprepFavoritesGenerate "Skapa rapport..." 0 
menuText W OprepHelp "Hjlp" 0
menuText W OprepHelpReport "Hjlp fr ppningsrapporter" 0
menuText W OprepHelpIndex "Hjlpindex" 0

# Repetoar editor:
menuText W RepFile "Fil" 0
menuText W RepFileNew "Ny" 0
menuText W RepFileOpen "ppna..." 0
menuText W RepFileSave "Spara..." 0
menuText W RepFileSaveAs "Spara som..." 5
menuText W RepFileClose "Stng fnster" 0
menuText W RepEdit "Redigera" 0
menuText W RepEditGroup "Lgg till grupp" 4
menuText W RepEditInclude "Lgg till inkluderad variant" 4
menuText W RepEditExclude "Lgg till exkluderad variant" 4
menuText W RepView "Visa" 0
menuText W RepViewExpand "Expandera alla grupper" 0
menuText W RepViewCollapse "Implodera alla grupper" 0
menuText W RepSearch "Sk" 0
menuText W RepSearchAll "Hela ppningsrepetoaren..." 0
menuText W RepSearchDisplayed "Endast visade varianter..." 0
menuText W RepHelp "Hjlp" 0
menuText W RepHelpRep "Hjlp fr spelppningsrepetoar" 0
menuText W RepHelpIndex "Hjlpindex" 0
translate W RepSearch "Sk i spelppningsrepetoar"
translate W RepIncludedLines "inkluderade varianter"
translate W RepExcludedLines "exkluderade varianter"
translate W RepCloseDialog {Du har osparade ndringar i repertoaren.

Vill du verkligen fortstta och frlora dina frndringar?
}

# Header search:
translate W HeaderSearch {Sk i partihuvud}
translate W GamesWithNoECO {Partier utan ECO kod?}
translate W GameLength {Partilngd}
translate W FindGamesWith {Hitta flaggade partier}
translate W StdStart {Normal utgngsstllning}
translate W Promotions {Frvandlingar}
translate W Comments {Kommentarer}
translate W Variations {Varianter}
translate W Annotations {Noteringar}
translate W DeleteFlag {Raderingsflagga}
translate W WhiteOpFlag {Vits ppning}
translate W BlackOpFlag {Svarts ppning}
translate W MiddlegameFlag {Mittspel}
translate W EndgameFlag {Slutspel}
translate W NoveltyFlag {Nyhet}
translate W PawnFlag {Bondestruktur}
translate W TacticsFlag {Taktiska stllningar}
translate W QsideFlag {Damflygelsinitiativ}
translate W KsideFlag {Kungsflygelsinitiativ}
translate W BrilliancyFlag {Utmrkt parti}
translate W BlunderFlag {Bortsttningar}
translate W UserFlag {Anvndare}
translate W PgnContains {PGN innehller text}

# Game list window:
translate W GlistNumber {Nummer}
translate W GlistWhite {Vit}
translate W GlistBlack {Svart}
translate W GlistWElo {Elo, v}
translate W GlistBElo {Elo, sv}
translate W GlistEvent {Evenemang}
translate W GlistSite {Plats}
translate W GlistRound {Rond}
translate W GlistDate {Datum}
translate W GlistYear {r}
translate W GlistEDate {Startdatum}
translate W GlistResult {Resultat}
translate W GlistLength {Lngd}
translate W GlistCountry {Land}
translate W GlistECO {ECO}
translate W GlistOpening {ppning}
translate W GlistEndMaterial {Slutmaterial}
translate W GlistDeleted {Raderad}
translate W GlistFlags {Flaggor}
translate W GlistVars {Varianter}
translate W GlistComments {Kommentarer}
translate W GlistAnnos {Noteringar}
translate W GlistStart {Start}
translate W GlistGameNumber {Partinummer}
translate W GlistFindText {Sk text}
translate W GlistMoveField {Drag}
translate W GlistEditField {Konfiguration}
translate W GlistAddField {Lgg till}
translate W GlistDeleteField {Ta bort}
translate W GlistWidth {Bredd}
translate W GlistAlign {Justering}
translate W GlistColor {Frg}
translate W GlistSep {Separator}

# Maintenance window:
translate W DatabaseName {Databasnamn:}
translate W TypeIcon {Ikontyp:}
translate W NumOfGames {Partier:}
translate W NumDeletedGames {Raderade partier:}
translate W NumFilterGames {Partier i filter:}
translate W YearRange {Tidsperiod:}
translate W RatingRange {Rankingintervall:}
translate W Description {Beskrivning} 
translate W Flag {Flagga}
translate W DeleteCurrent {Radera aktuellt parti}
translate W DeleteFilter {Radera partierna i filteret}
translate W DeleteAll {Radera alla partier}
translate W UndeleteCurrent {terta aktuellt parti}
translate W UndeleteFilter {terta partierna i filtret}
translate W UndeleteAll {terta alla partier}
translate W DeleteTwins {Radera dubbletter}
translate W MarkCurrent {Markera aktuellt parti}
translate W MarkFilter {Markera partierna i filtret}
translate W MarkAll {Markera alla partier}
translate W UnmarkCurrent {Avmarkera aktuellt parti}
translate W UnmarkFilter {Avmarkera partierna i filtret}
translate W UnmarkAll {Avmarkera alla partier}
translate W Spellchecking {Rttstava}
translate W Players {Spelare}
translate W Events {Evenemang}
translate W Sites {Platser}
translate W Rounds {Ronder}
translate W DatabaseOps {Databashantering}
translate W ReclassifyGames {ECO-klassificera partier}
translate W CompactDatabase {Komprimera databasen}
translate W SortDatabase {Sortera databasen}
translate W AddEloRatings {Lgg till Elo ranking}
translate W AutoloadGame {Ladda partinummer automatiskt}
translate W StripTags {Avlgsna PGN taggar}
translate W StripTag {Avlgsna taggar}
translate W Cleaner {Snygga till databasen}
translate W CleanerHelp {
Databasstdaren i Scid genomfr allt det underhll av databasen du kan vlja nedan p den aktiva databasen.

De nuvarande instllningarna i ECO-klassificering och Radera dubbletter kommer att appliceras om du vljer dessa tgrder.
}
translate W CleanerConfirm {
Nr du vl startat Databasstdaren kan du inte avbryta den!

P en stor databas kan detta ta ett bra tag. Tidstgngen beror p valda tgrder och deras instllningar.

r du sker p att du vill pbrja databasunderhllet nu?
}

# Comment editor:
translate W AnnotationSymbols  {Symboler:}
translate W Comment {Kommentar:}
translate W InsertMark {Infoga symbol} 

# Board search:
translate W BoardSearch {Positionsskningar}
translate W FilterOperation {Hantering av aktuellt filter:}
translate W FilterAnd {AND (Restriktivt filter)}
translate W FilterOr {OR (Ackumulativt filter)}
translate W FilterIgnore {IGNORE (Anvnd ej filter)}
translate W SearchType {Sktyp:}
translate W SearchBoardExact {Exakt position (alla pjser p samma rutor)}
translate W SearchBoardPawns {Bnder (samma material, alla bnder p samma rutor)}
translate W SearchBoardFiles {Filer (samma material, alla bnder p samma filer)}
translate W SearchBoardAny {Obestmt (samma material, bnder och pjser p valfria rutor)}
translate W LookInVars {Sk i varianter}

# Material search:
translate W MaterialSearch {Materialskning}
translate W Material {Material}
translate W Patterns {Stllningar}
translate W Zero {Inga/-en}
translate W Any {Flera}
translate W CurrentBoard {Aktuell stllning}
translate W CommonEndings {Vanliga slutspel}
translate W CommonPatterns {Vanliga stllningar}
translate W MaterialDiff {Skillnad i material}
translate W squares {flt}
translate W SameColor {Samma frg}
translate W OppColor {Motsatt frg}
translate W Either {Antingen eller}
translate W MoveNumberRange {Dragintervall}
translate W MatchForAtLeast {Trffa minst}
translate W HalfMoves {halvdrag}

# Game saving:
translate W Today {Idag}
translate W ClassifyGame {Klassificera parti}

# Setup position:
translate W EmptyBoard {Tm brdet}
translate W InitialBoard {Utgngsstllning}
translate W SideToMove {Frg vid draget}
translate W MoveNumber {Antal drag}
translate W Castling {Rockad}
translate W EnPassantFile {En Passant fil}
translate W ClearFen {Rensa FEN}
translate W PasteFen {Klistra in FEN}

# Replace move dialog:
translate W ReplaceMove {Erstt drag}
translate W AddNewVar {Lgg till ny variant}
translate W ReplaceMoveMessage {Det finns redan ett drag i denna stllning.

Du kan erstta detta drag, och frlora samtliga fljande, eller lgga till ditt drag som en ny variant.

(Om du stnger av "Frga fre erstt drag" i Alternativ:Drag menyn slipper du denna frga i framtiden.)}

# Make database read-only dialog:
translate W ReadOnlyDialog {Om du ger denna databas endast lsbar kan du inte gra ngra ndringar i den.
Inga partier kan sparas eller ersttas, och du kan inte ndra flaggor fr raderbara partier.
Alla sorteringsinstllningar eller ECO-klassificeringar kommer att vara temporra.

Du kan gra den skrivbar igen genom att helt enkelt stnga och ppna den igen.

Vill du verkligen ange att databasen endast ska vara lsbar?}

# Clear game dialog:
translate W ClearGameDialog {Detta parti har ndrats.

Vill du verkligen fortstta och frlora ndringarna?
}

# Exit dialog:
translate W ExitDialog {Vill du verkligen avsluta Scid?}
translate W ExitUnsaved {De fljande databaserna har osparade frndringar. Om du avslutar nu, kommer dessa frndringar att g frlorade.} 

# Import window:
translate W PasteCurrentGame {Klistra in aktuellt parti}
translate W ImportHelp1 {Ange eller klistra in ett parti i PGN-format i omrdet ovan.}
translate W ImportHelp2 {Eventuella felaktigheter kommer att anges hr.}

# ECO Browser:
translate W ECOAllSections {alla ECO avdelningar}
translate W ECOSection {ECO avdelning}
translate W ECOSummary {Sammanfattning fr}
translate W ECOFrequency {Underkodsfrekvens fr}

# Opening Report:
translate W OprepTitle {ppningsrapport}
translate W OprepReport {Rapport}
translate W OprepGenerated {Skapad av}
translate W OprepStatsHist {Statistik och historik}
translate W OprepStats {Statistik}
translate W OprepStatAll {Rapporterade partier}
translate W OprepStatBoth {Bda med ranking}
translate W OprepStatSince {Sedan}
translate W OprepOldest {De ldsta partierna}
translate W OprepNewest {De yngsta partierna}
translate W OprepPopular {Aktuell popularitet}
translate W OprepFreqAll {Frekvens totalt:   }
translate W OprepFreq1   {Under det senaste ret: }
translate W OprepFreq5   {Under de 5 senaste ren: }
translate W OprepFreq10  {Under de 10 senaste ren: }
translate W OprepEvery {en gng var %u parti}
translate W OprepUp {kat %u%s gentemot samtliga r}
translate W OprepDown {minskat %u%s gentemot samtlliga r}
translate W OprepSame {ingen frndring gentemot samtliga r}
translate W OprepMostFrequent {Spelas mest av}
translate W OprepMostFrequentOpponents {Vanligaste motstndaren}
translate W OprepRatingsPerf {Ranking och resultat}
translate W OprepAvgPerf {Genomsnittranking och resultat}
translate W OprepWRating {Vits ranking}
translate W OprepBRating {Svarts ranking}
translate W OprepWPerf {Vits resultat}
translate W OprepBPerf {Svarts resultat}
translate W OprepHighRating {Partierna med hgst genomsnittranking}
translate W OprepTrends {Resultattrender}
translate W OprepResults {Lngd och frekvens}
translate W OprepLength {Partiets lngd}
translate W OprepFrequency {Frekvens}
translate W OprepWWins {Vita vinster: }
translate W OprepBWins {Svarta vinster: }
translate W OprepDraws {Remier:      }
translate W OprepWholeDB {hela databasen}
translate W OprepShortest {Kortaste vinster}
# translate W OprepShortWhite {De kortaste vita vinsterna}
# translate W OprepShortBlack {De kortaste svarta vinsterna}
translate W OprepMovesThemes {Drag och teman}
translate W OprepMoveOrders {Dragordning fr att n rapportstllningen}
translate W OprepMoveOrdersOne \
  {Stllningen nddes bara genom en dragordning:}
translate W OprepMoveOrdersAll \
  {Det fanns %u dragordningar som ledde fram denna stllning:}
translate W OprepMoveOrdersMany \
  {Det fanns %u dragordningar som ledde fram denna stllning. De %u vanligaste r:}
translate W OprepMovesFrom {Drag frn rapportstllningen}
translate W OprepMostFrequentEcoCodes {De mest frekommande ECO-koderna}
translate W OprepThemes {Positionella teman}
translate W OprepThemeDescription {Temanfrekvens de frsta %u dragen av varje parti}
# translate W OprepThemeDescription {Antal teman vid drag %u}
translate W OprepThemeSameCastling {Rockad p samma flygel}
translate W OprepThemeOppCastling {Rockad p olika flyglar}
translate W OprepThemeNoCastling {Ingen har gjort rockad}
translate W OprepThemeKPawnStorm {Bondestorm p kungsflygeln}
translate W OprepThemeQueenswap {Dambyte}
translate W OprepThemeWIQP {Isolerad vit dambonde} 
translate W OprepThemeBIQP {Isolerad svart dambonde}
translate W OprepThemeWP567 {Vita bonde p 5/6/7e raden}
translate W OprepThemeBP234 {Svart bonde p 2/3/4e raden}
translate W OprepThemeOpenCDE {ppen c/d/e linje}
translate W OprepTheme1BishopPair {Endast den ena sidan har lparparet}
translate W OprepEndgames {Slutspel}
translate W OprepReportGames {Antal partier i rapporten}
translate W OprepAllGames    {Samtliga partier}
translate W OprepEndClass {Material i slutstllningen}
translate W OprepTheoryTable {Teorisammanstllning}
translate W OprepTableComment {Skapad frn de %u hgst rankade partierna.}
translate W OprepExtraMoves {Ytterligare antal drag i notfrteckningen}
translate W OprepMaxGames {Maximalt antal partier i sammanstllningen}
translate W OprepViewHTML {Visa HTML}
translate W OprepViewLaTeX {Visa LaTeX}

# Player Report:
translate W PReportTitle {Spelarrapport} 
translate W PReportColorWhite {med de vita pjserna} 
translate W PReportColorBlack {med de svarta pjserna} 
translate W PReportMoves {efter %s} 
translate W PReportOpenings {ppningar} 
translate W PReportClipbase {Tm urklippsdatabasen och kopiera liknande partier dit} 


# Piece Tracker window:
translate W TrackerSelectSingle {Vnsterklicka fr att vlja denna pjs.} 
translate W TrackerSelectPair {Vnsterklicka fr att vlja denna pjs; anvnd hger musknapp fr att ocks vlja den relatede pjsen.}
translate W TrackerSelectPawn {Vnsterklicka fr att vlja denna pjs; anvnd hger musknapp fr att vlja alla 8 bnder.}
translate W TrackerStat {Statistik}
translate W TrackerGames {% partier med drag till rutan}
translate W TrackerTime {% tid p varje ruta}
translate W TrackerMoves {Drag}
translate W TrackerMovesStart {Ange vid vilket drag skningen ska brja.}
translate W TrackerMovesStop {Ange vid vilket drag skningen ska sluta.}

# Game selection dialogs:
translate W SelectAllGames {Alla partier i databasen}
translate W SelectFilterGames {Endast partierna i filtret}
translate W SelectTournamentGames {Endast partierna i den aktuella turneringen}
translate W SelectOlderGames {Endast ldre partier}

# Delete Twins window:
translate W TwinsNote {Partier mste minst ha samma spelare fr att kunna identifieras som dubbletter samt uppfylla andra kriterier du kan ange nedan. Nr dubbletter hittas raderas det kortare partiet.
Tips: det bsta r att anvnda rttstavningen innan dubblettjmfrelsen eftersom detta frbttrar mjligheten fr upptckt av dubbletter.}
translate W TwinsCriteria {Kriterium: Dubbletter mste ha...}
translate W TwinsWhich {Ange vilka partier som ska jmfras}
translate W TwinsColors {Samma frger?}
translate W TwinsEvent {Samma evenemang?}
translate W TwinsSite {Samma plats?}
translate W TwinsRound {Samma rond?}
translate W TwinsYear {Samma r?}
translate W TwinsMonth {Samma mnad?}
translate W TwinsDay {Samma dag?}
translate W TwinsResult {Samma resultat?}
translate W TwinsECO {SammaECO kod?}
translate W TwinsMoves {Samma drag?}
translate W TwinsPlayers {Jmfr spelarnas namn:}
translate W TwinsPlayersExact {Exakt kopia}
translate W TwinsPlayersPrefix {Endast de 4 frsta bokstverna}
translate W TwinsWhen {Nr dubbletter raderas}
translate W TwinsSkipShort {Ignorera alla partier som r kortare n 5 drag?}
translate W TwinsUndelete {terta alla partier frst?}
translate W TwinsSetFilter {Filtrera alla raderade dubbletter?}
translate W TwinsComments {Spara alltid partier med kommentarer?}
translate W TwinsVars {Spara alltid partier med varianter?}
translate W TwinsDeleteWhich {Ange vilket parti som ska raderas:} 
translate W TwinsDeleteShorter {Det kortare pariet} 
translate W TwinsDeleteOlder {Partiet med lgst nummer} 
translate W TwinsDeleteNewer {Partiet med hgst nummer} 
translate W TwinsDelete {Radera partier}

# Name editor window:
translate W NameEditType {Typ av namn att redigera}
translate W NameEditSelect {Partier att redigera}
translate W NameEditReplace {Erstt}
translate W NameEditWith {med}
translate W NameEditMatches {Matchar: Tryck Ctrl+1 till Ctrl+9 fr att vlja}

# Classify window:
translate W Classify {Klassificera}
translate W ClassifyWhich {ECO-klassificera vilka partier}
translate W ClassifyAll {Alla partier (skriv ver gamla ECO koder)}
translate W ClassifyYear {Alla partier spelade under det senaste ret}
translate W ClassifyMonth {Alla partier spelade den senaste mnaden}
translate W ClassifyNew {Endast partier som nnu ej klassificerats}
translate W ClassifyCodes {ECO koder som ska anvndas}
translate W ClassifyBasic {Enbart standardkoder ("B12", ...)}
translate W ClassifyExtended {Scid extensioner ("B12j", ...)}

# Compaction:
translate W NameFile {Namnfil}
translate W GameFile {Partifil}
translate W Names {Namn}
translate W Unused {Ej anvnd}
translate W SizeKb {Storlek (kb)}
translate W CurrentState {Aktuell status}
translate W AfterCompaction {Efter komprimering}
translate W CompactNames {Namn, komprimera namnfil}
translate W CompactGames {Partier, komprimera partifil}

# Sorting:
translate W SortCriteria {Kriterium}
translate W AddCriteria {Lgg till kriterium}
translate W CommonSorts {Normal sortering}
translate W Sort {Sortering}

# Exporting:
translate W AddToExistingFile {Lgg till partier till en existerande fil?}
translate W ExportComments {Exportera kommentarer?}
translate W ExportVariations {Exportera varianter?}
translate W IndentComments {Dra in kommentarer?}
translate W IndentVariations {Dra in varianter?}
translate W ExportColumnStyle {Kolumnstil (ett drag per rad)?}
translate W ExportSymbolStyle {Symbolbaserade kommentarer:}
translate W ExportStripMarks {Avlgsna koder fr flt och pilar frn kommentarerna?} 

# Goto game/move dialogs:
translate W LoadGameNumber {Ange partiets nummer:}
translate W GotoMoveNumber {G till drag nummer:}

# Copy games dialog:
translate W CopyGames {kopiera partier}
translate W CopyConfirm {
 Vill du verkligen kopiera
 de [thousands $nGamesToCopy] filtrerade partierna
 ur databasen "$fromName"
 till databasen "$targetName"?
}
translate W CopyErr {Kan ej kopiera partier}
translate W CopyErrSource {klldatabasen}
translate W CopyErrTarget {mldatabasen}
translate W CopyErrNoGames {har inga partier i filtret}
translate W CopyErrReadOnly {kan bara lsas}
translate W CopyErrNotOpen {r ej ppen}

# Colors:
translate W LightSquares {Ljusa flt}
translate W DarkSquares {Mrka flt}
translate W SelectedSquares {Valda flt}
translate W SuggestedSquares {Freslagna flt}
translate W WhitePieces {Vita pjser}
translate W BlackPieces {Svarta pjser}
translate W WhiteBorder {Vit kantlinje}
translate W BlackBorder {Svart kantlinje}

# Novelty window:
translate W FindNovelty {Hitta nyhet}
translate W Novelty {Nyhet}
translate W NoveltyInterrupt {Nyhetsskningen avbrts}
translate W NoveltyNone {Inga nyheter hittades i detta parti}
translate W NoveltyHelp {
Scid kommer att frska hitta det frsta draget som leder till en position som inte annars finns i denna databas eller i spelppingsboken baserad p ECO.
}

# Upgrading databases:
translate W Upgrading {Uppdaterar}
translate W ConfirmOpenNew {
Denna databas r i ett gammal format (Scid 2) och kan inte ppnas i Scid 3, men en databas i det nya formatet (Scid 3) har redan skapats.

Vill du ppna den senare databasen istllet?
}
translate W ConfirmUpgrade {
Denna databas r i ett gammal format (Scid 2). En databas i det nyare formatet mste skapas innan den kan anvndas i Scid 3.

Genom att uppdatera skapas en databas i det nya formatet med samma innehll; uppdateringen ndrar ingenting i den gamla databasen.

Detta kan ta ett tag men behver bara gras en gng. Om du tycker det tar alltfr lng tid kan du avbryta processen.

Vill du uppdatera denna databas nu?
}

# Recent files options:
translate W RecentFilesMenu {Antal senast ppnade filer i Arkivmenyn}
translate W RecentFilesExtra {Antal senast ppnade filer i extra undermeny}

# My Player Names options:
translate W MyPlayerNamesDescription {
Ange en lista p dina favoritspelare hr nedanfr. Skriv ett namn per rad. Jokertecken ("?", t ex, motsvarar ett enstaka tecken medan "*" str fr flera tecken) r tilltna.

Varje gng ett parti med en spelare vars namn str i denna lista ppnas kommer brdet automatiskt att vridas s att partiet visas frn spelarens perspektiv.
} 

}


############################################################
#
# Swedish tips section:

set tips(W) {
  {
    Scid har ver 30 <a Index>hjlpsidor</a>, och i de flesta fnster kan du
    genom att trycka <b>F1</b> f hjlp om det fnster du fr tillfllet har
    aktivt.
  }
  {
    Vissa fnster (t ex partiinformation och <a Switcher>databasvljaren</a>) 
    har en meny fr hger musknapp. Prova att hgerklicka i varje fnster s
    ser du vilka som har det och vilka funktioner du kommer t den vgen.
  }
  {
    Du kan ange drag p mer n ett stt, s du kan vlja vilket som passar dig
    bst. Du kan anvnda musen (med eller utan dragfrslag) eller tangentbordet
    (med eller utan autokomplettering). Ls hjlpsidan fr 
    <a Moves>att ange drag</a> fr mer information.
  }
  {
    Om du har databaser du ofta ppnar s kan du lgga till ett 
    <a Bookmarks>bokmrke</a> fr varje databas. Du kommer d att kunna ppna 
    databaserna snabbare via bokmrkesmenyn.
  }
  {
    Du kan se alla drag i det aktuella partiet (inklusive varianter och kommentarer)
    genom att ppna <a PGN>PGN-fnstret</a>.
    Du navigerar igenom partiet i PGN-fnstret genom att klicka p valfritt drag med
    vnster musknapp. Genom att klicka p draget med mellan- eller hgermusknapp s
    fr du en frhandsvisning av just den stllningen.
  }
  {
    Du kan kopiera partier mellan databaserna i <a Switcher>databasvljaren</a> genom
    att dra-och-slppa dem mellan respektive databas.
  }
  {
    Scid kan ppna PGN filer, ven de som r komprimerade med Gzip (dvs har en .gz filndelse). 
    PGN filer ppnas med enbart lsrttigheter, s om du vill redigera en PGN fil i Scid 
    mste du kopiera filen till en Scid databas med hjlp av <a Switcher>databasvljaren</a>.
  }
  {
    Om du ofta anvnder <a Tree>Trdfnstret</a> med stora databaser, r det vrt att vlja
    <b>Fyll cache fil</b> frn Arkivmenyn i Trdfnstret. Detta innebr att trdstatistik fr 
    mnga av de vanligare stllningarna sparas, vilket ger en snabbare trdtkomst fr databasen
    ifrga.
  }
  {
    <a Tree>Trdfnstret</a> kan visa alla drag frn den aktuella stllningen. Men om ocks vill 
    se alla dragfljder som har lett till denna stllning kan du f fram det genom att skapa en
   <a OpReport>ppningsrapport</a>.
  }
  {
    Du kan vnster- eller hgerklicka i en kolumn i <a GameList>partilistan</a> fr att ndra 
    dess bredd.
  }
  {
    Med <a PInfo>spelarinformationen</a> aktuell (klicka p endera spelarens namn under brdet i 
    huvudfnstret fr att f fram den) r det enkelt att <a Searches Filter>filtrera</a> fram partier
    av en srskild spelares enskilda resultat. Klicka bara p valfritt vrde som har angivits med
    <red>rd text</red>.
  }
  {
    Nr du studerar ppningar kan det vara en pong att markera valen <b>Bnder</b> eller <b>Filer</b> i 
    <a Searches Board>Sk aktuell position</a>. Genom dessa val kan du hitta andra ppningar som ger
    liknande bondestrukturer.
  }
  {
    Du kan hgerklicka i partiinformationsdelen av huvudfnstret (under brdet) fr att f fram en 
    kontextmeny. Du kan t ex gra s att Scid dljer nsta drag i ett parti, vilket kan vara anvndbart 
    om du vill trna genom att "gissa" nsta drag.
  }
  {
    Om du ofta <a Maintenance>underhller</a> stora databaser kan du utfra flera underhllsuppgifter 
    vid samma tillflle via <a Maintenance Cleaner>databasverktyget</a>.
  }
  {
    Om du har en stor databas dr de flesta partierna har ett evenemangsdatum och du vill ha partierna i 
    datumordning br du vervga att <a Sorting>sortera</a> den p evenemangsdatum i frsta hand och 
    evenemang i andra hand, istllet fr datum och evenemang, d detta kommer att hlla turneringspartierna
    frn olika datum samman. Under frutsttning att alla partier har samma evenemangsdatum naturligtvis).
    Alternativt kan du se till att flten evenemang, rond och datum r s enhetliga och korrekta som mjligt.
    (ms).
  }
  {
    Det kan vara en bra ide att <a Maintenance Spellcheck>stavningskontrollera</a> din databas innan du 
    <a Maintenance Twins>raderar dubbletter</a> d Scid har strre mjlighet att hitta dubbletterna och 
    markera dessa fr borttagning.
  }
  {
    <a Flags>Flaggor</a> r anvndbara fr att markera upp partier med karaktristika du vill ska p senare,
    ssom bondestllning, taktiska finesser, osv. Du kan ska p flaggor nr du sker p flt i partihuvudet.
  }
  {
    Om du gr igenom ett parti, och helt enkelt vill testa en ny variant utan att frndra partiet i sig, kan 
    du sl p Frskslget (Trial mode) genom att trycka <b>Ctrl+Mellanslag</b> eller frn verktygsraden. terg till
    ursprungspartiet nr du r klar.
  }
  {
    Om du vill hitta det mest betydelsefulla partiet (med hgst rankade spelare) i en viss position kan du
    ppna <a Tree>Trdfnstret</a> och i denna ppna listan med de bsta partierna. I trdfnstret kan du till
    och med begrnsa partierna till endast ett srskilt resultat.
  }
  {
    Ett bra stt att studera en ppning r att i en stor databas sl p trningslget i <a Tree>Trdfnstret</a>, 
    och sedan spela igenom databasen fr att se vilka varianter som frekommer oftast.
  }
  {
    Om du har tv databaser ppna, och vill ha ett varianttrd att studera medan du gr igenom ett parti
    i den andra databasen kan du <b>lsa</b> trdet i den databasen och sedan byta till den andra.
  }
  {
    <a Tmt>Turneringsskaren (tournament finder)</a> r inte bara anvndbar fr att lokalisera en srskild 
    turnering. Du kan ocks anvnda den fr att ska efter turneringar en specifik spelare nyligen deltagit 
    i, eller att blddra genom turneringar som genomfrts i ett visst land.
  }
  {
    Det finns ett antal vanliga stllningstyper definierade i <a Searches Material>Sk material/stllning</a>
    fnstret som du kan ha nytta av nr du studerar ppningar och mittspel.
  }
  {
    Nr du sker p <a Searches Material>material eller stllning</a> kan det ofta vara frdelaktigt att begrnsa
    skningen till sdana partier dr stllningen eller materialet frekommit i tminstone ngra drag. Du slipper
    du f med trffar dr situationen du sker uppkom helt tillflligt.
  }
  {
    Om du har en viktig databas du inte vill radera av misstag kan du vlja  <b>Enbart lsbar</b> frn <b>Arkiv</b>
    menyn efter att du har ppnat den. Alternativt kan du stta dess filrttigheter till enbart lsrttigheter.
  }
  {
    Om du anvnder XBoard eller WinBoard (eller ngot annat program som kan hantera FEN notation via urklippshanteraren)
    och vill kopiera den aktuella stllningen frn ditt program r det snabbaste sttet att gra det s hr:
    Vlj <b>Copy Position</b> frn <b>File</b> menyn i Xboard/Winboard, vlj sedan <b>Klistra in utgngsstllning</b>
    i Redigera menyn i Scid.
  }
  {
    I <a Searches Header>Sk i huvud</a>, r spelare-, evenemang-, plats-, och rondnamn oknsliga fr stora eller sm
    bokstver och ger trffar varhelst de finns i ett namn. Om du vill kan du ange att du istllet vill att skningen <b>ska</b>
    ta versaler/gemener i beaktande. Genom att anvnda jokertecken inom citationstecken (dr "?" = motsvarar obestmt
    enskilt tecken och "*" = noll eller flera tecken). Om du exempelvis anger "*BEL" (med citationstecken) i det platsfltet
    hittar du alla partier spelade i Belgien, men exkluderar de som spelats i Belgrad.
  }
  {
    Om du vill redigera ett drag i ett parti utan att frlora alla de drag som spelats efter detta kan du ppna
    <a Import>Importera ett parti i PGN-format</a> fnstret i Verktygsmenyn. Klicka dr p <b>Klistra in aktuellt parti</b> 
    , redigera partiet och avsluta med <b>Importera</b>.
  }
  {
    Om du har en ECO klassificeringsfil laddad, kan du n den mest exakt klassificerade stllningen fr det aktuella partiet
    genom att vlja <b>Identifiera ppning</b> i <b>Partier</b> menyn (kortkommando: Ctrl+Shift+D).
  }
  {
    Nr du vill se hur stor en fil r, eller vill se nr den senast redigerades innan du ppnar den kan du anvnda
    <a Finder>file finder</a> (Arkiv - Sk filer).
  }
  {
    En <a repetoire>repetoarfil</a> r ett utmrkt stt att hlla koll p dina favoritppningar, eller hitta partier dr
    dr de har spelats. Nr du vl har skapat en repetoarfil kan du genomska nya filer utifrn repetoarfilen, och titta 
    igenom alla partier med just dina ppningar.
  }
  {
    Genom att skapa en <a OpReport>ppningsrapport</a> har du en utmrkt mjlighet att lra dig en ny spelppning. Du kan f
    information om resultat, hur remiaktig den r, vilka vanliga positionella teman som dyker upp, och mycket mer.
  }
  {
    Du kan kommentera den aktuella stllningen med de vanligaste symbolerna (!, !?, +=, etc) utan att behva anvnda 
    <a Comment>kommentarseditorn<a>. Dr du exempelvis vill ange ett bra drag skriver du "!" och trycker sedan ENTER
    s lggs "!" symbolen till draget. Se ven hjlpsidan <a Moves>ange drag</a> fr mer detaljerad information.
  }
  {
    Om du blddrar igenom ppningarna i en databas i <a Tree>trdfnstret</a>, fr du en anvndbar verblick ver hur
    vl ppningen fungerar i sentida partier mellan hgrankade spelare om du ppnar statistikfnstret (kortkommando: Ctrl+I).
  }
  {
    Du ndrar enkelt huvudfnstrets brdstorlek genom att hlla nere <b>Ctrl</b> och <b>Shift</b> tangenterna, samtidigt
    som du trycker hger- eller vnster piltangent.
  }
  {
    Efter genomfrd <a Searches>skning</a>, r det enkelt att navigera genom urvalet genom att hlla nere <b>Ctrl</b> 
    tangenten samtidigt som du trycker upp- eller nerpiltangenterna fr att g till fregende eller nsta parti i 
    <a Searches Filter>urvalet</a>.
  }
{
  Du kan relativt enkelt rita pilar och frga rutor till dina kommentarer. ppna <b>Kommentarseditorn</b>, klicka p <b>Infoga symbol</b> och vlj nskad frg. Om du nu klicka p en frsta ruta, och drefter klickar p en andra s dras en pil i nskad frg frn den frsta till den andra rutan. Klickar du bara p en ruta, blir den frgad.
  }
}



############################################################
#
# Swedish help pages:

# Basic help pages completed, no links no other sections.

##########
# Index
#
set helpTitle(W,Index) "Innehllsfrteckning"
set helpText(W,Index) {<h1>Hjlp med Scid: Innehllsfrteckning</h1>

<h3>Komma igng och allmnt om Scid</h3>
<h5>Under versttning</h5>
<p>Fljande texter och dess lnkar r under versttning. Detta pbrjades i Scid 3.4 beta 1. 
Detta betyder att menyerna r versatta. Rubriktexterna br kunna vara versatta till Scid 3.4 men alla lnkar
frn rubriktexterna r frmodligen inte det. /Martin S.</p>

<ul>
<li><a Guide><b>Komma igng</b> med Scid</a> <red>(Ls detta frst)</red></li>
<li><a Hints><b>Tips</b> om hur du fr ut mer av Scid</a></li>
<li><a MainWindow><b>Huvudfnstret</b></a></li>
<li><a Menus><b>Menyerna</b></a> <red>(uppdaterad!)</red></li>
<li><a Moves>Ange <b>drag</b></a> <red>(uppdaterad!)</red></li>
<li><a Searches><b>Ska</b> i Scid</a></li>
<li><a Clipbase>Att anvnda <b>Clipbase (urklippsdatabasen)</b></a></li>
<li><a Annotating><b>Kommentera partier</b></a> <red>(Ny!)</red></li>
</ul>


<h3>Other Scid windows</h3>
<h5>Ej versatta</h5>
<p>versttningen av fljande hjlpavsnitt har nnu (2002 07 27) inte pbrjats. Detta betyder att menyerna r p engelska, likas samtliga 
rubriktexter. Dremot <b>kan det hnda</b> att vissa lnktexter har versatts i samband med versttningen av fregende hjlpavsnitt. 
/Martin S.</p>

<ul>
<li><a Analysis><b>Analysis</b> window</a></li>
<li><a Comment><b>Comment editor</b> window</a></li>
<li><a Crosstable><b>Crosstable</b> window</a></li>
<li><a Switcher><b>Database Switcher</b> window</a></li>
<li><a Email><b>Email</b> chess manager window</a></li>
<li><a Finder><b>File Finder</b> window</a></li>
<li><a GameList><b>Game List</b> window</a></li>
<li><a Import><b>Import game</b> window</a></li>
<li><a OpReport><b>Opening Report</b> window</a></li>
<li><a PGN><b>PGN</b> (game text) window</a></li>
<li><a PTracker><b>Piece Tracker</b></a></li>
<li><a PInfo><b>Player Info</b> window</a></li>
<li><a Repetoire><b>Repetoareditor</b> window</a></li>
<li><a Tmt><b>Tournament Finder</b> window</a></li>
<li><a Tree><b>Tree</b> window</a></li>
<li><a Graphs><b>Graph</b> windows</a></li>
<li><a TB>Using <b>Tablebases</b> in Scid</a></li>
</ul>

<h3>Other utilities and information</h3>
<ul>
<li><a Bookmarks><b>Bookmarks</b></a></li>
<li><a Cmdline>Command-line options</a></li>
<li><a Compact><b>Compacting</b> a database</a></li>
<li><a Maintenance><b>Database maintenance</b> tools</a></li>
<li><a ECO><b>ECO</b> openings classification</a></li>
<li><a EPD><b>EPD</b> files</a></li>
<li><a Export><b>Exporting</b> games to text files</a> <red>(updated!)</red></li>
<li><a Flags>Game <b>Flags</b></a></li>
<li><a LaTeX>Using <b>LaTeX</b> with Scid</a></li>
<li><a Options><b>Options</b> and preferences</a></li>
<li><a Sorting><b>Sorting</b> a database</a></li>
<li><a Pgnscid><b>Pgnscid</b>: converting PGN files</a></li>
<li><a NAGs>Standard <b>NAG</b> annotation values</a></li>
<li><a Formats>Scid database <b>file formats</b></a></li>
<li><a Author>Contact information</a></li>
</ul>

<p><footer>(Uppdaterad: Scid 3.4, Juli 2002)</footer></p>
}
### Slut index


####################
### Quick Guide help:

set helpTitle(W,Guide) "Komma igng med Scid"
set helpText(W,Guide) {<h1>Komma igng med Scid</h1>
<p>
Scid r en schackdatabashanterare som du kan anvnda till att blddra och <a Searches>ska</a> (enligt kriterier du stller upp) igenom 
databaser med schackpartier. Du kan ocks redigera de partier du vill.
</p>
<p>
Scid anvnder sitt eget <a Formats>database format</a> baserat p tre filer. Det r mycket kompakt och snabbt, men kan konvertera svl 
till som frn PGN (Portable Game Notation) standarden om man s nskar. Scids <a PGN>PGN fnster</a> visar texten till det aktuella
partiet i PGN format.
</p>
<p>
Du kan anvnda Scid till att lgga till och radera partier i en databas genom att anvnda svl mus som tangentbordet fr att skriva in
drag. Se vidare <a Moves>att skriva in drag</a> fr en noggrannare beskrivning.
</p>
<p>
Du kan ocks anvnda Scid fr att hantera <a PGN>PGN</a> filer genom att klistra in PGN-text i Scids <a Import>Importfnster</a> 
eller genom att ppna en PGN-fil i Scid. PGN-filer kan dock inte redigeras av Scid (de ppnas skrivskyddade). Eftersom PGN-filer
anvnder mer minne och laddas lngsammare rekommenderas du att konvertera stora PGN-filer till en Scid databas med verktyget
<a Pgnscid>pgnscid</a>.
</p>
<p>
Scids <a MainWindow>huvudfnster</a> (den med schackbrdet) visar det aktuella partiet och databasen i detalj. Du kan nr som helst ppna 
upp till fyra databaser (fem om du rknar med urklippsdatabasen <a Clipbase>clipbase</a>). Var och ett av dessa kommer att ha sitt eget aktuella
parti. (Partier med ID-numret 0 visar att detta r ett parti som nnu inte ingr i den aktuella databasen). Du blddrar mellan de ppnade databaserna
via <a Menus File>Filmenyn</a>.
</p>
<p>
Ls grna vriga hjlpsidor i <a Index>Innehllsfrteckningen</a> fr mer information.
</p>
<p>
Ls <a Author>kontaktinformationssidan</a> om du vill komma i kontakt med skaparen av Scid. Fr frgor om den svenska versttningen ska du
<b>inte</b> kontakta upphovsmannen utan istllet <a Translator>versttaren</a>.
</p>

<p><footer>(Updated: Scid 3.1, December 2001)</footer></p>
}


set helpTitle(W,Author) "Kontaktinformation"
set helpText(W,Author) {<h1>Kontaktinformation</h1>
<p>
Scids webbsajt finns p: <br>
<b><url http://scid.sourceforge.net/>http://scid.sourceforge.net/</url></b>
</p>
<p>
Dr kan du hmta den senaste versionen av Scid och andra de filerna till Scid som du kan ha behov av.
</p>
<p>
Skicka grna kommentarer, frgor, frslag eller buggrapporter till Scids skapare, Shane Hudson, p adressen:<br>
<b>sgh@users.sourceforge.net</b>
</p>

<p>Den svenska versttningen av Scid har gjorts av Martin Skjldebrand. Synpunkter p versttningen ska <b>inte</b>
skickas till Shane. Dremot fr du grna skicka kommentarer, frgor och frslag till rttningar till versttaren p adressen:<br>
<b>martin@skjoldebrand.org</b>
</p>
}

####################
### Hints page:
set helpTitle(W,Hints) "Scid Tips"
set helpText(W,Hints) {<h1>Scid Tips</h1>
<p>
Denna sida innehller anvndbara tips i form av frgor och svar. Genom att lsa igenom denna sida, kan du senare komma att
anvnda Scid bttre. Om du nyligen brjat anvnda Scid, s ls till en brjan <a Guide>Kom igng</a>.
Det mesta av informationen p denna sida finns refererad mer utfrligt p andra sidor i hjlpen. Du finner dem i <a Index>innehllsfrteckningen</a>.
Om har ngot du tips du tycker passar bra fr denna sida, s skicka den till <a Author>upphovsmannen</a>.
</p>

<h4>Kan Scid ladda en databas nr den startas?</h4>
<p>
Ja, du kan ange databaser, PGN filer eller <a EPD>EPD filer</a>
p kommandoraden som t ex;
<ul>
<li> <b>scid  mybase  games.pgn.gz</b> </li>
</ul>
som laddar Scid databasen <b>mybase</b> och dessutom laddar den Gzip-komprimerade PGN filen <b>games.pgn.gz</b>.
</p>

<h4>Finns det enklare stt att ndra storleken p brdet n via Alternativmenyn?</h4>
<p>
Ja, du kan anvnda kortkommandoen <b>Ctrl+Shift+VnsterPil</b> och <b>Ctrl+Shift+HgerPil</b> fr att frminska eller 
frtora brdets storlek.
</p>

<h4>Jag brukar trna genom att spela igenom partier, s jag vill inte att Scid visar nsta drag i partiinformationen
nedanfr brdet. Kan jag dlja detta p ngot stt?</h4>
<p>
Du kan dlja nsta drag genom att hgerklicka partiinformationen och vlja  <b>Dlj nsta drag</b> i menyn som ppnas.
</p>

<h4>Var finner jag ECO-koden fr ppningen p brdet?</h4>
<p>
ECO-koden visas p sista raden i partiinformationen nedanfr brdet i  <a MainWindow>huvudfnstret</a>,
om du har laddat ECO klassificeringsfilen (<b>scid.eco</b>). <br>
Hjlpsidan fr <a ECO>ECO koder</a> frklarar hur man laddar ECO klassificeringsfilen och stller in programmet s att
den laddas varje gng man startar Scid.
</p>

<h4>Jag hller p och matar in ett parti och befinner mig nu vid drag 30. Nu ser jag att drag 10 blev fel. Hur kan jag ndra
detta utan att gra om alltihop?</h4>
<p>
Du kan anvnda <a Import>Importfnstret</a>; se vidare <a Moves Mistakes>mata in drag</a> fr mer information.
</p>

<h4>Hur kopierar jag partier frn en databas till en annan?</h4>
<p>
Anvnd <a Switcher>databasvxlaren</a>. Drag frn klldatabasen till mldatabasen s kopierar du allt i klldatabasen till
mldatabasen. Genom att anvnda <a Searches Filter>filter</a> kan du begrnsa det du kopierar frn den ena databasen till den andra.
</p>

<h4>Varje gng jag anger ett drag som redan finns fr jag frgan "Erstt drag?". Hur undviker jag detta?</h4>
<p>
Du kan antingen stnga av <b>Frga fre erstt drag</b> valmjligheten i menyn <menu>Altervativ: Drag</menu</menu>; eller
tnk p att gra ndringarna genom att ta tillbaka dragen genom att hgerklicka. Det senare alternativet raderar drag helt ur
partiet.
</p>

<h4>Hur ndrar kolumnbredden i partilistan?</h4>
<p>
Hger- eller vnsterklicka p kolumntiteln fr den kolumn du vill ndra.
</p>

<h4>Hur anvnder jag trdfnstret fr ett filtrerade partier - till skillnad mot att anvnda den fr hela databasen?</h4>
<p>
Anvnd <a Clipbase>urklippsdatabasen (Clipbase)</a>. Filtera databasen att visa endast de partier du vill anvnda i trdet, 
kopiera sedan partierna till urklippsdatabasen (Clipbase) via <a Switcher>databasvxlaren</a>. ppna drefter trdfnstret
med den senare databasen som aktiv.
</p>

<h4>Trdet r lngsamt nr jag jobbar med stora databaser. Gr det att snabba upp den?</h4>
<p>
Spara trdcachen ofta s sparar du resultaten fr framtida anvndning. Se vidare cache-sektionen i hjlpen fr 
<a Tree>trdet</a> fr mer detaljerad information.
</p>

<h4>Kan jag redigera PGN texten fr ett parti direkt?</h4>
<p>
Du kan inte anvnda <a PGN>PGN</a> fnstret till att redigera det aktuella partiet, dremot kan du anvnda 
<a Import>Importfnstret</a>. ppna fnstret (kortkommando: <b>Ctrl+Shift+I</b>) och klicka p klistra in aktuellt parti
<b>Paste current game</b>, redigera partiet och klicka sedan p <b>Importera</b>.
</p>

<h4>I min databas finns mnga spelarnamn som r felstavade. Hur rttar jag allt detta?</h4>
<p>
Du kan rtta enstaka namn, eller gra en stavningskontroll fr hela databasen via menyvalen i <menu>Arkiv: Databasverktyg</menu>.
Se vidare hjlpen fr <a Maintenance Editing>databasunderhll</a>.
</p>

<h4>Jag har tv databaser ppna: den ena innehller mina egna partier, den andra r en massor med stormstarpartier.
Hur jmfr jag ett av mina egna partier mot partierna i databasen med stormstarpartier?</h4>
<p>
ppna <a Tree>trdfnstret</a> i databasen med stormstarpartier och vlj <term>Ls</term> fr att lsa trdet i den databasen. 
Nr du sedan byter till den andra databasen kommer trdet att fortstta visa informationen frn databasen med stormstarpartier.
</p>

<p><footer>(Uppdaterad: Scid 2.6,  augusti 2001)</footer></p>
}


#################
# Authors, translators
#

set helpTitle(W,Translator) "Den svenska versttningen"
set helpText(W,Translator) {<h1>Den svenska versttningen</h1>
<p>
Scids webbsajt finns p: <br>
<b><url http://scid.sourceforge.net/>http://scid.sourceforge.net/</url></b>. Dr kan du hmta den senaste versionen av Scid och 
andra de filerna till programmet som du kan ha behov av. Dr finns ocks den senaste versionen av den svenska sprkfilen.
</p>
<p>Den svenska versttningen av Scid har gjorts av Martin Skjldebrand. Skicka grna kommentarer, frgor och frslag till rttningar
till versttaren p adressen:<br>
<b>martin@skjoldebrand.org</b>
</p>
}

####################
### Main window help:

set helpTitle(W,MainWindow) "Huvudfnstret"
set helpText(W,MainWindow) {<h1>Scid: huvudfnstret</h1>
<p>
P brdet i huvudfnstret visas den aktuella stllningen i det aktiva partiet. Du fr ocks information om partiet och den
aktiva databasen. Fr ytterligare information om <a Menus>menyerna</a> och olika stt att <a Moves>ange drag</a> hnvisas till
andra hjlpsidor.
</p>

<h3>Att navigera i partier</h3>
<p>
Navigationsknapparna vid brdet har fljande funktioner (frn vnster till hger):
<ul>
<li> <button tb_start> G till utgngsstllningen. </li>
<li> <button tb_prev> Tillbaka ett drag. </li>
<li> <button tb_next> Framt ett drag. </li>
<li> <button tb_end> G till slutstllningen. </li>
<li> <button tb_invar> G in i varianten. </li>
<li> <button tb_outvar> G ur varianten. </li>
<li> <button tb_addvar> Lgg till ny variant. </li>
<li> <button autoplay_off> Start/stopp fr autospelslge (se nedan). </li>
<li> <button tb_trial> Start/stopp fr <a Moves Trial>frskslge</a>. </li>
<li> <button tb_flip> Rotera brdet 180 grader. </li>
<li> <button tb_coords> Visa/dlj koordinater. </li>
</ul>

<h4><name Autoplay>Autospelslge</name></h4>
<p>
I autospelslge gr Scid automatiskt bda spelarnas drag i det aktuella partiet. Frdrjningen mellan varje drag kan anges i
menyn <menu>Alternativ: Drag</menu> och sparas nr du sparar ndringarna av instllningsmjligheterna.
</p>
<p>
Kortkommandot <b>Ctrl+Z</b> startar eller avbryter autospelslget. Du kan ocks g ur autospelslge genom att trycka
 <b>Esc</b> tangenten.
</p>
<p>
Om du startar autospelslge nr <a Analysis>analysfnstret</a> r ppet <term>kommenteras</term> partiet: stllningsbedmningen 
och analysen av varje stllning lggs till som en ny variant vid varje drag.
Se hjlpen fr <a Analysis>analysfnstret</a> fr mer information.
</p>

<h3>Partiinformation</h3>
<p>
Nedanfr brdet visas information om det aktuella partiet. Denna del av huvudskrmen kallas <term>partiinformationsomrdet</term>.
P de tre frsta raderna ges grundinformation ssom spelarnas namn, resultat, datum och spelplats. Den fjrde raden aktuell
stllning och nsta drag.
</p>
<p>
Rad fem visar <a ECO>ECO</a> (Encyclopedia of Chess
Openings) koden fr den aktuella stllningen, om stllningen ingr i den ECO-fil som anvnds.
</p>
<p>
Nr man hgerklickar p partiinformationsomrdet visas en meny med instllningsmjligheter som r relevanta just fr denna del av
programmet. Du kan t ex vlja att dlja nsta drag (anvndbart om du trnar genom att "gissa" nsta drag i  partiet) eller radera
/terta det aktuella partiet. Kortkommandot fr denna funktion r funktionsknappen F9.
</p>

<h4>Slutspelsdatabaser</h4>
<p>
Partiinformationsomrdet visar och resultaten frn slutspelsdatabaserna om du har ngra installerade och om stllningen terfinns 
i dessa. Se hjlpsidan fr <a TB>slutspelsdatabaser</a> fr mer information.
</p>

<h3>Statusraden</h3>
<p>
Statusraden (lngst ner i huvudfnstret) visar information om den aktuella databasen.
Det frsta fltet visar partiets status: <b>XX</b> betyder att det har frndrats men nnu inte sparats, medan <b>--</b> 
betyder att partiet inte har ndrats, <b>%%</b>, slutligen, betyder att databasen r skrivskyddad (det gr inte att ndra i partiet.).
</p>
<p>
Om du vill, kan du ppna databasen skrivskyddad. ndra rttigheterna till scid-filerna (eller enbart indexfilen) genom att i UNIX(-lika)
system ge kommandot:
<b>chmod a-w myfile.si3</b>
vid kommandoraden.
</p>
<p>
Statusraden visar ocks hur mnga partiet som ingr i det aktiva <a Searches Filter>filtret</a>.
</p>

<p><footer>(Uppdaterad: Scid 3.1, december 2001)</footer></p>
}

####################
### Menus help screen:

set helpTitle(W,Menus) "Menyerna"
set helpText(W,Menus) {<h1>Menyerna</h1>

<h3><name File>Arkiv</name></h3>
<ul>
<li><menu>Ny</menu>: Skapar en ny, tom, Scid databas.</li>
<li><menu>ppna</menu>: ppnar en befintlig Scid databas.</li>
<li><menu>Stng</menu>: Stnger den aktiva Scid databasen.</li>
<li><menu>Sk filer</menu>: ppna <a Finder>skdialogen</a> fr filer.</li>
<li><menu>Bokmrken</menu>: Hanterar <a Bookmarks>bokmrken</a>.</li>
	<ul>
	<li><menu>Nytt bokmrke</menu>: Markerar den aktiva stllningen i partiet som ett bokmrke.</li>
	<li><menu>Spara bokmrke</menu>: Sparar bokmrket fr den aktiva stllningen i partiet.</li>
	<li><menu>Redigera bokmrken</menu>: Redigerar dina bokmrken.</li>
	<li><menu>Visa bokmrken som lista</menu>: Visar bokmrkena som lista, inte undermenyer.</li>
	<li><menu>Visa bokmrken i undermenyer</menu>: Visar bokmrkena som undermenyer, inte lista.</li>
	</ul>
<li><menu>Databasverktyg</menu>: <a Maintenance>Underhll</a> databasen.</li>
	<ul>
	<li><menu>Verktygsfnster</menu>: ppna/ stng verktygsfnstret.</li>
	<li><menu>Komprimera databasen</menu>: Komprimera databasen, avlgsna raderade partier och oanvnda namn.</li>
	<li><menu>Klassificera partier enligt ECO</menu>: Klassificera alla partier enligt ECO-systemet.</li>
	<li><menu>Sortera databasen</menu>: Sortera partierna i den aktiva databasen.</li>
  	<li><menu>Radera dubbletter</menu>: Raderar <a Maintenance Twins>dubblettpartier</a> i databasen.</li>
	<li><menu>Sk dubbletter"</menu>: ppna/ stng dubblettfnstret fr att ska dubblettpartier.</li>
	<li><menu>Stavningskontroll</menu>: Namnredigering och stavningskontroll.</li>
		<ul>
		<li><menu>Redigera namn</menu>: Redigerar spelarnamn utifrn rttstavningsfilen.</li>
		<li><menu>Stavningskontrollera namn</menu>: Stavningskontrollera namn utifrn rttstavningsfilen.</li>
		<li><menu>Stavningskontrollera evenemang</menu>: Stavningskontrollera evenemang utifrn rttstavningsfilen.</li>
		<li><menu>Stavningskontrollera platser</menu>: Stavningskontrollera platser utifrn rttstavningsfilen.</li>
		<li><menu>Stavningskontrollera ronder</menu>: Stavningskontrollera ronder utifrn rttstavningsfilen.</li>
  		</ul>
	</ul>	
<li><menu>Skrivskyddad</menu>: Avlgsna temporrt redigeringsmjligheterna till databasen.</li>
<li><menu>Byt databas</menu>: Byt till en annan ppnad databas.</li>
	<ul>
		<li><menu>Base 1/2/3/4/5</menu>: Hr byter du mellan de olika databaserna i databasvxlarna, inklusive <a Clipbase>urklippsdatabasen</a>.</li>
	</ul>
<li><menu>Avsluta</menu>: Avslutar Scid. </li>
</ul>

<h3>Redigera</h3>
<ul>
<li><menu>Lgg till variant</menu>: Skapar en variant vid denna stllning. Antingen fr nsta drag, eller fr fregende drag om det r det frsta draget.</li>
<li><menu>Radera variant</menu>: Visar en undermeny med de raderbara varianterna.</li>
<li><menu>Skapa huvudvariant</menu>: Upphjer en av varianterna till huvudvariant.</li>
<li><menu>Skapa nytt textdrag</menu>: Gr en av varianterna till nytt partidrag.</li>
<li><menu>Testa en id</menu>: Slr p <a Moves Trial>testlge</a> fr att tillflligt testa en id. Frndrar inte partiet.</li>
<li><menu>Ta bort</menu>: Avlgsna kommentarer eller varianter ur partiet.</li>
<br>
<li><menu>Tm Clipbase</menu>: Tmmer den urklippsdatabasen <a Clipbase>clipbase</a> p partier.</li>
<li><menu>Kopiera partiet till Clipbase</menu>: Kopierar det aktuella partiet till urklippsdatabasen <a Clipbase>clipbase</a>.</li>
<li><menu>Klistra in det senaste Clipbasepartiet</menu>: Klistrar in det aktiva partiet i <a Clipbase>Clipbase</a> i den aktiva databasen och gr det aktivt.</li>
<br>
<li><menu>Skapa stllning</menu>: Skapa en utgngsstllning fr aktuellt parti.</li>
<li><menu>Kopiera stllning</menu>: Kopiera den aktuella stllningen i FEN kod till urklippshanteraren.</li>
<li><menu>Klistra in utgngsstllning</menu>: Klistra in stllningen frn aktuellt parti i den temporra databasen.</li>
</ul>

<h3>Partier</h3>
<ul>
<li><menu>Nytt parti</menu>: terstll brdet infr ett nytt parti (raderar alla ndringar).</li>
<li><menu>Ladda frsta/fregende/nsta/sista partiet</menu>: Dessa laddar respektive parti i <a Searches Filter>skfiltret</a>.</li>
<li><menu>Ladda om partiet</menu>: Laddar om aktuellt parti och slnger alla gjorda ndringar..</li>
<li><menu>Ladda parti slumpmssigt</menu>:  Ladda ett av datorn slumpmssigt valt parti.</li> 
<li><menu>Ladda parti nummer...</menu>: Ladda ett parti genom att ange dess nummer.</li>
<br>
<li><menu>Spara: Erstt parti...</menu>: Spara partiet och erstt tidigare version.</li>
<li><menu>Spara: Nytt parti...</menu>: Spara det aktuella partiet, lgg till det till databasen.</li>
<br>
<li><menu>Identifiera ppningen</menu>: G till den mest detaljerade stllningen i ECO boken.</li>
<li><menu>G till drag nummer...</menu>: G till ett specifikt drag i partiet.</li>
<li><menu>Hitta nyhet...</menu>: Hitta det frsta draget i partiet som inte spelats tidigare.</li>
</ul>

<h3>Sk</h3>
<ul>
<li><menu>terstll skfilter</menu>: terstller <a Searches Filter>skfiltret</a> s att alla partiet ingr i urvalet.</li>
<li><menu>Omvnt filter</menu>: Ta med de partier som utesluts av filtret.</li>
<br>
<li><menu>Aktuell stllning...</menu>: Sk partier med <a Searches Board>den aktuella stllningen</a> p brdet.</li>
<li><menu>I huvud...</menu>: Anvnd <a Searches Header>fast information</a> (spelare, evenemang, plats, mm).</li>
<li><menu>Material/stllning...</menu>: Skning baserad p <a Searches Material>material</a> eller <a Searches Pattern>stllning</a>.</li>
<br>
<li><menu>Anvnd skfil...</menu>: Anvnd en fil med <a Searches Settings>lagrade</a>.</li>
</ul>

<h3>Fnster</h3>
<ul>
<li><menu>Kommentarseditor</menu>: ppna/ stng <a Comment>kommentarseditorn</a>.</li>
<li><menu>Partilista</menu>: ppna/ stng <a GameList>partilistan</a>.</li>
<li><menu>PGN fnster</menu>: ppna/ stng <a PGN>PGN fnstret</a>.</li>
<li><menu>Spelarfrteckning</menu>: ppna/ stng en frteckning ver spelarna i den aktiva databasen.</li> 
<li><menu>Turneringar</menu>: Lista <a Tmt>turneringar</a>.</li>
<br>
<li><menu>Databasvxlaren</menu>: ppna/ stng <a Switcher>databasvxlaren</a>. Databasvxlaren underlttar byte mellan olika databaser
och kopiering av partier frn den ena databasen till den andra.</li>
<li><menu>Databasverktyg</menu>: ppna/ stng <a Maintenance>verktygsfnstret</a>.</li>
<br>
<li><menu>ECO fnster</menu>: ppna/ stng <a ECO browser>ECO blddraren</a>.</li>
<li><menu>Repetoareditor</menu>: ppna/ stng verktyget fr <a repetoire>spelppningshantering</a>.</li>
<li><menu>Statistikfnster</menu>: ppna/ stng <term>statistikfnstret</term>. Hr hittar en statistisk sammanfattning av partierna i  
 <a Searches Filter>skfiltret</a>.</li>
<li><menu>Trdfnster</menu>: ppna/ stng <a Tree>varianttrdet</a>.</li>
<li><menu>Slutspelsdatabas</menu>: ppna/ stng slutspelsdatabasfnstret som ger dig viss information om <a TB>slutspelsdatabaserna</a>.</li>
</ul>

<h3>Verktyg</h3>
<ul>
<li><menu>Analysmotor...</menu>: Starta/ stoppa en analysmotor, t ex Crafty, som kontinuerligt bedmmer den aktuella stllningen
p brdet i ett <a Analysis>analysfnster</a>.</li>
<li><menu>Analysmotor 2...</menu>: Starta/ stoppa en andra analysmotor, t ex Crafty.</li>
<li><menu>Resultattabell</menu>: Skapa en <a Crosstable>resultattabell</a> fr den aktuella turneringen/matchen som det aktuella partiet ingr i</li>
<li><menu>Eposthanteraren</menu>: ppna/ stng <a Email>eposthanteraren</a> fr hantering av korrespondensschack.</li>
<br>
<li><menu>ppningsrapport</menu>: Skapa en <a OpReport>ppningsrapport</a> utifrn den aktuella stllningen.</li>
<li><menu>Sk material</menu>: ppnar dialog fr att <a PTracker>ska efter en viss materiell balans</a>.</li>
<br>
<li><menu>Spelarinformation</menu>: Visa/ uppdatera <a PInfo>spelarinformation</a> fr den ene av tv spelare i det aktuella partiet.</li>
<li><menu>Rankingdiagram</menu>: Skapa ett <a Graphs Rating>ranking diagram</a> fr spelarna i partiet.</li>
<li><menu>Resultatdiagram</menu>: Visa <a Graphs Score>resultatdiagrammet</a>.</li>
<br>
<li><menu>Exportera aktuellt parti ...</menu>: Spara aktuellt parti till olika format; text, HTML eller LaTeX. Se vidare
   hjlpsidan fr  att <a Export>exportera</a> partier.</li>
<li><menu>Exportera alla filtrerade partier</menu>: Spara alla <a Searches Filter>filterade</a> partier till olika format; text, HTML eller LaTeX. Se vidare
   hjlpsidan fr  att <a Export>exportera</a> partier.</li>
<br>
<li><menu>Importera ett parti i PGN-format...</menu>: ppnar <a Import>Importfnstret</a> fr att ange eller klistra in ett parti i 
 <a PGN>PGN format</a> fr import till en Scid databas.</li>
<li><menu>Importera flera partier i PGN-format...</menu>: Importera flera partier i PGN-format frn en fil.</li>
</ul>

<h3>Alternativ</h3>
<p>
Denna meny ger tillgng till de flesta av de parametrar som styr hur Scid fungerar.
Menyvalet <menu>Spara alternativ</menu> sparar de aktuella instllningarna till filen
 "<b>~/.scid/scidrc</b>" (eller <b>scid.opt</b> i katalogen som innehller den exekverbara
scid-filen vad gller Windows); denna fil laddas varje gng du startar Scid.
</p>

<h3>Hjlp</h3>
<p>
Denna meny innehller hjlpfunktioner och ger tillgng till bl a fnstret "Dagens tips"
och startfnstret som informerar om vilka filer Scid laddat vid uppstart. 
</p>

<p><footer>(Uppdaterad: Scid 3.3, april 2002)</footer></p>
}

####################
### Entering moves help:

set helpTitle(W,Moves) "Ange drag"
set helpText(W,Moves) {<h1>Ange drag</h1>
<p>
I Scid, kan du ange partidrag svl med musen som med tangentbordet. Nr du rr musmarkren ver en ruta p
brdet kommer du att mrka att svl rutan som ytterligare en ruta fr en annan frg. Om det finns ett legalt
drag till eller frn den ruta du fr musmarkren ver. Detta r det <term>freslagna draget</term>.
Du utfr detta drag genom att <term>vnsterklicka</term> med musen. Om detta str dig kan du stnga av funktionen
i Alternativmenyn.

</p>
<p>
Fr att utfra ett annat drag kan du <term>klicka och hlla nere vnster</term> musknapp: flytta sedan musen till nskad
 ruta och slpp musknappen.
</p>
<p>
Om du vill kan du utfra drag genom att klicka tv gnger istllet fr att anvnda klicka-och-drag tekniken. Klicka d 
frst p utgngsrutan med den <term>mittersta musknappen</term> och klicka sedan med samma musknapp p destinationsrutan.
(Tipset gller kanske ffa anvndare av UNIX(-lika) system som ofta har stor nytta av 3-knappsmss).
</p>

<h4>Ta tillbaka ett drag</h4>
<p>
Man kan ta tillbaka ett drag genom att hgerklicka musen. Detta backar ett drag och raderar det senast utfrda draget i partiet
eller varianten.
</p>

<h4>Erstt tidigare drag</h4>
<p>
Om du anger ett drag i en stllning dr ett drag redan angivits kommer Scid att frga om du verkligen vill erstta den tidigare
draget (draget och alla varianter lngre fram som r beroende av draget tas bort), eller om du vill skapa en ny variant istllet.
En del anvnder tycker att frgan r strande och vill alltid erstta det tidigare draget, s man kan konfigurera Scid till att inte
stlla denna frga. Du hittar mjligheten i  menyn <menu>Alternativ: Drag</menu> "<i>Frga fre erstt drag</i>".
</p>

<h4><name Trial>Testlge</name></h4>
<p>
Om du gr igenom ett parti och kommer till en stllning dr du vill testa en id utan att pverka det registrerade partiet s vljer du
<b>Testa en id</b> frn menyn <menu>Redigera</menu> fr att stta p testlge. I testlge kan du gra drag och frndringar av partiet som
r temporra, dvs de sparas inte nr du tergr frn testlge.
</p>

<h3><name Mistakes>Rtta fel</name></h3>
<p>
Om du skriver in ett parti och pltsligt upptcker ett fel flera drag tidigare r det mjligt att rtta till detta utan att 
behva gra om alla drag efter feldraget. Det nda sttet r att redigera PGN-versionen av partiet: ppna <a Import>Importfnstret</a>, 
vlj Klistra in aktivt parti, korrigera felet och vlj drefter "Importera".
</p>

<h3>Ange drag via tangentbordet</h3>
<p>
Du kan ange drag via tangentbordet genom att helt enkelt skriva in dem med bokstver och siffror. Lgg mrke till att dragen
ska anges i <term>SAN notation</term>, <i>utan</i> (x) tecknet fr slag eller (=) tecknet fr promovering. Dragnotationen r 
inte versal/gemenknslig s t ex:
[n][f][3] r samma drag som Nf3 -- men kontrollera med noten nedan fr drag som str i konflikt med varandra.
</p>
<p>
Fr att skerstlla att inga drag r prefix fr ett annat drag s anvnds en srskild metod att ange rockad. Kort och lng rockad
representeras med hjlp av bokstver som fljer:
kort rockad anges med  [O][K]
lng rockad anges med [O][Q] istllet fr det vanliga O-O and O-O-O.
</p>
<p>
Nr du anger drag kommer du i statusraden att se en lista ver giltiga drag. Du kan, genom att trycka [mellanslag] vlja det frsta i listan och fra in det
i partiet. Fr att radera tecken anvnder du de vanliga raderingstangenterna.
</p>
<p>
<b>OBS</b> gemena tecken kopplas i frsta hand till bnder, vilket betyder att [b]kan betyda b-bonden istllet fr lparen (Bishop). Om du hamnar
i situationer nr konflikter uppstr mste du istllet ange pjserna med versaler (B) i detta fallet.
</p>
<b>versttarens kommentar</b> Scid frstr inte svenska. Detta betyder att du inte kan anvnda de svenska frkortningarna till att ange drag. [s][f][6] 
frsts inte av Scid (dremot funkar [n][f][6] utmrkt). Om du vill anvnda tangentbordet att skriva in drag fr du istllet anvnda notationen [g][8][f][6] fr
samma drag.
</p>
<h4>Autokomplettering</h4>
<p>
I Alternativmenyn kan du sl p eller av <term>Autokomplettering</term>
av drag.
Med denna pslagen grs draget s fort du skrivit in tillrckligt mycket fr att srskilja det frn andra mjliga drag. Exempelvis rcker det att skriva [n][f] istllet
fr [n][f][3] fr draget <b>Nf3</b>i utgngsstllningen.
</p>
<p><b>versttarens kommentar</b> Scid frstr som sagt inte svenska. Dremot fungerar det med rutangivelsen om t ex pjsen p g1 bara har ett flt 
att g till.</p>

<h3><name Null>Ange null-drag</name></h3>
<p>
<a Annotating Null>Null</a> (tomma, planerade) drag kan vara anvndbara i  kommentarer fr att hoppa ver den ena spelarens drag. Du anger null-drag
genom att sl den ena kungen med den andra, eller via tangentbordet genom att skriva  "<b>--</b>" (minustecknet tv gnger).
</p>
<p><b>versttarens kommentar</b> "null" r en dataterm fr att beskriva ingenting (till skillnad mot noll som har ett vrde om dock noll, null har inget vrde).
Shane anvnder termen null hr, ngon som har frslag p bttre i den svenska versttningen? Kolla intro sidan fr att fresl ngot.</p>

<h3>Ange de vanligaste kommentarsymbolerna</h3>
<p>
Du kan ven ange <a NAGs>kommentarsymboler</a> via tangentbordet utan att behva anvnda <a Comment>kommentarseditorn</a>. 
Fljande lista kan anges via tangentbordet:
<ul>
<li> !	: [!][ENTER] </li>
<li> ?	: [?][ENTER] </li>
<li> !?	: [!][?][ENTER] </li>
<li> ?!	: [?][!][ENTER] </li>
<li> !!	: [!][!][ENTER] </li>
<li> ??	: [?][?][ENTER] </li>
<li> </li>
<li> +-	: [+][-] </li>
<li> +/-	: [+][/] </li>
<li> +=	: [+][=] </li>
<li> =	: [=][ENTER] </li>
<li> -+	: [-][+] </li>
<li> -/+	: [-][/] </li>
<li> =+	: [=][+] </li>
</ul>

<p><footer>(Uppdaterad: Scid 3.4,  juli 2002)</footer></p>
}


########################################
### Searches help screen:

set helpTitle(W,Searches) "Ska i Scid"
set helpText(W,Searches) {<h1>Ska i Scid</h1>
<p>
I Scid kan man ska information p flera olika stt. 
Det finns tre huvudmetoder att anvnda sig av beroende p vilken typ av information man
r ute efter:
<ul>
<li><b>1)</b> utifrn den aktuella stllningen p brdet, </li>
<li><b>2)</b> utifrn specifikt material eller en specifik stllningstyp; och </li>
<li><b>3)</b> utifrn fast information, t ex spelare, ort, resultat eller datum. </li>
</ul>
<p>
Utver dessa metoder kan man anvnda sig av en automatisk skfunktion, <a Tree>trdfnstret</a>, som frklaras
separat.
</p>

<h3><name Filter>Skfiltret</name></h3>
<p>
Skningar baseras i  Scid p <term>filter</term>.
Ett filter representerar en delmngd av den aktiva databasen. Vid varje specifikt tillflle kommer ett parti att antingen vara
del av denna delmngd (filtret) eller uteslutas av detta. I varje typ av skning (se ovan) kan du vlja att begrnsa, utka eller
ignorera det aktiva filtret och istllet ska i hela databasen. Detta gr att man stegvis kan bygga komplicerade skningar. 
Du kan ocks kopiera alla filtrerade partier frn den ena databasen till den andra genom att anvnda <a Switcher>databasvxlaren</a>.
</p>

<p>
Nr du sker p exakt stllning, <a Tree>trd</a> eller material/stllningstyp, sparas dragnumret i den frsta stllningen och varje
parti med identisk stllning lagras i minnet s att man, nr man senare laddar de framskta partierna, automatiskt kommer till den stllning
som var av intresse (som skningen grundades p).
</p>
<p>
<b>OBS</b> skningen gller endast textdragen, inte varianterna.
</p>

<h3><name Board>Sk: Aktuell stllning</name></h3>
<p>
Med denna metod hittas partier med samma stllning som det p brdet i huvudfnstret. Rockadmjligheter och 
rttigheter att gra <i>en passant</i> ignoreras. Det finns fyra undertyper att vlja p, samtliga krver att stllningen har exakt samma material och spelare vid draget fr att en trff ska
anses ha intrffat:
<ul>
<li> [1] exakt (de bda stllningarna mste vara exakt lika), </li>
<li> [2] bnder (bondestrukturen mste vara identisk, men de vriga pjsernas placering kan variera), </li>
<li> [3] linjer (antalet vita och svarta bnder p varje linje mste vara identisk - i vrigt kan pjsplaceringen variera), och slutligen; </li>
<li> [4] material (bnder och pjser kan st var som helst p brdet.). </li>
</ul>
<p>
Att ska p bondestllning r anvndbart nr man studerar spelppningar med likartad bondstruktur, medan att ska p linjer och material r lmpliga metoder
att finna liknande stllningar i slutspel. Nr man sker p specifika stllningar kan man skapa den frst (frn menyvalet <menu>Redigera: Skapa stllning</menu>) och starta skningen drifrn.
(Man kan naturligtvis ocks spela upp stllningen p brdet, <i>vers anm</i>).
</p>
<p>
Du kan ange att skningen ven ska leta i varianter (istllet fr att bara inkludera de egentliga partidragen) genom att markera kryssrutan <b>Sk i varianter</b>, 
men detta kan gra skningen lngsammare om databasen r stor och har mnga partier med varianter.
</p>

<h3><name Material>Sk: Material/stllningstyp</name></h3>
<p>
Denna skning r anvndbar nr man vill finna slut- eller mittspelsteman. Du kan specificera minimalt och maximalt antal av varje pjstyp, och hitta stllningar
av typen "Lpare p f7" eller "Bonde p f-linjen". Det finns ett antal vanliga stllningstyper frdefinierade, t ex "Torn och Bondeslutspel" eller "Isolerade d-bnder".
</p>
<p>
<b>Tips:</b><br>
Tidstgngen fr denna typ av skning kan variera kraftigt. Man kan minska tiden som behvs genom att anvnda sig av frnuftiga begrnsningar.
Om man, som exempel,  vill underska slutspel. kan man stta det minimala antalet drag partiet ska innehlla till 20. D kommer alla partier 
med frre n 20 drag att ignoreras.
</p>

<h3><name Header>Sk: fasta uppgifter ("header search")</name></h3>
<p>
Denna skning anvnds fr att finna aspekter p partier som lagras i partiets huvud (jmf eposthuvud) ssom datum, resultat, plats och rankingtal. Den
krver ingen avkodning av dragen i partiet. Fr att en trff ska registreras krvs att alla flt du specificerar stmmer verens. Namnflten  (Vit, Svart, 
Evenemang, Plats och Rond) r versal/gementoleranta. Trffar registrerars p all text i dessa flt och mellanslag ignoreras .
</p>
<p>
Du kan generera exakta skning ar och anvnda jokertecken i huvudflten som nmnts ovan. Jokertecknet  <b>?</b> betyder "ett
valfritt tecken" medan <b>*</b> betyder "inget eller flera valfria tecken". Man genererar exakta skningar genom att innesluta den text man
nskar hitta i citattecken ("). Exempel:
</p>

<p>
En skning p platsen <b>USA</b> kommer att generera amerikanska stder, men ven <b>Lausanne SUI</b>, vilket du frmodligen inte var ute efter! 
Detta lser man genom att istllet ska efter platsen <b>"*USA"</b> (notera citattecknen) som endast kommer att presentera stder i USA.</p>
<p>
Om du sker efter en srskild spelare (eller tv srskilda spelare) som vit eller svart och det inte spelar ngon roll vet som har vilken frg vljer du med 
frdel <b>Ignorera frg</b> i stllet fr svart/vit i frgangivelsen.
</p>
<p>
Avslutningsvis kan fasta skningar gras fr att hitta valfri text (versal/gemen intolerant och utan jokertecken) i PGN versionen av partierna. Du kan
ange upp till tre textstrngar, och alla mste finnas i ett parti fr att de ska rknas som en trff. Denna skning r mycket anvndbar nr det gller
kommentarsfltet eller extra mrkord i partierna (exempelvis  <b>frlorar p tid</b> eller <b>Kommentator</b>), eller fr en dragfljd som 
<b>Bxh7+</b> och <b>Kxh7</b> nr en lpare har offrats (och accepterats) p h7.

Tnk dock p att denna typ av skningar kan vara <i>mycket</i> tidskrvande eftersom alla partier som mter vissa kriterier mste avkodas och
genomskas efter textstrngen/-arna. Det r drfr en bra ide att begrnsa denna typ av skning s mycket som mjligt. Exempel:
</p>

<p>
Fr att hitta partier med underpromovering till torn sker man p <b>=R</b> och stter <b>Frvandlingar</b> flaggan till Ja.
Fr att hitta text i kommentarer stter du flaggan <b>Kommentarer</b> till Ja.
Om du sker p dragen <b>Bxh7+</b> och <b>Kxh7</b>, kan det vara en ide att begrnsa partierna till de som har resultatet  1-0 result och innehller
minst 20 halvdrag. Eller gr en Material/Stllningstypsskning fr att hitta partier dr lparen flyttas till h7.
</p>

<h3><name Settings>Spara skkriterierna</name></h3>
<p>
I Material/Stllningstyp and Huvudskningsfnstrena finns valet att  
<term>Spara instllningarna</term>. Detta ger dig mjligheten att spara de aktuella skkriterierna fr senare anvndning.
Kriterierna sparas till en <term>skningsfil</term> med filndelsen  .sso. Fr att teranvnda en tidigare sparad skningfil
vljer du <menu>ppna ...</menu> frn menyn <menu>Sk</menu>.
</p>

<h3>Sktider och ignorerade partier</h3>
<p>
De flesta skningar meddelar en hur lng tid skningen tog och hur mnga partier som <term>ignorerades</term>. Ignorerade partier
r de som exkluderats frn en skning utan att ngot av dess drag har avkodats (frn Scids databasformat). Detta baseras p information
som lagrats i index. Se vidare hjlpfilen om <a Formats>filformat</a> fr ytterligare information. 
</p>

<p><footer>(Uppdaterad: Scid 3.0, november 2001)</footer></p>
}

#################
### Clipbase help:

set helpTitle(W,Clipbase) "Urklippsdatabasen"
set helpText(W,Clipbase) {<h1>Urklippsdatabasen</h1>
<p>
Frutom de databaser du ppnar sjlv, ppnar Scid ytterligare en - <term>urklippsdatabasen</term>. Urklippsdatabasen,
fungerar precis som alla andra databaser, med ett undantag. Den existerar bara i datorns arbetsminne och sparar inte data
ngonstans permanent. Urklippsdatabasen tms sledes nr du stnger av datorn.
</p>
<p>
Urklippsdatabasen r anvndbar som en tillfllig lagringsplats, fr att sl samman skresultat frn olika databaser, eller fr att man dr
kan behandla resultat frn en skning som en egen databas. 
</p>
<p>
Antag, exempelvis, att du vill frbereda dig fr en srskild motstndare. Du har skt igenom databasen efter partier av denne dr motstndaren
spelar vit. Kopiera alla partier i <a Searches Filter>skfiltret</a> till urklippsdatabasen. Du kan gra det genom att i <a Switcher>databasvxlaren</a>
 dra dem frn deras ordinarie databas till urklippsdatabasen. Drefter kan du ppna urklippsdatabasen och underska partierna i  <a Tree>trdfnstret</a>, 
till exempel fr att kartlgga motstndarens ppningrepertoir.
</p>
<p>
Observera att du kan kopiera partier frn en databas till en annan utan att anvnda urklippsdatabasen som mellanlagringsplats. Notera ocks att
urklippsdatabasen <i>inte</i> kan stngas via menyvalet <menu>Arkiv: Stng</menu>medan du r i urklippsdatabasen. Det som hnder d r
motsvarigheten till  <menu>Redigera: terstll urklippsdatabasen</menu>, dvs databasen tms.
</p>
<p>
Du kan maximalt ha 20,000 partier i minnet samtidigt.
</p>

<p><footer>(Uppdaterad: Scid 2.5,  juni 2001)</footer></p>
}

#################################
### Variations and comments help:

set helpTitle(W,Annotating) "Kommentera partier"
set helpText(W,Annotating) {<h1>Kommentera partier</h1>
<p>
I Scid kan lgga till noter till partierna. Det finns tre typer av anteckningar du kan lgga till till varje drag:
symboler, kommentarer och varianter.
</p>

<h3>Symboler och kommentarer</h3>
<p>
Symboler anvnds fr stllningsbedmningar om vem som str bst (t ex "+-" eller "=") , om draget som just gjordes var bra eller dligt
(t ex "!" eller "?") medan kommentarer kan best av valfri text. Fr att lgga till symboler och kommentarer anvnder man
<a Comment>kommentarseditorn</a>. Det finns ocks en srskild hjlpsida fr <a NAGs>standardsymbolerna</a>.
</p>
<p>
Tnk p att ven om varje drag kan ha fler symboler, kan det bara ha en kommentar. En kommentar fr frsta draget skrivs ut som 
text fre partidragen. 
</p>

<h3><name Vars>Varianter</name></h3>
<p>
En <term>variant</term> r en alternativ fortsttning av partiet som skulle ha kunnat utfras vid ngot
tillflle i partiet. Varianter kan innehlla kommentarer, symboler och varianter. Knappen mrkt "<b>V</b>" 
ovanfr brdet i huvudfnstret, samt valmjligheter frn menyn <menu>Redigera</menu> kan anvndas till att skapa,
navigera i och redigera varianter.
</p>

<h4>Kortkommandon</h4>
<p>
Nr det finns varianter till ett drag visas dem i partiinformationsomrdet. Den frsta varianten r <b>v1</b>, den andra
r <b>v2</b>, osv. Fr att flja en variant kan man klicka p den, eller trycka  "<b>v</b>" fljt av variantens nummer 
(Om det bara finns en variant rcker det med att trycka <b>v</b>.). Kortkommandot fr att g ur en variant r "<b>z</b>".
</p>

<h3><name Null>Null-drag</name></h3>
<p>
Det kan ibland vara anvndbart att hoppa ver drag i varianter. Du kan exempelvis till draget 14.Bd3 lgga till en variant och
nmna att det hotar 15.Bxh7+ Kxh7 16.Ng5+ med angrepp. Du kan ocks gra detta genom att anvnda <term>null-drag</term>
mellan 14.Bd3 och 15.Bxh7+, i exemplet ovan. Ett null-drag visas som "<b>--</b>" och infogas genom att med musen utfra det
ogiltiga draget att med kungen sl den andra kungen, eller att helt enkelt skriva in "<b>--</b>" (tv minustecken).
</p>
<p>
Observera att null-drag inte ingr i PGN standarden, s om du vill expotera partier som innehller null-drag till en PGN-fil mste du 
vlja mellan att bevara null-dragen(-t) eller konvertera dem till kommentarer fr att bibehlla exportmjligheter till andra
program. Se hjlpsidan fr att <a Export>exportera</a> partier fr mer information.
</p>

<p><footer>(Uppdaterad: Scid 3.4, juli 2002)</footer></p>
}


# end of swedish.tcl


