Name:           libschroedinger
Version:        0.6.1
Release:        gst.1
Summary:        Library for decoding and encoding video in the Dirac format

Group:          Applications/Multimedia
License:        LGPL/MIT/MPL
URL:            http://schrodinger.sourceforge.net/
Source:         http://schrodinger.sourceforge.net/schroedinger-%{version}.tar.gz
BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

BuildRequires:  gtk-doc
BuildRequires:  liboil-devel >= 0.3.10
BuildRequires:  gstreamer-devel
BuildRequires:  gstreamer-plugins-base-devel

%description
Library for decoding and encoding video in the Dirac format. It is implemented
in ANSI C and optimized through the us of liboil. libschro is written as a
collaboration between the BBC Research and Development, David Schleef and
Fluendo.

%package devel
Summary:	Development files and static libraries for libschroedinger
Group:		Development/Libraries
Requires:	%{name} = %{version}-%{release}

%description devel
libschroedinger-devel contains the files needed to build packages that depend
on libschroedinger.

%prep
%setup -q -n schroedinger-%{version}

%build
%configure

# parallel build does not work
# make %{?_smp_mflags}
make

%install
rm -rf $RPM_BUILD_ROOT

%makeinstall
# Clean out files that should not be part of the rpm.
rm -f $RPM_BUILD_ROOT%{_libdir}/*.{a,la}
rm -f $RPM_BUILD_ROOT%{_libdir}/gstreamer-0.10/*.{a,la}

%clean
rm -rf $RPM_BUILD_ROOT

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files
%defattr(-,root,root)
%doc COPYING COPYING.MIT COPYING.GPL COPYING.LGPL COPYING.MPL ChangeLog
%{_libdir}/libschroedinger-0.1.so.*
%{_libdir}/gstreamer-0.10/libgstschro.so

%files devel
%defattr(-,root,root)
%{_libdir}/pkgconfig/schroedinger-0.1.pc
%{_libdir}/libschroedinger-0.1.so
%{_includedir}/schroedinger-0.1/schroedinger/schro-stdint.h
%{_includedir}/schroedinger-0.1/schroedinger/schro.h
%{_includedir}/schroedinger-0.1/schroedinger/schroarith.h
%{_includedir}/schroedinger-0.1/schroedinger/schroasync.h
%{_includedir}/schroedinger-0.1/schroedinger/schrobits.h
%{_includedir}/schroedinger-0.1/schroedinger/schrobitstream.h
%{_includedir}/schroedinger-0.1/schroedinger/schrobuffer.h
%{_includedir}/schroedinger-0.1/schroedinger/schrodebug.h
%{_includedir}/schroedinger-0.1/schroedinger/schrodecoder.h
%{_includedir}/schroedinger-0.1/schroedinger/schroencoder.h
%{_includedir}/schroedinger-0.1/schroedinger/schroframe.h
%{_includedir}/schroedinger-0.1/schroedinger/schrometric.h
%{_includedir}/schroedinger-0.1/schroedinger/schromotion.h
%{_includedir}/schroedinger-0.1/schroedinger/schroparams.h
%{_includedir}/schroedinger-0.1/schroedinger/schropredict.h
%{_includedir}/schroedinger-0.1/schroedinger/schrotables.h
%{_includedir}/schroedinger-0.1/schroedinger/schroutils.h
%{_includedir}/schroedinger-0.1/schroedinger/schrowavelet.h
%{_includedir}/schroedinger-0.1/schroedinger/schroengine.h
%{_includedir}/schroedinger-0.1/schroedinger/schroanalysis.h
%{_includedir}/schroedinger-0.1/schroedinger/schroqueue.h
# %{_datadir}/gtk-doc/html/schroedinger-0.1

%changelog
* Thu Apr 05 2007 Thomas Vander Stichele <thomas at apestaart dot org>
- Further updates.

* Thu Apr 27 2006 Christian F.K. Schaller <christian@fluendo.com>
- Updates for carid -> schroedinger change
