#
# SchoolTool - common information systems platform for school administration
# Copyright (c) 2003 Shuttleworth Foundation
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
"""
Unit tests for the schooltool.infofacets module.

$Id: test_infofacets.py 2143 2004-11-20 10:39:45Z tvon $
"""
import unittest
from zope.interface.verify import verifyObject


class TestDynamicFacet(unittest.TestCase):

    def test(self):
        from schooltool.infofacets import DynamicFacet
        from schooltool.interfaces import IDynamicFacet, IFacet, IDynamicSchema
        from schooltool.interfaces import IDynamicSchema

        dif = DynamicFacet()
        verifyObject(IDynamicFacet, dif)
        verifyObject(IFacet, dif)
        verifyObject(IDynamicSchema, dif)

    def test_fields(self):
        from schooltool.infofacets import DynamicFacet
        dif = DynamicFacet()
        dif.addField('jid','Jabber ID','string')


class TestDynamicFacetSchemaService(unittest.TestCase):

    def test(self):
        from schooltool.infofacets import DynamicFacetSchemaService
        from schooltool.interfaces import IDynamicSchemaService
        from schooltool.interfaces import IDynamicFacetSchemaService

        dfs = DynamicFacetSchemaService()
        verifyObject(IDynamicFacetSchemaService, dfs)
        verifyObject(IDynamicSchemaService, dfs)


class TestPersonInfoFacet(unittest.TestCase):

    def test(self):
        from schooltool.infofacets import PersonInfoFacet
        from schooltool.interfaces import IPersonInfoFacet

        pif = PersonInfoFacet()
        verifyObject(IPersonInfoFacet, pif)

    def test_name(self):
        from schooltool.model import Person
        from schooltool.component import FacetManager

        person = Person("Steve Alexander")
        facet = FacetManager(person).facetByName("person_info")

        facet.first_name = "John"
        self.assertEqual(facet.first_name, "John")
        self.assertEqual(person.title, "John")

        facet.last_name = "Smith"
        self.assertEqual(facet.last_name, "Smith")
        self.assertEqual(person.title, "John Smith")

        facet.first_name = ""
        self.assertEqual(person.title, "Smith")

        facet.last_name = ""
        self.assertEqual(person.title, "Smith")


class TestAddressFacet(unittest.TestCase):

    def test(self):
        from schooltool.infofacets import AddressFacet
        from schooltool.interfaces import IAddressFacet

        aif = AddressFacet()
        verifyObject(IAddressFacet, aif)


def test_suite():
    suite = unittest.TestSuite()
    suite.addTest(unittest.makeSuite(TestDynamicFacet))
    suite.addTest(unittest.makeSuite(TestDynamicFacetSchemaService))
    suite.addTest(unittest.makeSuite(TestPersonInfoFacet))
    suite.addTest(unittest.makeSuite(TestAddressFacet))
    return suite

if __name__ == '__main__':
    unittest.main(defaultTest='test_suite')
