##############################################################################
#
# Copyright (c) 2004 Zope Corporation and Contributors.
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#
##############################################################################
"""Key-reference interfaces

$Id: interfaces.py 28538 2004-11-30 00:36:51Z jim $
"""
import zope.interface

class IKeyReference(zope.interface.Interface):
    """A reference to an object (similar to a weak reference).

    The references are compared by their hashes.
    """

    def __call__():
        """Get the object this reference is linking to.
        """

    def __hash__():
        """Get a unique identifier of the referenced object.
        """

    def __cmp__(ref):
        """Compare the reference to another reference.
        """
