# the schleuder config class - a simple container
module Schleuder
  # Provides schleuder.conf as object, contains default values for most settings
  class SchleuderConfig < Storage

    # Options and their defaults
    # If you want to change them edit the global config file.
    # Usually in /etc/schleuder/schleuder.conf

    # Outgoing SMTP server address
    schleuder_attr :smtp_host, 'localhost'

    # Outgoing SMTP server port
    schleuder_attr :smtp_port, 25

    # Used as sender-address ans for determining the own gpg-key
    schleuder_attr :myaddr, 'schleuder@localhost'

    # The address to which SchleuderLogger#fatal messages (and possibly also
    # SchleuderLogger#error messages) are reported 
    schleuder_attr :superadminaddr, 'root@localhost'

    # Location of the global log-file.
    schleuder_attr :log_file, '/var/log/schleuder/schleuder.log'

    # Global log_level: (ERROR || WARN || INFO || DEBUG)
    schleuder_attr :log_level, 'ERROR'

    # Directory which holds plugin-files
    schleuder_attr :plugins_dir, File.join(File.expand_path(File.dirname(__FILE__) + '/../..'),'plugins')

    # Directory which holds one subdirectory for each list
    schleuder_attr :lists_dir, '/var/schleuderlists'

    # Name of the list-specific file that holds the list configuration (YAML-formatted)
    schleuder_attr :lists_configfile, 'list.conf'

    # Name of the file that holds the members (YAML-formatted)
    schleuder_attr :lists_memberfile, 'members.conf'

    # Name of the file that holds default settings for all lists (YAML-formatted)
    schleuder_attr :lists_default_conf do
      File.join(@conf_dir,'default-list.conf')
    end

    # GPG-Key type.
    schleuder_attr :gpg_key_type, 'RSA'

    # GPG-Key length.
    schleuder_attr :gpg_key_length, 2048

    # GPG-Sub-Key type.
    schleuder_attr :gpg_subkey_type, 'RSA'

    # GPG-Sub-Key length.
    schleuder_attr :gpg_subkey_length, 2048

    ### END OF CONFIG OPTIONS

    def initialize(config_file=nil, fromfile=true)
      if config_file && config_file.is_a?(String)
        @conf_dir = File.dirname(config_file)
      elsif config_file.nil?
        @conf_dir = '/etc/schleuder'
        config_file = File.join(@conf_dir,'schleuder.conf')
      end

      # overload with config_file 
      super(config_file, fromfile)
    end
  end
end
