module Schleuder
  class Mailer
    def self.send(msg, to=nil, sender=Schleuder.list.bounce_addr, nolog=false)
      to = msg.to if to.nil?

      # TODO: TLS
      host = Schleuder.config.smtp_host
      port = Schleuder.config.smtp_port
      unless nolog
        Schleuder.log.info { "Delivering mail to #{host}:#{port}" }
        Schleuder.log.debug { "Mail has Sender: #{sender} - To: #{to.inspect}" }
      end
      Net::SMTP.start(host, port) do |smtpcon|
        smtpcon.send_message msg.to_s, sender, to
      end
      true
    rescue => e
      if e.message.frozen?
        Schleuder.log.warn "Something went wrong, while sending a message. I'll better preserve the message that should have been sent:\n#{msg.to_s}"
      else
        e.message << "\nOriginal message:\n#{msg.to_s}"
      end
      raise
    end
  end
end
