#!/usr/bin/env perl 

if ($#ARGV ne 2) {
  print "Usage: ".`basename $0`." schleuder-v1-srcdir schleuder-v1-listdir schleuder-v2-listdir \n";
  exit;
}

unshift @INC, shift(@ARGV);
$srcdir=shift(@ARGV);
$targetdir=shift(@ARGV);

use YAML;
# from schleuder-1
require "property.pl";

# one helper
sub dumptofile {
  $file = $_[0];
  $data = $_[1];
  if (-e $file) {
    print "Error: $file exists in this directory! Won't overwrite, skipping.\n";
    return false;
  } 
  open(listconf, ">$file") || die $!;
  print "Writing $file\n";
  print listconf YAML::Dump($data);
  close(listconf);
}


# now for the migration


# import gpg-files 
foreach $gpgfile(qw(pubring.gpg secring.gpg trustdb.gpg)) {
  `gpg --homedir $targetdir --import $srcdir/$gpgfile`;
}
print "\n";


# reading config
my $old = &Property::read($srcdir . "/schleuder.conf");
my $new = {};

$new->{'myaddr'} = $old->{'mail'}->{'myself'};
$new->{'public_footer'} = $old->{'mail'}->{'publicfooter'};
$new->{'adminaddr'} = $old->{'mail'}->{'maintainer'};
$new->{'prefix_in'} = $old->{'mail'}->{'subin'};
$new->{'prefix_out'} = $old->{'mail'}->{'subout'};
$new->{'default_mime'} = lc(substr($old->{'mail'}->{'defaultenvelop'}, 1, length($old->{'mail'}->{'defaultenvelop'})-2));

if (defined($old->{'site'}->{'logfile'})) {
  $new->{'logging'} = true;
}

if (($old->{'policy'}->{'allow_plaintext_sending'} eq 'yes')||($old->{'policy'}->{'allow_plaintext_sending'} eq 'true')) {
  $new->{'allow_plaintext_sending'} = 'true'
} else {
  $new->{'allow_plaintext_sending'} = 'false'
}

# read in gpg_password
open(passfile, $old->{'crypt'}->{'passfile'}) || die $!;
$tmp = <passfile>;
chomp($tmp);
$new->{'gpg_password'} = $tmp;
close(passfile);

# write list-config to file
dumptofile "$targetdir/list.conf", $new;


# collect listmembers
@members = ();
push @members, [];

open(listmembers, $srcdir . "/listmembers") || die $!;
while (<listmembers>) {
  next if (/^\s*#/);
  chomp;
  if (/^\s*([^\s:[]+)([^\s:]+)?\:?\s*(.*)/) { 
    $member = {};
    $member->{'email'}=$1; 
    $mime = lc(substr($2, 1, length($2)-2));
    if ($mime eq 'appl')  {
      $mime = 'mime';
    }
    if ($mime ne '') {
      $member->{'mime'}=$mime;
    }
    push(@{$members[0]}, $member);
  } 
}
close(listmembers);

# write members-list to file
dumptofile "$targetdir/members.conf", @members;

# touch file to chmod it
`touch $targetdir/list.log`;

print "chmod'ding dir and files";
chmod 0700, $targetdir;
foreach $fn (glob("$targetdir/*")) {
  chmod 0600, $fn;
}

print "Done. Please verify manually that all settings are correct\nand chown dir+files!\n";

