/*
 * Decompiled with CFR 0.152.
 */
package scala.dbc.datatype;

import scala.MatchError;
import scala.ScalaObject;
import scala.Tuple3;
import scala.collection.mutable.StringBuilder;
import scala.dbc.DataType;
import scala.dbc.datatype.Numeric;
import scala.dbc.exception.UnsupportedFeature;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001]3Q!\u0001\u0002\u0002\u0002%\u0011A\"\u0012=bGRtU/\\3sS\u000eT!a\u0001\u0003\u0002\u0011\u0011\fG/\u0019;za\u0016T!!\u0002\u0004\u0002\u0007\u0011\u00147MC\u0001\b\u0003\u0015\u00198-\u00197b\u0007\u0001)\"AC\t\u0014\u0007\u0001Y1\u0004E\u0002\r\u001b=i\u0011AA\u0005\u0003\u001d\t\u0011qAT;nKJL7\r\u0005\u0002\u0011#1\u0001A!\u0002\n\u0001\u0005\u0004\u0019\"\u0001\u0002+za\u0016\f\"\u0001\u0006\r\u0011\u0005U1R\"\u0001\u0004\n\u0005]1!a\u0002(pi\"Lgn\u001a\t\u0003+eI!A\u0007\u0004\u0003\u0007\u0005s\u0017\u0010\u0005\u0002\u00169%\u0011QD\u0002\u0002\f'\u000e\fG.Y(cU\u0016\u001cG\u000f\u0003\u0005 \u0001\t\u0015\r\u0011\"\u0011!\u00031q\u0017\r^5wKRK\b/Z%e+\u0005\t\u0003C\u0001\u0012'\u001d\t\u0019C%D\u0001\u0005\u0013\t)C!\u0001\u0005ECR\fG+\u001f9f\u0013\t9\u0003F\u0001\u0002JI*\u0011Q\u0005\u0002\u0005\tU\u0001\u0011\t\u0011)A\u0005C\u0005ia.\u0019;jm\u0016$\u0016\u0010]3JI\u0002BQ\u0001\f\u0001\u0005\u00025\na\u0001P5oSRtDC\u0001\u00180!\ra\u0001a\u0004\u0005\u0006?-\u0002\r!\t\u0005\u0006c\u0001!\tAM\u0001\rSN,\u0015/^5wC2,g\u000e\u001e\u000b\u0003gY\u0002\"!\u0006\u001b\n\u0005U2!a\u0002\"p_2,\u0017M\u001c\u0005\u0006\u0007A\u0002\ra\u000e\t\u0003GaJ!!\u000f\u0003\u0003\u0011\u0011\u000bG/\u0019+za\u0016DQa\u000f\u0001\u0005\u0002q\n1\"[:Tk\n$\u0018\u0010]3PMR\u00111'\u0010\u0005\u0006\u0007i\u0002\ra\u000e\u0005\u0006\u007f\u00011\t\u0001Q\u0001\u0006g\u000e\fG.Z\u000b\u0002\u0003B\u0011QCQ\u0005\u0003\u0007\u001a\u00111!\u00138u\u0011\u0015)\u0005\u0001\"\u0011G\u0003%\u0019\u0018\u000f\\*ue&tw-F\u0001H!\tAU*D\u0001J\u0015\tQ5*\u0001\u0003mC:<'\"\u0001'\u0002\t)\fg/Y\u0005\u0003\u001d&\u0013aa\u0015;sS:<\u0007\u0006\u0002\u0001Q'V\u0003\"!F)\n\u0005I3!A\u00033faJ,7-\u0019;fI\u0006\nA+A2tG\u0006d\u0017M\f3cG\u0002:\u0018\u000e\u001c7!E\u0016\u0004#/Z7pm\u0016$\u0007%\u00194uKJ\u0004c/\u001a:tS>t\u0007E\r\u0018:]\u0001\u0002Sk]3!C:\u0004\u0013m\u0019;jm\u0016\u00043/\u001d7!Y&\u0014'/\u0019:zAM,8\r\u001b\u0011bg\u0002\u001a8-\u00197bcV,'/\u001f\u0011j]N$X-\u00193/C\u00051\u0016!\u0002\u001a/s9\u0002\u0004")
public abstract class ExactNumeric<Type>
extends Numeric<Type>
implements ScalaObject {
    private final int nativeTypeId;

    @Override
    public int nativeTypeId() {
        return this.nativeTypeId;
    }

    @Override
    public boolean isEquivalent(DataType datatype) {
        boolean bl;
        DataType dataType = datatype;
        if (dataType instanceof ExactNumeric) {
            ExactNumeric exactNumeric;
            ExactNumeric dt = exactNumeric = (ExactNumeric)dataType;
            bl = this.nativeTypeId() == dt.nativeTypeId() && this.precisionRadix() == dt.precisionRadix() && this.precision() == dt.precision() && this.scale() == dt.scale() && this.signed() == dt.signed();
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean isSubtypeOf(DataType datatype) {
        boolean bl;
        DataType dataType = datatype;
        if (dataType instanceof ExactNumeric) {
            ExactNumeric exactNumeric;
            ExactNumeric dt = exactNumeric = (ExactNumeric)dataType;
            bl = this.nativeTypeId() == dt.nativeTypeId() && this.precisionRadix() == dt.precisionRadix() && this.precision() <= dt.precision() && this.scale() <= dt.scale() && this.signed() == dt.signed();
        } else {
            bl = false;
        }
        return bl;
    }

    public abstract int scale();

    @Override
    public String sqlString() {
        Tuple3<Integer, Integer, Integer> tuple3 = new Tuple3<Integer, Integer, Integer>(BoxesRunTime.boxToInteger(this.precisionRadix()), BoxesRunTime.boxToInteger(this.precision()), BoxesRunTime.boxToInteger(this.scale()));
        if (tuple3 != null) {
            String string2;
            int n = BoxesRunTime.unboxToInt(tuple3._2());
            int n2 = BoxesRunTime.unboxToInt(tuple3._3());
            switch (BoxesRunTime.unboxToInt(tuple3._1())) {
                default: {
                    throw new UnsupportedFeature("SQL-99 does not support the precision of an exact numeric type to be defined in a radix other than 2 or 10");
                }
                case 2: {
                    if (n == 16) {
                        if (n2 == 0) {
                            string2 = "SMALLINT";
                            break;
                        }
                    } else if (n == 32) {
                        if (n2 == 0) {
                            string2 = "INTEGER";
                            break;
                        }
                    } else if (n == 64) {
                        if (n2 == 0) {
                            string2 = "BIGINT";
                            break;
                        }
                    } else if (n == Integer.MAX_VALUE && n2 == 0) {
                        string2 = "BIGINT";
                        break;
                    }
                    throw new UnsupportedFeature("SQL-99 does not support an exact numeric type with a binary defined precision other than 16, 32 and 64 bits");
                }
                case 10: {
                    string2 = n2 == 0 ? new StringBuilder().append((Object)"NUMERIC (").append((Object)((Object)BoxesRunTime.boxToInteger(n)).toString()).append((Object)")").toString() : new StringBuilder().append((Object)"NUMERIC (").append((Object)((Object)BoxesRunTime.boxToInteger(n)).toString()).append((Object)", ").append((Object)((Object)BoxesRunTime.boxToInteger(n2)).toString()).append((Object)")").toString();
                }
            }
            return string2;
        }
        throw new MatchError(tuple3);
    }

    public ExactNumeric(int nativeTypeId) {
        this.nativeTypeId = nativeTypeId;
        super(nativeTypeId);
    }
}

