/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.jline.console.history;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import scala.tools.jline.console.history.History;
import scala.tools.jline.console.history.MemoryHistory;
import scala.tools.jline.console.history.PersistentHistory;
import scala.tools.jline.internal.Log;

public class FileHistory
extends MemoryHistory
implements Flushable,
PersistentHistory {
    private final File file;

    public FileHistory(File file) throws IOException {
        assert (file != null);
        this.file = file;
        this.load(file);
    }

    public File getFile() {
        return this.file;
    }

    public void load(File file) throws IOException {
        assert (file != null);
        if (file.exists()) {
            Log.trace("Loading history from: ", file);
            this.load(new FileReader(file));
        }
    }

    public void load(InputStream inputStream) throws IOException {
        assert (inputStream != null);
        this.load(new InputStreamReader(inputStream));
    }

    public void load(Reader reader) throws IOException {
        String string;
        assert (reader != null);
        BufferedReader bufferedReader = new BufferedReader(reader);
        while ((string = bufferedReader.readLine()) != null) {
            this.add(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        Object object;
        Log.trace("Flushing history");
        if (!this.file.exists()) {
            object = this.file.getParentFile();
            if (!((File)object).exists() && !((File)object).mkdirs()) {
                Log.warn("Failed to create directory: ", object);
            }
            if (!this.file.createNewFile()) {
                Log.warn("Failed to create file: ", this.file);
            }
        }
        object = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.file)));
        try {
            for (History.Entry entry : this) {
                ((PrintStream)object).println(entry.value());
            }
        }
        finally {
            ((PrintStream)object).close();
        }
    }

    public void purge() throws IOException {
        Log.trace("Purging history");
        this.clear();
        if (!this.file.delete()) {
            Log.warn("Failed to delete history file: ", this.file);
        }
    }
}

