/*
 * Decompiled with CFR 0.152.
 */
package org.scalatest.tools;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import org.scalatest.DispatchReporter;
import org.scalatest.Distributor;
import org.scalatest.Filter;
import org.scalatest.Stopper;
import org.scalatest.Suite;
import org.scalatest.Tracker;
import org.scalatest.tools.SuiteRunner;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.ScalaObject;
import scala.Some;
import scala.collection.immutable.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentDistributor
implements Distributor,
ScalaObject {
    private final LinkedBlockingQueue<Future<?>> futureQueue;
    private final ExecutorService execSvc;
    private final int poolSize;
    private final Map<String, Object> configMap;
    private final Filter filter;
    private final Stopper stopper;
    private final DispatchReporter dispatchReporter;

    public ConcurrentDistributor(DispatchReporter dispatchReporter, Stopper stopper, Filter filter2, Map<String, Object> configMap, int numThreads) {
        this.dispatchReporter = dispatchReporter;
        this.stopper = stopper;
        this.filter = filter2;
        this.configMap = configMap;
        Function2.class.$init$((Function2)this);
        this.poolSize = numThreads > 0 ? numThreads : Runtime.getRuntime().availableProcessors() * 2;
        this.execSvc = Executors.newFixedThreadPool(this.poolSize());
        this.futureQueue = new LinkedBlockingQueue();
    }

    public void waitUntilDone() {
        Future<?> future;
        while ((future = this.futureQueue().peek()) != null && !future.equals(null)) {
            this.futureQueue().poll().get();
        }
        return;
    }

    public None$ poll() {
        return None$.MODULE$;
    }

    @Override
    public void apply(Suite suite, Tracker tracker) {
        SuiteRunner suiteRunner = new SuiteRunner(suite, this.dispatchReporter, this.stopper, this.filter, this.configMap, (Option<Distributor>)new Some((Object)this), tracker);
        Future<?> future = this.execSvc().submit(suiteRunner);
        this.futureQueue().put(future);
    }

    private LinkedBlockingQueue<Future<?>> futureQueue() {
        return this.futureQueue;
    }

    private ExecutorService execSvc() {
        return this.execSvc;
    }

    private int poolSize() {
        return this.poolSize;
    }

    public Function1 curry() {
        return Function2.class.curry((Function2)this);
    }

    public String toString() {
        return Function2.class.toString((Function2)this);
    }
}

