/*
 * Decompiled with CFR 0.152.
 */
package org.scalatest.junit;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.scalatest.Reporter;
import org.scalatest.Resources$;
import org.scalatest.Tracker;
import org.scalatest.events.TestFailed$;
import org.scalatest.events.TestIgnored$;
import org.scalatest.events.TestStarting$;
import org.scalatest.events.TestSucceeded$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.ScalaObject;
import scala.Some;
import scala.Tuple3;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MyRunListener
extends RunListener
implements ScalaObject {
    private final Pattern TEST_DESCRIPTION_PATTERN;
    private final Set<String> failedTests;
    private final Tracker theTracker;
    private final Reporter report;

    public MyRunListener(Reporter report, Map<String, Object> config, Tracker theTracker) {
        this.report = report;
        this.theTracker = theTracker;
        this.failedTests = Collections.synchronizedSet(new HashSet());
        this.TEST_DESCRIPTION_PATTERN = Pattern.compile("^(.*)\\((.*)\\)");
    }

    private Tuple3<String, String, String> parseTestDescription(Description description) {
        Matcher matcher = this.TEST_DESCRIPTION_PATTERN().matcher(description.getDisplayName());
        if (matcher.find()) {
            String testName = matcher.group(1);
            String testClass = matcher.group(2);
            String testClassName = testClass.replaceAll(".*\\.", "");
            return new Tuple3((Object)testName, (Object)testClass, (Object)testClassName);
        }
        throw new RuntimeException(new StringBuilder().append((Object)"unexpected displayName [").append((Object)description.getDisplayName()).append((Object)"]").toString());
    }

    public Pattern TEST_DESCRIPTION_PATTERN() {
        return this.TEST_DESCRIPTION_PATTERN;
    }

    public void testStarted(Description description) {
        Tuple3<String, String, String> temp13 = this.parseTestDescription(description);
        if (temp13 != null) {
            String temp16;
            String temp14 = (String)temp13._1();
            String temp15 = (String)temp13._2();
            String testClassName = temp16 = (String)temp13._3();
            String testClass = temp15;
            String testName = temp14;
            if (true) {
                testName = temp14;
                testClass = temp15;
                testClassName = temp16;
                Tuple3 tuple3 = new Tuple3((Object)testName, (Object)testClass, (Object)testClassName);
                String testName2 = (String)tuple3._1();
                String testClass2 = (String)tuple3._2();
                String testClassName2 = (String)tuple3._3();
                this.report.apply(TestStarting$.MODULE$.apply(this.theTracker.nextOrdinal(), testClassName2, (Option<String>)new Some((Object)testClass2), testName2));
                return;
            }
            throw new MatchError(temp13.toString());
        }
        throw new MatchError(temp13.toString());
    }

    public void testRunStarted(Description description) {
    }

    public void testRunFinished(Result result) {
    }

    public void testIgnored(Description description) {
        Tuple3<String, String, String> temp9 = this.parseTestDescription(description);
        if (temp9 != null) {
            String temp12;
            String temp10 = (String)temp9._1();
            String temp11 = (String)temp9._2();
            String testClassName = temp12 = (String)temp9._3();
            String testClass = temp11;
            String testName = temp10;
            if (true) {
                testName = temp10;
                testClass = temp11;
                testClassName = temp12;
                Tuple3 tuple3 = new Tuple3((Object)testName, (Object)testClass, (Object)testClassName);
                String testName2 = (String)tuple3._1();
                String testClass2 = (String)tuple3._2();
                String testClassName2 = (String)tuple3._3();
                this.report.apply(TestIgnored$.MODULE$.apply(this.theTracker.nextOrdinal(), testClassName2, (Option<String>)new Some((Object)testClass2), testName2));
                return;
            }
            throw new MatchError(temp9.toString());
        }
        throw new MatchError(temp9.toString());
    }

    public void testFinished(Description description) {
        Tuple3<String, String, String> temp5;
        block3: {
            block4: {
                block2: {
                    String temp8;
                    if (this.failedTests().contains(description.getDisplayName())) break block2;
                    temp5 = this.parseTestDescription(description);
                    if (temp5 == null) break block3;
                    String temp6 = (String)temp5._1();
                    String temp7 = (String)temp5._2();
                    String testClassName = temp8 = (String)temp5._3();
                    String testClass = temp7;
                    String testName = temp6;
                    if (!true) break block4;
                    testName = temp6;
                    testClass = temp7;
                    testClassName = temp8;
                    Tuple3 tuple3 = new Tuple3((Object)testName, (Object)testClass, (Object)testClassName);
                    String testName2 = (String)tuple3._1();
                    String testClass2 = (String)tuple3._2();
                    String testClassName2 = (String)tuple3._3();
                    this.report.apply(TestSucceeded$.MODULE$.apply(this.theTracker.nextOrdinal(), testClassName2, (Option<String>)new Some((Object)testClass2), testName2));
                }
                return;
            }
            throw new MatchError(temp5.toString());
        }
        throw new MatchError(temp5.toString());
    }

    public void testFailure(Failure failure) {
        this.failedTests().add(failure.getDescription().getDisplayName());
        Tuple3<String, String, String> temp1 = this.parseTestDescription(failure.getDescription());
        if (temp1 != null) {
            String temp4;
            String temp2 = (String)temp1._1();
            String temp3 = (String)temp1._2();
            String testClassName = temp4 = (String)temp1._3();
            String testClass = temp3;
            String testName = temp2;
            if (true) {
                testName = temp2;
                testClass = temp3;
                testClassName = temp4;
                Tuple3 tuple3 = new Tuple3((Object)testName, (Object)testClass, (Object)testClassName);
                String testName2 = (String)tuple3._1();
                String testClass2 = (String)tuple3._2();
                String testClassName2 = (String)tuple3._3();
                Throwable throwableOrNull = failure.getException();
                Throwable throwable = throwableOrNull;
                None$ throwable2 = throwable == null || throwable.equals(null) ? None$.MODULE$ : new Some((Object)throwableOrNull);
                Throwable throwable3 = throwableOrNull;
                String message = throwable3 == null || throwable3.equals(null) ? Resources$.MODULE$.apply("jUnitTestFailed") : throwableOrNull.toString();
                this.report.apply(TestFailed$.MODULE$.apply(this.theTracker.nextOrdinal(), message, testClassName2, (Option<String>)new Some((Object)testClass2), testName2, (Option<Throwable>)throwable2));
                return;
            }
            throw new MatchError(temp1.toString());
        }
        throw new MatchError(temp1.toString());
    }

    public Set<String> failedTests() {
        return this.failedTests;
    }
}

