/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.ImageGraphics;

public class Graphics {
    public static final int HCENTER = 1;
    public static final int VCENTER = 2;
    public static final int LEFT = 4;
    public static final int RIGHT = 8;
    public static final int TOP = 16;
    public static final int BOTTOM = 32;
    public static final int BASELINE = 64;
    public static final int SOLID = 0;
    public static final int DOTTED = 1;
    private int transX;
    private int transY;
    private short[] clip = new short[4];
    private boolean clipped = false;
    private int clipX2;
    private int clipY2;
    private int rgbColor;
    private int gray;
    private int pixel;
    private int style;
    private Font currentFont;
    private int maxWidth;
    private int maxHeight;
    Image destination = null;

    private native void init();

    Graphics(int w, int h) {
        this.maxWidth = w;
        this.maxHeight = h;
        this.init();
        this.reset();
    }

    static Graphics getGraphics(Image img) {
        if (img == null) {
            return new Graphics(Display.WIDTH, Display.HEIGHT);
        }
        return new ImageGraphics(img);
    }

    public void translate(int x, int y) {
        this.transX += x;
        this.transY += y;
    }

    public int getTranslateX() {
        return this.transX;
    }

    public int getTranslateY() {
        return this.transY;
    }

    public int getColor() {
        return this.rgbColor;
    }

    public int getRedComponent() {
        return this.rgbColor >> 16 & 0xFF;
    }

    public int getGreenComponent() {
        return this.rgbColor >> 8 & 0xFF;
    }

    public int getBlueComponent() {
        return this.rgbColor & 0xFF;
    }

    public int getGrayScale() {
        return this.gray;
    }

    private static int grayVal(int red, int green, int blue) {
        return red * 76 + green * 150 + blue * 29 >> 8;
    }

    private native int getPixel(int var1, int var2, boolean var3);

    public void setColor(int red, int green, int blue) {
        if (red < 0 || red > 255 || green < 0 || green > 255 || blue < 0 || blue > 255) {
            throw new IllegalArgumentException("Value out of range");
        }
        this.rgbColor = red << 16 | green << 8 | blue;
        this.gray = Graphics.grayVal(red, green, blue);
        this.pixel = this.getPixel(this.rgbColor, this.gray, false);
    }

    public void setColor(int RGB) {
        int red = RGB >> 16 & 0xFF;
        int green = RGB >> 8 & 0xFF;
        int blue = RGB & 0xFF;
        this.rgbColor = RGB & 0xFFFFFF;
        this.gray = Graphics.grayVal(red, green, blue);
        this.pixel = this.getPixel(this.rgbColor, this.gray, false);
    }

    public void setGrayScale(int value) {
        if (value < 0 || value > 255) {
            throw new IllegalArgumentException("Gray value out of range");
        }
        this.rgbColor = value << 16 | value << 8 | value;
        this.gray = value;
        this.pixel = this.getPixel(this.rgbColor, this.gray, true);
    }

    public Font getFont() {
        return this.currentFont;
    }

    public void setStrokeStyle(int style) {
        if (style != 0 && style != 1) {
            throw new IllegalArgumentException("Invalid line style");
        }
        this.style = style;
    }

    public int getStrokeStyle() {
        return this.style;
    }

    public void setFont(Font font) {
        this.currentFont = font == null ? Font.getDefaultFont() : font;
    }

    public int getClipX() {
        return this.clip[0] - this.transX;
    }

    public int getClipY() {
        return this.clip[1] - this.transY;
    }

    public int getClipWidth() {
        return this.clip[2];
    }

    public int getClipHeight() {
        return this.clip[3];
    }

    public void clipRect(int x, int y, int width, int height) {
        y += this.transY;
        if ((x += this.transX) > this.clip[0]) {
            this.clip[0] = (short)(x & Short.MAX_VALUE);
            this.clipped = true;
        }
        if (y > this.clip[1]) {
            this.clip[1] = (short)(y & Short.MAX_VALUE);
            this.clipped = true;
        }
        y += height;
        if ((x += width) < this.clipX2) {
            this.clipX2 = x;
            this.clipped = true;
        }
        if (y < this.clipY2) {
            this.clipY2 = y;
            this.clipped = true;
        }
        if (this.clipped) {
            this.clip[2] = (short)(this.clipX2 - this.clip[0]);
            this.clip[3] = (short)(this.clipY2 - this.clip[1]);
            if (this.clip[2] < 0 || this.clip[3] < 0) {
                this.clip[2] = 0;
                this.clip[3] = 0;
            }
        }
    }

    public void setClip(int x, int y, int width, int height) {
        short clipY1;
        short clipX1 = (x += this.transX) > 0 ? (short)(x & Short.MAX_VALUE) : (short)0;
        short s = clipY1 = y > 0 ? (short)((y += this.transY) & Short.MAX_VALUE) : (short)0;
        if (x >= this.maxWidth || width <= 0 || y >= this.maxHeight || height <= 0) {
            this.clip[3] = 0;
            this.clip[2] = 0;
            this.clip[1] = 0;
            this.clip[0] = 0;
            this.clipped = true;
            return;
        }
        this.clipX2 = x + width;
        if (this.clipX2 > this.maxWidth) {
            this.clipX2 = this.maxWidth;
        }
        this.clipY2 = y + height;
        if (this.clipY2 > this.maxHeight) {
            this.clipY2 = this.maxHeight;
        }
        this.clip[0] = clipX1;
        this.clip[1] = clipY1;
        this.clip[2] = (short)(this.clipX2 - clipX1);
        this.clip[3] = (short)(this.clipY2 - clipY1);
        if (this.clip[2] < 0) {
            this.clip[2] = 0;
        }
        if (this.clip[3] < 0) {
            this.clip[3] = 0;
        }
        if (clipX1 > 0 || clipY1 > 0 || this.clipX2 < this.maxWidth || this.clipY2 < this.maxHeight) {
            this.clipped = true;
        }
    }

    public native void drawLine(int var1, int var2, int var3, int var4);

    public native void fillRect(int var1, int var2, int var3, int var4);

    public native void drawRect(int var1, int var2, int var3, int var4);

    public native void drawRoundRect(int var1, int var2, int var3, int var4, int var5, int var6);

    public native void fillRoundRect(int var1, int var2, int var3, int var4, int var5, int var6);

    public native void fillArc(int var1, int var2, int var3, int var4, int var5, int var6);

    public native void drawArc(int var1, int var2, int var3, int var4, int var5, int var6);

    public native void drawString(String var1, int var2, int var3, int var4);

    public native void drawSubstring(String var1, int var2, int var3, int var4, int var5, int var6);

    public native void drawChar(char var1, int var2, int var3, int var4);

    public native void drawChars(char[] var1, int var2, int var3, int var4, int var5, int var6);

    public native void drawImage(Image var1, int var2, int var3, int var4);

    void reset(int x1, int y1, int x2, int y2) {
        this.transY = 0;
        this.transX = 0;
        short clipX1 = x1 > 0 ? (short)(x1 & Short.MAX_VALUE) : (short)0;
        short clipY1 = y1 > 0 ? (short)(y1 & Short.MAX_VALUE) : (short)0;
        this.clipX2 = x2;
        this.clipY2 = y2;
        this.clip[0] = clipX1;
        this.clip[1] = clipY1;
        this.clip[2] = (short)(this.clipX2 - clipX1);
        this.clip[3] = (short)(this.clipY2 - clipY1);
        if (this.clip[2] < 0) {
            this.clip[2] = 0;
        }
        if (this.clip[3] < 0) {
            this.clip[3] = 0;
        }
        this.clipped = clipX1 > 0 || clipY1 > 0 || this.clipX2 < this.maxWidth || this.clipY2 < this.maxHeight;
        this.currentFont = Font.getDefaultFont();
        this.style = 0;
        this.gray = 0;
        this.rgbColor = 0;
        this.pixel = this.getPixel(this.rgbColor, this.gray, true);
    }

    void reset() {
        this.reset(0, 0, this.maxWidth, this.maxHeight);
    }
}

