/*
 * Decompiled with CFR 0.152.
 */
package scala.io;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.CharsetDecoder;
import scala.ScalaObject;
import scala.io.BufferedSource$;
import scala.io.Source;

public abstract class BufferedSource
extends Source
implements ScalaObject {
    private final Object iter;
    private boolean endOfInput;
    private CharBuffer charBuffer;
    private final ByteBuffer byteBuffer;
    private final CharsetDecoder decoder;
    private final ReadableByteChannel byteChannel;

    public BufferedSource(ReadableByteChannel byteChannel, CharsetDecoder decoder) {
        this.byteChannel = byteChannel;
        this.decoder = decoder;
        this.byteBuffer = ByteBuffer.allocate(this.buf_size());
        this.charBuffer = CharBuffer.allocate(this.buf_size());
        this.byteBuffer().position(this.byteBuffer().limit());
        this.charBuffer().position(this.charBuffer().limit());
        decoder.reset();
        this.endOfInput = false;
        this.iter = new $anon$2(this);
    }

    public Object iter() {
        return this.iter;
    }

    public Object fillBuffer() {
        Object object;
        this.byteBuffer().compact();
        this.charBuffer().compact();
        int num_bytes = this.byteChannel.read(this.byteBuffer());
        while (0 == num_bytes) {
            Thread.sleep(1L);
            num_bytes = this.byteChannel.read(this.byteBuffer());
        }
        int n = num_bytes;
        if (n == -1) {
            this.endOfInput_$eq(true);
            this.byteBuffer().position(0);
            this.decoder.decode(this.byteBuffer(), this.charBuffer(), true);
            object = this.decoder.flush(this.charBuffer());
        } else {
            this.endOfInput_$eq(false);
            this.byteBuffer().flip();
            this.decoder.decode(this.byteBuffer(), this.charBuffer(), false);
            object = this.charBuffer().flip();
        }
        return object;
    }

    public void endOfInput_$eq(boolean x$1) {
        this.endOfInput = x$1;
    }

    public boolean endOfInput() {
        return this.endOfInput;
    }

    public void charBuffer_$eq(CharBuffer x$1) {
        this.charBuffer = x$1;
    }

    public CharBuffer charBuffer() {
        return this.charBuffer;
    }

    public ByteBuffer byteBuffer() {
        return this.byteBuffer;
    }

    public abstract void close();

    public abstract int buf_size();
}

