/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.midletsuite;

import com.sun.midp.io.j2me.storage.File;
import com.sun.midp.io.j2me.storage.RandomAccessStream;
import com.sun.midp.midlet.MIDletInfo;
import com.sun.midp.midlet.MIDletSuite;
import com.sun.midp.midlet.Scheduler;
import com.sun.midp.midlet.Selector;
import com.sun.midp.midletsuite.Installer;
import com.sun.midp.midletsuite.JadProperties;
import com.sun.midp.midletsuite.JarReader;
import com.sun.midp.midletsuite.ManifestProperties;
import com.sun.midp.security.SecurityDomain;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;

public class MIDletSuiteImpl
implements MIDletSuite {
    private static SecurityDomain classSecurityDomain;
    private Scheduler scheduler;
    private JadProperties bufferedJadProps = null;
    private ManifestProperties bufferedJarProps = null;
    private SecurityDomain securityDomain;
    private String storageRoot = null;
    private String initialMIDletClassName = null;
    private int numberOfMidlets = -1;

    static void initSecurityDomain(SecurityDomain theDomain) {
        if (classSecurityDomain != null) {
            return;
        }
        classSecurityDomain = theDomain;
    }

    protected MIDletSuiteImpl() {
    }

    MIDletSuiteImpl(SecurityDomain securityDomain, Scheduler aScheduler, String theStorageRoot, String securityDomainName, String midletToRun) {
        securityDomain.checkIfPermitted(9);
        this.scheduler = aScheduler;
        securityDomain = new SecurityDomain(classSecurityDomain, securityDomainName);
        this.storageRoot = theStorageRoot;
        if (midletToRun != null) {
            this.initialMIDletClassName = this.getMIDletClassName(midletToRun);
        }
    }

    public String getProperty(String key) {
        String prop;
        if (this.bufferedJadProps == null) {
            this.getPropertiesFromStorage();
            if (this.bufferedJadProps == null) {
                return null;
            }
        }
        if ((prop = this.bufferedJadProps.getProperty(key)) != null) {
            return prop;
        }
        if (this.bufferedJarProps == null) {
            return null;
        }
        return this.bufferedJarProps.getProperty(key);
    }

    public int getNumberOfMIDlets() {
        if (this.numberOfMidlets <= 0) {
            this.numberOfMidlets = this.countMIDlets();
        }
        return this.numberOfMidlets;
    }

    public void loadInitialMIDlet() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        String className = this.initialMIDletClassName;
        if (className == null && this.getNumberOfMIDlets() == 1) {
            className = new MIDletInfo((String)this.getProperty((String)"MIDlet-1")).classname;
        }
        this.loadInitialMIDlet(className, true);
    }

    protected void loadInitialMIDlet(String initialMIDletClassName, boolean selectorThatExits) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (initialMIDletClassName == null) {
            new Selector(selectorThatExits);
            return;
        }
        Class.forName(initialMIDletClassName).newInstance();
    }

    public String getSecurityDomainName() {
        return this.securityDomain.getName();
    }

    public void checkIfPermitted(int action) {
        this.securityDomain.checkIfPermitted(action);
    }

    public void schedule() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.scheduler.schedule(this);
    }

    public String getStorageRoot() {
        return this.storageRoot;
    }

    public byte[] getResource(String name) {
        if (name.charAt(0) == '/') {
            name = name.substring(1, name.length());
        }
        try {
            return JarReader.readJarEntry(classSecurityDomain, this.getStorageRoot() + "suite.jar", name);
        }
        catch (IOException e) {
            return null;
        }
    }

    public int getStorageUsed() {
        File file = new File(classSecurityDomain);
        RandomAccessStream stream = new RandomAccessStream(classSecurityDomain);
        int storageUsed = 0;
        Vector files = file.filenamesThatStartWith(this.getStorageRoot());
        int i = 0;
        while (i < files.size()) {
            try {
                stream.connect((String)files.elementAt(i), 1);
                storageUsed += stream.getSizeOf();
                stream.disconnect();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            ++i;
        }
        return storageUsed;
    }

    public String getJadUrl() {
        RandomAccessStream storage = new RandomAccessStream(classSecurityDomain);
        storage.connect(this.getStorageRoot() + "jadUrl.utf", 1);
        DataInputStream storageStream = storage.openDataInputStream();
        String t = storageStream.readUTF();
        try {
            storage.disconnect();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            try {
                return t;
            }
            catch (Throwable t2) {
                String string = "Unknown";
                return string;
            }
        }
        finally {
            try {
                storage.disconnect();
            }
            catch (IOException e) {}
        }
    }

    protected int countMIDlets() {
        int i = 1;
        while (this.getProperty("MIDlet-" + i) != null) {
            ++i;
        }
        return i - 1;
    }

    protected String getMIDletClassName(String midletName) {
        int i = 1;
        String midlet;
        while ((midlet = this.getProperty("MIDlet-" + i)) != null) {
            MIDletInfo midletInfo = new MIDletInfo(midlet);
            if (midletInfo.name.equals(midletName)) {
                return midletInfo.classname;
            }
            ++i;
        }
        return null;
    }

    private void getPropertiesFromStorage() {
        DataInputStream is;
        String jadEncoding = null;
        RandomAccessStream myStorage = new RandomAccessStream(classSecurityDomain);
        try {
            myStorage.connect(this.storageRoot + "jadEncoding.utf", 1);
            is = myStorage.openDataInputStream();
            try {
                jadEncoding = is.readUTF();
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                is.close();
                myStorage.disconnect();
            }
        }
        catch (IOException e) {}
        this.bufferedJadProps = new JadProperties();
        try {
            myStorage.connect(this.storageRoot + "suite.jad", 1);
            is = myStorage.openDataInputStream();
            try {
                Installer.getInstaller(classSecurityDomain).parseJad(is, jadEncoding, this.bufferedJadProps);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                is.close();
                myStorage.disconnect();
            }
            myStorage.connect(this.storageRoot + "suite.mf", 1);
            is = myStorage.openDataInputStream();
            try {
                this.bufferedJarProps = new ManifestProperties();
                this.bufferedJarProps.load(is);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                is.close();
                myStorage.disconnect();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }
}

