/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.nsc.reporters;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import scala.Console$;
import scala.MatchError;
import scala.Predef$;
import scala.ScalaObject;
import scala.compat.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesUtility;
import scala.tools.nsc.Settings;
import scala.tools.nsc.io.AbstractFile;
import scala.tools.nsc.reporters.AbstractReporter;
import scala.tools.nsc.reporters.ConsoleReporter$;
import scala.tools.nsc.reporters.Reporter;
import scala.tools.nsc.util.FakePos;
import scala.tools.nsc.util.NoPosition$;
import scala.tools.nsc.util.Position;
import scala.tools.nsc.util.SourceFile;

public class ConsoleReporter
extends AbstractReporter
implements ScalaObject {
    private boolean shortname;
    private PrintWriter writer;
    private BufferedReader reader;
    private Settings settings;

    public ConsoleReporter(Settings settings, BufferedReader reader, PrintWriter writer) {
        this.settings = settings;
        this.reader = reader;
        this.writer = writer;
        this.shortname = false;
    }

    public void displayPrompt() {
        try {
            boolean bl = true;
            while (true) {
                if (!bl) {
                    return;
                }
                this.writer.print("r)esume, a)bort: ");
                this.writer.flush();
                String line = this.reader.readLine();
                if (line == null) continue;
                if ("abort".startsWith(line = line.toLowerCase())) break;
                if (!"resume".startsWith(line)) continue;
                bl = false;
            }
            throw new Error("user abort");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new Error("input read error");
        }
    }

    public void display(Position pos, String msg, Reporter.Severity severity) {
        severity.count_$eq(severity.count() + 1);
        this.print(pos, msg, severity);
    }

    public void printSummary() {
        if (this.WARNING().count() > 0) {
            this.printMessage(this.getCountString(this.WARNING()) + " found");
        }
        if (this.ERROR().count() > 0) {
            this.printMessage(this.getCountString(this.ERROR()) + " found");
        }
    }

    public void printColumnMarker(Position pos) {
        if (!pos.column().isEmpty()) {
            StringBuilder buffer = new StringBuilder(BoxesUtility.unboxToInt(pos.column().get()));
            int i = 1;
            while (true) {
                if (i >= BoxesUtility.unboxToInt(pos.column().get())) {
                    if (BoxesUtility.unboxToInt(pos.column().get()) > 0) {
                        buffer.append('^');
                    }
                    this.printMessage(buffer.toString());
                    break;
                }
                buffer.append(' ');
                ++i;
            }
        }
    }

    public void printSourceLine(Position pos) {
        this.printMessage(Predef$.MODULE$.stringWrapper(pos.lineContent()).stripLineEnd());
        this.printColumnMarker(pos);
    }

    public void print(Position pos, String msg, Reporter.Severity severity) {
        this.printMessage(pos, this.clabel(severity) + msg);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void printMessage(Position posIn, String msg) {
        if (posIn != null) {
            Object object;
            Position pos$0 = posIn.inUltimateSource();
            StringBuilder buf = new StringBuilder(msg);
            buf.insert(0, " ");
            buf.insert(0, (String)pos$0.line().map(new $anonfun$0(this, pos$0)).get(":"));
            Position position = pos$0;
            if (position != NoPosition$.MODULE$) {
                if (!(position instanceof FakePos)) {
                    if (pos$0.source().isEmpty()) throw new MatchError(position);
                    AbstractFile file = ((SourceFile)pos$0.source().get()).file();
                    object = buf.insert(0, !this.shortname() ? file.path() : file.name());
                } else {
                    object = buf.insert(0, ((FakePos)position).msg());
                }
            } else {
                object = BoxedUnit.UNIT;
            }
            this.printMessage(buf.toString());
            this.printSourceLine(pos$0);
            return;
        } else {
            this.printMessage(msg);
        }
    }

    public void printMessage(String msg) {
        this.writer.println(msg);
    }

    private String getCountString(Reporter.Severity severity) {
        return this.countElementsAsString(severity.count(), this.label(severity));
    }

    public ConsoleReporter(Settings settings) {
        this(settings, Console$.MODULE$.in(), new PrintWriter(Console$.MODULE$.err(), true));
    }

    private String clabel(Reporter.Severity severity) {
        String label0 = this.label(severity);
        return label0 != null ? label0 + ": " : "";
    }

    private String label(Reporter.Severity severity) {
        String string;
        Reporter.Severity severity2 = severity;
        if (severity2 != this.ERROR()) {
            if (severity2 != this.WARNING()) {
                if (severity2 != this.INFO()) {
                    throw new MatchError(severity2);
                }
                string = null;
            } else {
                string = "warning";
            }
        } else {
            string = "error";
        }
        return string;
    }

    public void shortname_$eq(boolean x$1) {
        this.shortname = x$1;
    }

    public boolean shortname() {
        return this.shortname;
    }

    public Settings settings() {
        return this.settings;
    }
}

