/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lamp.compiler.msil.emit;

import ch.epfl.lamp.compiler.msil.Type;
import ch.epfl.lamp.compiler.msil.emit.Label$Scope$;
import ch.epfl.lamp.compiler.msil.emit.Label$Try$;
import ch.epfl.lamp.compiler.msil.emit.Visitable;
import ch.epfl.lamp.compiler.msil.emit.Visitor;

public final class Label
implements Visitable {
    private static final int DUMMY = -2147483647;
    private int address;
    private int stacksize;
    private Scope scopeInfo;
    private Try tryInfo;
    private static final /* synthetic */ boolean $assertionsDisabled;

    Label(int n, int n2) {
        this.address = n;
        this.stacksize = n2;
        this.scopeInfo = Scope.Current;
        this.tryInfo = Try.Normal;
    }

    Label() {
        this(-1, -2147483647);
    }

    Label(Label label) {
        this(label.address, label.stacksize);
    }

    boolean isInitialized() {
        return this.address != -1 || this.stacksize != -2147483647;
    }

    int getAddress() {
        return this.address;
    }

    int getStacksize() {
        return this.stacksize;
    }

    void setStacksize(int n) {
        if (!$assertionsDisabled && n < 0) {
            throw new AssertionError();
        }
        this.stacksize = n;
    }

    void incStacksize() {
        ++this.stacksize;
    }

    void setTryInfo(Try try_) {
        if (!$assertionsDisabled && try_ == null) {
            throw new AssertionError();
        }
        this.tryInfo = try_;
    }

    void setCatch(Type type) {
        this.tryInfo = Try.Catch(type);
    }

    Try getTryInfo() {
        return this.tryInfo;
    }

    void beginScope() {
        this.scopeInfo = Scope.NewScope;
    }

    void endScope() {
        this.scopeInfo = Scope.EndScope;
    }

    Scope getScopeInfo() {
        return this.scopeInfo;
    }

    void mergeWith(Label label) {
        int n;
        if (!$assertionsDisabled && this.address >= 0) {
            throw new AssertionError((Object)String.valueOf(String.valueOf("this.address = ".concat(String.valueOf(this.address)))));
        }
        this.address = label.address;
        label.stacksize = this.stacksize = (n = Math.max(this.stacksize, label.stacksize));
    }

    public String toString() {
        String string = "";
        if (this.address < 16) {
            string = "000";
        } else if (this.address < 256) {
            string = "00";
        } else if (this.address < 4096) {
            string = "0";
        }
        return String.valueOf(String.valueOf("IL_".concat(String.valueOf(String.valueOf(string))))).concat(String.valueOf(String.valueOf(Integer.toHexString(this.address))));
    }

    public String getString() {
        String string = super.toString();
        int n = string.lastIndexOf(46);
        return string.substring(n + 1, string.length());
    }

    public void apply(Visitor visitor) {
        visitor.caseLabel(this);
    }

    static {
        $assertionsDisabled = !Class.forName("ch.epfl.lamp.compiler.msil.emit.Label").desiredAssertionStatus();
    }

    static class Scope {
        public static /* synthetic */ Scope[] $extensions;
        public static /* synthetic */ int $subIDs;
        public static /* synthetic */ boolean[] $castable;
        public static final /* synthetic */ int $subID;
        public final /* synthetic */ int $tag;
        public static final Scope$$Var Current;
        public static final Scope$$Var EndScope;
        public static final Scope$$Var NewScope;

        public static /* synthetic */ int $register(Scope scope) {
            if ($subIDs == $extensions.length) {
                Scope[] scopeArray = new Scope[$extensions.length * 2];
                System.arraycopy($extensions, 0, scopeArray, 0, $extensions.length);
                $extensions = scopeArray;
                for (int i = 0; i < $subIDs; ++i) {
                    $extensions[i].$extend();
                }
            }
            Scope.$extensions[Scope.$subIDs] = scope;
            return $subIDs++;
        }

        public static /* synthetic */ Scope throw$cast$exception() {
            throw new ClassCastException();
        }

        public /* synthetic */ void $extend() {
            boolean[] blArray = new boolean[$castable.length * 2];
            System.arraycopy($castable, 0, blArray, 0, $castable.length);
            $castable = blArray;
        }

        public /* synthetic */ int $getSubID() {
            return $subID;
        }

        protected /* synthetic */ Scope(int n) {
            this.$tag = n;
        }

        static {
            $extensions = new Scope[]{null, null, null, null};
            $castable = new boolean[]{true, false, false, false};
            $subID = Scope.$register(new Scope(-1));
            Current = new Scope$$Var(0);
            EndScope = new Scope$$Var(1);
            NewScope = new Scope$$Var(2);
        }
    }

    static class Try {
        public static /* synthetic */ Try[] $extensions;
        public static /* synthetic */ int $subIDs;
        public static /* synthetic */ boolean[] $castable;
        public static final /* synthetic */ int $subID;
        public final /* synthetic */ int $tag;
        public static final Try$$Var End;
        public static final Try$$Var Filter;
        public static final Try$$Var FilterEnd;
        public static final Try$$Var Finally;
        public static final Try$$Var Normal;
        public static final Try$$Var Start;

        public static /* synthetic */ int $register(Try try_) {
            if ($subIDs == $extensions.length) {
                Try[] tryArray = new Try[$extensions.length * 2];
                System.arraycopy($extensions, 0, tryArray, 0, $extensions.length);
                $extensions = tryArray;
                for (int i = 0; i < $subIDs; ++i) {
                    $extensions[i].$extend();
                }
            }
            Try.$extensions[Try.$subIDs] = try_;
            return $subIDs++;
        }

        public static /* synthetic */ Try throw$cast$exception() {
            throw new ClassCastException();
        }

        public /* synthetic */ void $extend() {
            boolean[] blArray = new boolean[$castable.length * 2];
            System.arraycopy($castable, 0, blArray, 0, $castable.length);
            $castable = blArray;
        }

        public /* synthetic */ int $getSubID() {
            return $subID;
        }

        protected /* synthetic */ Try(int n) {
            this.$tag = n;
        }

        public static /* synthetic */ Catch Catch(Type type) {
            return new Catch(type);
        }

        static {
            $extensions = new Try[]{null, null, null, null};
            $castable = new boolean[]{true, false, false, false};
            $subID = Try.$register(new Try(-1));
            End = new Try$$Var(1);
            Filter = new Try$$Var(2);
            FilterEnd = new Try$$Var(3);
            Finally = new Try$$Var(4);
            Normal = new Try$$Var(5);
            Start = new Try$$Var(6);
        }

        public static class Catch
        extends Try {
            public /* synthetic */ Type type;

            protected /* synthetic */ Catch() {
                super(0);
            }

            public /* synthetic */ Catch(Type type) {
                super(0);
                this.type = type;
            }
        }
    }
}

