
// Copyright (c) 1996-2003 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@ieee.org
//          Dale E. Martin	dmartin@cliftonlabs.com
//          Timothy J. McBrayer 
//          Malolan Chetlur     
//          Krishnan Subramani  
//          Narayanan Thondugulam

#include "IIRScram_WaveformList.hh"
#include "IIR_WaveformElement.hh"
#include "savant.hh"

IIRScram_WaveformList::~IIRScram_WaveformList() {}

void 
IIRScram_WaveformList::_publish_vhdl(ostream &_vhdl_out) {
  IIR_WaveformElement* element = first();
  while (element != NULL) {
    element->_publish_vhdl(_vhdl_out);
    element = successor(element);
    if (element != NULL) {_vhdl_out << ", ";}
  }
}

void
IIRScram_WaveformList::_get_list_of_input_signals( set<IIR> *list ){
  IIR_WaveformElement* element = first();
  while( element != NULL ) {
    element->_get_list_of_input_signals(list);
    element = successor(element);
  }
}

void
IIRScram_WaveformList::_build_sensitivity_list(IIR_DesignatorList* sensitivity_list) {
  IIR_WaveformElement* element = first();
  for(; element != NULL; ) {
    element->_build_sensitivity_list(sensitivity_list);
    element = successor(element);
  }  
}

IIR_Boolean
IIRScram_WaveformList::_is_above_attribute_found() {
  IIR_Boolean retval = FALSE;
  IIR_WaveformElement* element = first();
  for(; element != NULL; element = successor(element)) {
    retval = retval || element->_is_above_attribute_found();
  }
  return retval;
}

void
IIRScram_WaveformList::
_build_above_attribute_set(set<IIR_AboveAttribute> *to_build) {
  IIR_WaveformElement* element = first();
  for(; element != NULL; element = successor(element)) {
    element->_build_above_attribute_set(to_build);
  }
}

visitor_return_type *IIRScram_WaveformList::_accept_visitor(node_visitor *visitor, visitor_argument_type *arg) {
  ASSERT(visitor != NULL);
  return visitor->visit_IIR_WaveformList(this, arg);
};
