// Copyright (c) 1996-2000 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Umesh Kumar V.Rajasekaran urajasek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu
//          Swaminathan Subramanian ssubrama@ececs.uc.edu
//	    Magnus Danielson	cfmd@swipnet.se

//---------------------------------------------------------------------------

#include "IIRScram.hh"
#include "IIRScram_SubtypeDeclaration.hh"
#include "IIR_Identifier.hh"
#include "IIR_DesignFile.hh"
#include "IIR_AttributeSpecificationList.hh"
#include "IIR_TextLiteral.hh"
#include "IIR_TypeDefinition.hh"
#include "IIR_AttributeSpecification.hh"
#include "IIR_LibraryDeclaration.hh"
#include "IIR_FunctionDeclaration.hh"
#include "set.hh"
#include "published_cc_file.hh"
#include "published_header_file.hh"
#include "sstream-wrap.hh"


IIRScram_SubtypeDeclaration::~IIRScram_SubtypeDeclaration() {}

IIR_Int32 
IIRScram_SubtypeDeclaration::_get_num_indexes(){
  ASSERT( get_subtype() != NULL );
  return get_subtype()->_get_num_indexes();
}

void 
IIRScram_SubtypeDeclaration::_publish_vhdl_decl(ostream &_vhdl_out) {
  ASSERT(get_subtype() != NULL);
  // This assertion is not true for:
  // type foo is ( red, green, blue );
  // subtype bar is foo;
  // (Or for any other type definition that isn't required to have an
  // anonymous base type.)
  //  ASSERT(get_subtype()->get_base_type() != NULL);
  

  _vhdl_out << "subtype ";
  get_declarator()->_publish_vhdl(_vhdl_out);
  if(get_subtype() != NULL) {
    _vhdl_out << " is ";

    get_subtype()->_publish_vhdl_subtype_decl(_vhdl_out);
  }
  _vhdl_out << ";\n";
}

void 
IIRScram_SubtypeDeclaration::_publish_cc_lvalue( published_file &_cc_out ) {

  //  SCRAM_CC_REF( _cc_out, "IIRScram_SubtypeDeclaration::_publish_cc" );

  _get_declarator()->_publish_cc_lvalue( _cc_out );
}

void
IIRScram_SubtypeDeclaration::_publish_cc_universal_type( published_file &_cc_out ){

  SCRAM_CC_REF( _cc_out, "IIRScram_SubtypeDeclaration::_publish_cc_universal_type" );

  get_subtype()->_publish_cc_universal_type( _cc_out );
}

const string
IIRScram_SubtypeDeclaration::_get_cc_type_name(){
  // SCRAM_CC_REF( _cc_out, "IIRScram_SubtypeDeclaration::_publish_cc_type_name" );
  return get_subtype()->_get_cc_type_name();
}

void 
IIRScram_SubtypeDeclaration::_publish_cc_headers( published_file &_cc_out ) {

  SCRAM_CC_REF( _cc_out, "IIRScram_SubtypeDeclaration::_publish_cc_headers" );

  _publish_cc_include( _cc_out );
  get_subtype()->_publish_cc_headers( _cc_out );
}

void 
IIRScram_SubtypeDeclaration::_publish_cc_range( published_file &_cc_out ) {

  SCRAM_CC_REF( _cc_out, "IIRScram_SubtypeDeclaration::_publish_cc_range" );

  // cerr << "IIRScram_SubtypeDeclaration::_publish_cc_range( published_file &_cc_out ) called!! " 
  // << "Trying to work around\n";
  get_subtype()->_publish_cc_range( _cc_out );
}

void
IIRScram_SubtypeDeclaration::_publish_cc_type_info( published_file &_cc_out ) {

  SCRAM_CC_REF( _cc_out, "IIRScram_SubtypeDeclaration::_publish_cc_type_info" );

  if (((_is_scalar_type() == TRUE) || (_is_array_type() == TRUE) ||
       (_is_record_type() == TRUE)) &&
      _is_access_type() == FALSE){
    get_subtype()->_publish_cc_type_info( _cc_out );
  }
}

void
IIRScram_SubtypeDeclaration::_publish_cc_extern_type_info( published_file &_cc_out ) {

  SCRAM_CC_REF( _cc_out, "IIRScram_SubtypeDeclaration::_publish_cc_extern_type_info" );

  if(((_is_scalar_type() == TRUE) || (_is_array_type() == TRUE) ||
      (_is_record_type() ==  TRUE)) &&
     (_is_access_type() == FALSE))  {
    get_subtype()->_publish_cc_extern_type_info( _cc_out );
    _cc_out << ";\n";
  }
}

void
IIRScram_SubtypeDeclaration::_publish_cc_include( published_file &_cc_out ){
  SCRAM_CC_REF( _cc_out, "IIRScram_SubtypeDeclaration::_publish_cc_include" );
  get_subtype()->_publish_cc_include( _cc_out );
}

IIRScram_Declaration::declaration_type 
IIRScram_SubtypeDeclaration::_get_type(){
   return SUBTYPE;
}

IIR_AttributeSpecificationList*
IIRScram_SubtypeDeclaration::_get_attribute_specification_list(){
  return &attributes;
}

IIR_Boolean 
IIRScram_SubtypeDeclaration::_is_scalar_type() {
  return get_subtype()->_is_scalar_type();
}

IIR_Boolean 
IIRScram_SubtypeDeclaration::_is_array_type() {
  return get_subtype()->_is_array_type();
}

IIR_Boolean 
IIRScram_SubtypeDeclaration::_is_record_type() {
  return get_subtype()->_is_record_type();
}

IIR_Boolean
IIRScram_SubtypeDeclaration::_is_resolved_type() {
  return get_subtype()->_is_resolved_type();
}

IIR_Boolean
IIRScram_SubtypeDeclaration::_is_kernel_type() {
  return get_subtype()->_is_kernel_type();
}

void
IIRScram_SubtypeDeclaration::_publish_vhdl_range(ostream &_vhdl_out){
  _publish_vhdl(_vhdl_out);
}

void
IIRScram_SubtypeDeclaration::_type_check(){
  ASSERT( get_subtype() != NULL );
  get_subtype()->_type_check();
}


IIR*
IIRScram_SubtypeDeclaration::_clone() {
  return this;
}

visitor_return_type *
IIRScram_SubtypeDeclaration::_accept_visitor( node_visitor *visitor, 
					      visitor_argument_type *arg ){
  ASSERT(visitor != NULL);
  return visitor->visit_IIR_SubtypeDeclaration(this, arg);
}
