// Copyright (c) 1996-2000 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu

//---------------------------------------------------------------------------
#include "IIRScram_StableAttribute.hh"
#include "IIR_Identifier.hh"
#include "IIR_PhysicalLiteral.hh"
#include "IIR_SignalDeclaration.hh"
#include "IIR_EnumerationSubtypeDefinition.hh"
#include "resolution_func.hh"
#include "symbol_table.hh"
#include "StandardPackage.hh"
#include "savant.hh"
#include "published_file.hh"

extern symbol_table *cgen_sym_tab_ptr;

IIRScram_StableAttribute::~IIRScram_StableAttribute() {}

void 
IIRScram_StableAttribute::_publish_vhdl(ostream &_vhdl_out) {
  ASSERT(get_prefix() != NULL);
  get_prefix()->_publish_vhdl(_vhdl_out);
  _vhdl_out << "'STABLE ";

  if (get_suffix() != NULL) {
    _vhdl_out << "(";
    get_suffix()->_publish_vhdl(_vhdl_out);
    _vhdl_out << ") ";
  }
}

IIR_TextLiteral *
IIRScram_StableAttribute::_build_attribute_name(){
  char *name = "stable";
  return IIR_Identifier::get( name, strlen(name) );
}

IIR_Boolean 
IIRScram_StableAttribute::_is_readable(){
  return get_prefix()->_is_readable();
}


IIR_TypeDefinition *
IIRScram_StableAttribute::get_subtype(){
  return StandardPackage::get_boolean_type();
}

IIR_Declaration *
IIRScram_StableAttribute::_get_implicit_declaration( const string &decl_name,
						     IIR_TypeDefinition *decl_type ){ 
  return _build_signal_declaration( decl_name, decl_type );
}

void 
IIRScram_StableAttribute::_publish_cc_lvalue( published_file &_cc_out ) {
  _publish_cc_signal_attribute( _cc_out, "Stable", TRUE );
}

void
IIRScram_StableAttribute::_publish_cc_necessary_decl_in_state( published_file &_cc_out ) {
  _publish_cc_necessary_signal_decl_in_state( _cc_out, STABLE, "_stable");
  _publish_cc_necessary_signal_decl_in_state( _cc_out, LAST_EVENT, "_last_event");
}

void
IIRScram_StableAttribute::_publish_cc_init_val( published_file &_cc_out ) { 
  _cc_out << "true";
}

void
IIRScram_StableAttribute::_publish_cc_name_in_caps( published_file &_cc_out ) {
  _cc_out << "STABLE";
}

void
IIRScram_StableAttribute::_publish_cc_attrib_type( published_file &_cc_out ) {
  _cc_out << "signal";
}

void
IIRScram_StableAttribute::_publish_cc_necessary_decl_init( published_file &_cc_out ) {
  _publish_cc_necessary_signal_init( _cc_out, STABLE, "_stable", TRUE );
  _publish_cc_necessary_signal_init( _cc_out, LAST_EVENT, "_last_event" );
}

void
IIRScram_StableAttribute::_publish_cc_elaborate( published_file &_cc_out ) {
  get_prefix()->_publish_cc_elaborate( _cc_out );
  _cc_out << "_stable";
}

void
IIRScram_StableAttribute::_publish_cc_sigtype( published_file &_cc_out ) {
  _cc_out << " I_STABLE;\n";
}

void 
IIRScram_StableAttribute::_publish_cc_state_object_init( published_file &_cc_out ) {
  _publish_cc_necessary_signal_state_object_init( _cc_out, STABLE, "_stable", TRUE);
  _publish_cc_necessary_signal_state_object_init( _cc_out, LAST_EVENT, "_last_event");
}

void 
IIRScram_StableAttribute::_publish_cc_necessary_copying( published_file &_cc_out ) {
  _publish_cc_necessary_attribute_copying( _cc_out, STABLE, "_stable" );
  _publish_cc_necessary_attribute_copying( _cc_out, LAST_EVENT, "_last_event" );
}

void 
IIRScram_StableAttribute::_publish_cc_read_or_write( published_file &_cc_out,
						     const string &fName, 
						     const string &sName ){
  _publish_cc_attribute_read_or_write( _cc_out, STABLE, "_stable", fName, sName);
  _publish_cc_attribute_read_or_write( _cc_out, LAST_EVENT, "_last_event", fName, sName);
}

void  
IIRScram_StableAttribute::_resolve_suffix_special() {
  _resolve_suffix_non_negative_time();
}

visitor_return_type *
IIRScram_StableAttribute::_accept_visitor( node_visitor *visitor, 
					   visitor_argument_type *arg ){
  ASSERT(visitor != NULL);
  return visitor->visit_IIR_StableAttribute(this, arg);
}
