
// Copyright (c) 1996-2003 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	philip.wilsey@ieee.org
//          Dale E. Martin	dmartin@cliftonlabs.com
//          Timothy J. McBrayer
//          Malolan Chetlur    
//          Umesh Kumar V. Rajasekaran
//          Krishnan Subramani 
//          Narayanan Thondugulam

#include "IIR_SequentialStatementList.hh"
#include "IIR_ReturnStatement.hh"
#include "IIR_AboveAttribute.hh"
#include "IIR_ProcedureCallStatement.hh"
#include "savant.hh"
#include "published_file.hh"
#include "IIR_Label.hh"

IIRScram_SequentialStatement::~IIRScram_SequentialStatement() {}

void
IIRScram_SequentialStatement::_publish_cc_exit_label( published_file &_cc_out ) {
  _cc_out << *_get_label() << "_exit_";
}

void
IIRScram_SequentialStatement::_publish_cc_next_label( published_file &_cc_out ) {
  _cc_out << *_get_label() << "_next_";
}

void
IIRScram_SequentialStatement::_publish_cc_decl_for_loop_iterator( published_file &_cc_out ) {
  // Dummy virtual function.  Overriden in IIRScram_ForLoopStatement
}

void 
IIRScram_SequentialStatement::_build_wait_list(dl_list<IIRScram_WaitStatement> *list) {
  // the default sequential statement does nothing during building wait lists.
}

void
IIRScram_SequentialStatement::_build_procedure_call_stmt_list(dl_list<IIR_ProcedureCallStatement> *) {
  // This is the default method.  This will be overridden in the required
  // classes
}

IIR_Boolean
IIRScram_SequentialStatement::_has_statement_list( ) {
  return FALSE;
}

IIR_Boolean
IIRScram_SequentialStatement::_type_check_return_statements( set<IIR_TypeDefinition> *, IIR_SubprogramDeclaration *subprogram_decl ) {
  _report_undefined_scram_fn("_type_check_return_statements( set<IIR_TypeDefinition> *)");

  return FALSE;
}

IIR_Boolean 
IIRScram_SequentialStatement::_type_check_return_statements( set<IIR_TypeDefinition> *context_set, IIR_SequentialStatementList *list, IIR_SubprogramDeclaration *subprogram_decl ){

  IIR_Boolean retval = FALSE;

  IIR_SequentialStatement *current_statement;
  current_statement = list->first();
  while( current_statement != NULL ){
    if( current_statement->get_kind() == IIR_RETURN_STATEMENT ){
      ((IIR_ReturnStatement *)current_statement)->set_enclosing_subprogram( subprogram_decl );
      ((IIR_ReturnStatement *)current_statement)->_type_check( context_set );
      retval = TRUE;
    }
    else if( current_statement->_has_statement_list() == TRUE ){
      IIR_Boolean found_one;
      found_one = 
	current_statement->_type_check_return_statements( context_set, subprogram_decl );
      if( found_one == TRUE ){
	retval = TRUE;
      }
    }
    current_statement = list->successor( current_statement );
  }

  return retval;
}

IIR *
IIRScram_SequentialStatement::_clone() {
  return IIR::_clone();
}


void
IIRScram_SequentialStatement::_clone( IIR *clone ){
  ASSERT( clone->_is_iir_sequential_statement() == TRUE );

  IIRScram::_clone( clone );
  // clone IIR_SequentialStatement info

  IIR_SequentialStatement *as_statement = (IIR_SequentialStatement *)clone;

  as_statement->set_label( get_label() );
}

IIR_Label *
IIRScram_SequentialStatement::_get_process_stmt_label(){
}

void
IIRScram_SequentialStatement::_set_process_stmt_label(IIR_Label *) {
}
