#ifndef IIRSCRAM_OPERATOR_HH
#define IIRSCRAM_OPERATOR_HH
// Copyright (c) 1996-2000 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu

//---------------------------------------------------------------------------
#include "IIR_Expression.hh"

class IIR_DesignatorList;
class IIR_AssociationList;
class IIR_SubprogramDeclaration;

class IIRScram_Operator : public IIR_Expression {

public:
  ostream &_print( ostream & );

  virtual IIR_Int32 _get_num_args() = 0;
  virtual IIR_AssociationList *_build_argument_list() = 0;

  set<IIR_TypeDefinition> *_get_rval_set(IIR_Boolean (IIR::*constraint_function)()=0); 
  set<IIR_TypeDefinition> *_get_user_overloaded_rvals();
  set<IIR_Declaration> *_symbol_lookup();

  // This is the entrance into the type checking routines for
  // operators...
  void _type_check( set<IIR_TypeDefinition> * );

  // If this operator is a call to one that's user overloaded, this
  // method transforms it into an IIR_FunctionCall.
  IIR *_semantic_transform( set<IIR_TypeDefinition> * );

  // This method looks for a user overloaded version of an operator
  // and returns true if a valid user overloading of the operator is
  // found.  If not, the type_checking assumes a valid VHDL default
  // definition of the operator is being used.  See next method.
  IIR_Boolean _type_check_user_declared( set<IIR_TypeDefinition> * );    
  
  IIR *_rval_to_decl( IIR_TypeDefinition * );

  virtual void set_implementation( IIR_SubprogramDeclaration * ) = 0;
  virtual IIR_SubprogramDeclaration *get_implementation() = 0;

  void _publish_cc_kernel_type( published_file &pf );

  /**
     Return the operator name used when publishing C++.
  */
  virtual const string &_get_cc_operator_name() const = 0;

protected:
  IIRScram_Operator(){ 
    my_rvals = NULL;
    has_been_type_checked = FALSE;
  }
  
  virtual ~IIRScram_Operator() = 0;
  
  virtual const string _get_function_name() const = 0;  

  // We've found an implementation for this node - now we'll type check the
  // operands.
  virtual void _type_check_operands( ) = 0;

private:
  set<IIR_TypeDefinition> *my_rvals;
  IIR_Boolean has_been_type_checked;
};
#endif
