// Copyright (c) 1996-2000 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcrbaye@ece.uc.edu
// 	    Krishnan Subramani  skrish@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Radharamanan Radhakrishnan  ramanan@ece.uc.edu

//---------------------------------------------------------------------------
#include "IIR_LastActiveAttribute.hh"
#include "IIR_Identifier.hh"
#include "IIR_SignalDeclaration.hh"
#include "IIR_PhysicalSubtypeDefinition.hh"
#include "IIR_FunctionDeclaration.hh"
#include "StandardPackage.hh"
#include "set.hh"
#include "symbol_table.hh"
#include "published_file.hh"

extern symbol_table *cgen_sym_tab_ptr;

IIRScram_LastActiveAttribute::~IIRScram_LastActiveAttribute() {}

void 
IIRScram_LastActiveAttribute::_publish_vhdl(ostream &_vhdl_out) {
  ASSERT( get_prefix() != NULL );
  ASSERT(get_prefix()->_is_resolved() == TRUE );
  ASSERT(get_prefix()->_is_signal() == TRUE );
  get_prefix()->_publish_vhdl(_vhdl_out);
  _vhdl_out << "'LAST_ACTIVE ";
}

IIR_TextLiteral *
IIRScram_LastActiveAttribute::_build_attribute_name() {
  char *name = "last_active";
  return IIR_Identifier::get( name, strlen(name) );
}


IIR_Declaration *
IIRScram_LastActiveAttribute::_get_implicit_declaration( const string &decl_name,
							 IIR_TypeDefinition *decl_type ){
  return _build_function_declaration( decl_name, decl_type );
}

IIR_Boolean
IIRScram_LastActiveAttribute::_is_readable(){
  return get_prefix()->_is_readable();
}

IIR_TypeDefinition *
IIRScram_LastActiveAttribute::get_subtype(){
  return StandardPackage::get_time_type();
}

void
IIRScram_LastActiveAttribute::_publish_cc_lvalue( published_file &_cc_out ) {
  _publish_cc_signal_attribute( _cc_out, "LastActive" );
}

void
IIRScram_LastActiveAttribute::_publish_cc_init_val( published_file &_cc_out ) {
  ASSERT( get_prefix() != NULL );
  ASSERT(get_prefix()->_is_resolved() == TRUE );
  ASSERT(get_prefix()->_is_signal() == TRUE );
  if(((IIR_SignalDeclaration *)get_prefix())->get_value() == NULL) {
    _cc_out << "UniversalInteger(-1)";
  } else {
    _cc_out << "UniversalInteger(0)";
  }
}

void
IIRScram_LastActiveAttribute::_publish_cc_necessary_decl_in_state( published_file &_cc_out ) { 
  IIR_Declaration* decl;
  IIR* prefix = get_prefix();

  ASSERT((prefix->_is_signal() == TRUE) ||
	 (prefix->_is_attribute() == TRUE));
  
  if(prefix->_is_signal() == TRUE) {
    decl = ((IIR_Declaration*)prefix);
  }
  else {
    decl = ((IIR_Attribute*)prefix)->_get_implicit_declaration();      
  }

  if(!prefix->_is_published_attribute_in_state(IIR_Declaration::LAST_ACTIVE)) {
    if(decl->_is_scalar_type() == TRUE) {
      _cc_out << "  PhysicalType";
    }
    else {
      _cc_out << decl->get_subtype()->_get_cc_type_name();
    }
    _cc_out << " ";
    decl->_get_declarator()->_publish_cc_lvalue( _cc_out );
    _cc_out << "_last_active";
    _cc_out << ";\n";
    prefix->_add_published_attribute_in_state(IIR_Declaration::LAST_ACTIVE);
  }
}

void
IIRScram_LastActiveAttribute::_publish_cc_name_in_caps( published_file &_cc_out ) {

  _cc_out << "LAST_ACTIVE";
}

// Used in State::initialize for attribute[#].value.time
void
IIRScram_LastActiveAttribute::_publish_cc_attrib_type( published_file &_cc_out ) {

  _cc_out << "time";
}

void
IIRScram_LastActiveAttribute::_publish_cc_necessary_decl_init( published_file &_cc_out ){ }

void
IIRScram_LastActiveAttribute::_publish_cc_elaborate( published_file &_cc_out ){
  ASSERT( get_prefix() != NULL );
  ASSERT(get_prefix()->_is_resolved() == TRUE );
  ASSERT(get_prefix()->_is_signal() == TRUE );
  get_prefix()->_publish_cc_elaborate( _cc_out );
  _cc_out << "_last_active";
}

void
IIRScram_LastActiveAttribute::_publish_cc_sigtype( published_file &_cc_out ) {
  _cc_out << "";
}

void
IIRScram_LastActiveAttribute::_publish_cc_state_object_init( published_file &_cc_out ) {
  ASSERT( get_prefix() != NULL );
  ASSERT(get_prefix()->_is_resolved() == TRUE );

  IIR_Declaration* decl;
  IIR* prefix = get_prefix();

  ASSERT((prefix->_is_signal() == TRUE) ||
	 (prefix->_is_attribute() == TRUE));
  
  if(prefix->_is_signal() == TRUE) {
    decl = ((IIR_Declaration*)prefix);
  }
  else {
    decl = ((IIR_Attribute*)prefix)->_get_implicit_declaration();      
  }

  if(!prefix->_is_published_attribute_in_constructor(IIR_Declaration::LAST_ACTIVE)) {
    decl->_get_declarator()->_publish_cc_lvalue( _cc_out );
    _cc_out << OS("_last_active(ObjectBase::VARIABLE");
    if(decl->_is_array_type() == TRUE) {
      _cc_out << "," << NL();
      decl->get_subtype()->_publish_cc_range( _cc_out );
    }
    _cc_out << CS(")")
	    << "," << NL();    
    prefix->_add_published_attribute_in_constructor(IIR_Declaration::LAST_ACTIVE);
  }
}


void
IIRScram_LastActiveAttribute::_publish_cc_init( published_file &_cc_out ) {

  ASSERT( get_prefix() != NULL );
  ASSERT(get_prefix()->_is_resolved() == TRUE );

  IIR_Declaration* decl;
  IIR* prefix = get_prefix();
  IIR_TypeDefinition* type_def = _get_explicit_signal_type();

  ASSERT((prefix->_is_signal() == TRUE) ||
	 (prefix->_is_attribute() == TRUE));
  
  if(prefix->_is_signal() == TRUE) {
    decl = ((IIR_Declaration*)prefix);
  }
  else {
    decl = ((IIR_Attribute*)prefix)->_get_implicit_declaration();      
  }

  if(!prefix->_is_published_attribute_in_initstate(IIR_Declaration::LAST_ACTIVE)) {
    decl->_get_declarator()->_publish_cc_lvalue( _cc_out );
    _cc_out << "_last_active = ";
    if(type_def->_is_scalar_type() == TRUE) {
      _cc_out << OS("PhysicalType(ObjectBase::VARIABLE,")
	      << "UniversalLongLongInteger(-1)," << NL()
	      << "SavanttimeType_info"
	      << CS(");");
    }
    else if((type_def->_is_array_type() == TRUE) || (type_def->_is_record_type() == TRUE)) {
      _cc_out << type_def->_get_cc_type_name();
      _cc_out << OS("_lastevent(ObjectBase::VARIABLE");
      if((type_def->_is_array_type() == TRUE) &&
	 (type_def->_is_anonymous() == TRUE)) {
	_cc_out << "," << NL();
	type_def->_publish_cc_range( _cc_out );
      }
      _cc_out << "," << NL()
	      << "1," << NL()
	      << OS("new ElementAssociation(")
	      << "Others," << NL()
	      << OS("new PhysicalType(")
	      << "ObjectBase::VARIABLE," << NL()
	      << "UniversalLongLongInteger(-1)," << NL()
	      << "SavanttimeType_info"
	      << CS(")")
	      << CS(")");
      _cc_out << CS(");");
    }
    prefix->_add_published_attribute_in_initstate(IIR_Declaration::LAST_ACTIVE);
  }
}


IIR *
IIRScram_LastActiveAttribute::_clone() {
  IIR_LastActiveAttribute *clone = new IIR_LastActiveAttribute;
  IIR_Attribute::_clone( clone );
  return clone;
}

visitor_return_type *IIRScram_LastActiveAttribute::_accept_visitor(node_visitor *visitor, visitor_argument_type *arg) {
  ASSERT(visitor != NULL);
  return visitor->visit_IIR_LastActiveAttribute(this, arg);
};
