#ifndef IIRSCRAM_INTERFACE_LIST_HH
#define IIRSCRAM_INTERFACE_LIST_HH
// Copyright (c) 1996-2000 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
#include "IIRBase_InterfaceList.hh"

class IIRScram_InterfaceList : public IIRBase_InterfaceList {

public:

  /// Accept visitations \Ref{_accept_visitor}.
  visitor_return_type* _accept_visitor(node_visitor *, visitor_argument_type *);

  void _publish_vhdl(ostream &);
  void _publish_vhdl_decl(ostream &);
  void _publish_cc_decl( published_file &_cc_out );

  void _publish_cc_decl_subprogram_args( published_file &_cc_out, 
					 IIR_Boolean _to_publish_default_argument);

  void _publish_cc_local_parameter_args( published_file &_cc_out );

  /** Used by IIRScram_AssociationList#_build_default_map to find formals
      corresponding to the actuals that exist.  Returns null if no matching
      formal is found. */
  IIR_InterfaceDeclaration *_find_declaration( IIR_TextLiteral *declarator );
  
protected:
  IIRScram_InterfaceList() {}
  virtual ~IIRScram_InterfaceList() = 0;
    
private:
};
#endif
