
// Copyright (c) 1996-2003 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO
// THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
// PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES
// SUFFERED BY LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING
// OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found
// in the file "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	philip.wilsey@ieee.org
//          Dale E. Martin	dmartin@cliftonlabs.com
//          Timothy J. McBrayer
//          Malolan Chetlur    
//          Krishnan Subramani 
//          Umesh Kumar V. Rajasekaran
//          Narayanan Thondugulam

#include "IIRScram_ForLoopStatement.hh"
#include "IIR_Identifier.hh"
#include "IIR_ConstantDeclaration.hh"
#include "IIR_RangeTypeDefinition.hh"
#include "IIR_Label.hh"
#include "IIR_SequentialStatementList.hh"
#include "IIR_ConstantDeclaration.hh"
#include "IIR_Attribute.hh"
#include "IIR_AccessTypeDefinition.hh"
#include "IIR_AboveAttribute.hh"
#include "symbol_table.hh"
#include "sstream-wrap.hh"
#include "published_file.hh"

extern bool parse_error;
extern symbol_table *cgen_sym_tab_ptr;

IIRScram_ForLoopStatement::~IIRScram_ForLoopStatement() {
}

void 
IIRScram_ForLoopStatement::_publish_vhdl(ostream &_vhdl_out) {

  ASSERT(get_iteration_scheme() != NULL);
  ASSERT(get_iteration_scheme()->_is_resolved() == TRUE);

  _publish_vhdl_stmt_label(_vhdl_out);
    
  _vhdl_out << "for ";
  get_iteration_scheme()->get_declarator()->_publish_vhdl(_vhdl_out);
  _vhdl_out << " in ";

  get_iteration_scheme()->get_subtype()->_publish_vhdl(_vhdl_out);
  
  _vhdl_out << " loop\n";

  if (sequence_of_statements.num_elements() != 0) {
    sequence_of_statements._publish_vhdl(_vhdl_out);
  }

  _vhdl_out << "end loop";
}

void 
IIRScram_ForLoopStatement::_publish_cc( published_file &_cc_out ) {
  ASSERT(get_iteration_scheme() != NULL);
  ASSERT(get_iteration_scheme()->_is_resolved() == TRUE);

  _cc_out << *_get_label() << ":" << NL()
	  << OS("{");
  SCRAM_CC_REF( _cc_out, "IIRScram_ForLoopStatement::_publish_cc" );
  _cc_out << "assignVariable" << OS("(");
  get_iteration_scheme()->_publish_cc_lvalue( _cc_out );
  _cc_out << "," << NL();
  get_iteration_scheme()->_publish_cc_left( _cc_out );
  _cc_out << "," << NL() 
	  << "nullInfo," << NL() 
	  << "nullInfo" 
	  << CS(");");
  
  _cc_out << OS("while( SAVANT_BOOLEAN_TRUE == ");
  get_iteration_scheme()->_publish_cc_rvalue( _cc_out );
  if(get_iteration_scheme()->_is_ascending_range() == TRUE) {
    _cc_out << ".vhdlLessThanEqual";
  } else {
    _cc_out << ".vhdlGreaterThanEqual";
  }
  _cc_out << OS("(");
  get_iteration_scheme()->_publish_cc_right( _cc_out );
  _cc_out << CS(")") 
	  << CS(")") 
	  << OS("{");
  if (sequence_of_statements.num_elements() != 0) {
    sequence_of_statements._publish_cc( _cc_out );
  }
  
  _publish_cc_next_label( _cc_out );
  _cc_out << ":" << NL();
  
  get_iteration_scheme()->_publish_cc_lvalue( _cc_out );
  _cc_out << ".";
  if(get_iteration_scheme()->_is_ascending_range() == TRUE) {
    _cc_out << "increment()";
  }
  else {
    _cc_out << "decrement()";
  }
  _cc_out << ";" << NL();
  
  _cc_out << "if(";
  get_iteration_scheme()->_publish_cc_lvalue( _cc_out );
  _cc_out << ".overflow() == true)" << OS("{")
	  << "break;"
	  << CS("}")
	  << CS("}");

  _cc_out << CS("}");
  _publish_cc_exit_label( _cc_out );
  _cc_out << ":;" << NL();
}

void 
IIRScram_ForLoopStatement::_publish_cc_attr_of_range_attribute( published_file &_cc_out,
								const char *attr, 
								IIR_Attribute* range_attr ){
  IIR_Boolean type_flag = FALSE;
  
  if(range_attr->get_prefix()->_is_object() == FALSE) {
    if(range_attr->get_prefix()->get_kind() == IIR_TYPE_DECLARATION){
      type_flag = TRUE;
      _cc_out << range_attr->get_prefix()->_get_cc_type_name();
      _cc_out << "::" << attr << "(";
    }
  }
  else if(range_attr->get_prefix()->_is_access_type() == TRUE) {
    IIR_AccessTypeDefinition* access_type = (IIR_AccessTypeDefinition*)range_attr->get_prefix()->get_subtype();
    if ((access_type->get_designated_type()->_is_array_type() == TRUE) && (access_type->get_designated_type()->_is_unconstrained_array_type() == FALSE)) {
      _cc_out << access_type->get_designated_type()->_get_cc_type_name();
      _cc_out << "::" << attr << "(";
    }
    else {
      ASSERT ( access_type->get_designated_type() != NULL );
      _cc_out << "((";
      _cc_out << access_type->get_designated_type()->_get_cc_type_name();
      _cc_out << " &)";
      _cc_out << "(";      
      range_attr->get_prefix()->_publish_cc_lvalue( _cc_out );
      _cc_out << ".all()))." << attr << "_O(";
    }
  }
  else {
    range_attr->get_prefix()->_publish_cc_lvalue( _cc_out );
    _cc_out << "." << attr << "_O(";
  }
  if(range_attr->_get_suffix() != NULL) {
    range_attr->_get_suffix()->_publish_cc_lvalue( _cc_out );
    if (type_flag == TRUE) {
      // Need to publish the type_info also after the function call for types
      // as they are a part of the kernel now.
      _cc_out << ", ";
      _cc_out << range_attr->get_prefix()->_get_cc_type_name();
      _cc_out << "_info";
    }    
  } else {
    _cc_out << "IntegerType(ObjectBase::VARIABLE, UniversalInteger(1)"
	    << ", SavantintegerType_info)";
  }

  _cc_out << ")";
}

void
IIRScram_ForLoopStatement::_publish_cc_low_of_range_attribute( published_file &_cc_out,
							       IIR_Attribute* range_attr ){
  if( range_attr->get_kind() == IIR_RANGE_ATTRIBUTE ){
    _publish_cc_attr_of_range_attribute( _cc_out, "LEFT", range_attr );
  }
  else{
    _publish_cc_attr_of_range_attribute( _cc_out, "RIGHT", range_attr );
  }
}

void
IIRScram_ForLoopStatement::_publish_cc_high_of_range_attribute( published_file &_cc_out,
								IIR_Attribute* range_attr ){
  if(range_attr->get_kind() == IIR_RANGE_ATTRIBUTE) {
    _publish_cc_attr_of_range_attribute( _cc_out, "RIGHT", range_attr );  
  }
  else {
    _publish_cc_attr_of_range_attribute( _cc_out, "LEFT", range_attr );  
  }
}

void
IIRScram_ForLoopStatement::_publish_cc_ascending_of_range_attribute( published_file &_cc_out,
								     IIR_Attribute* range_attr ){
  _publish_cc_attr_of_range_attribute( _cc_out, "ASCENDING", range_attr );  
}

void
IIRScram_ForLoopStatement::_publish_cc_decl_for_loop_iterator( published_file &_cc_out ) {
  ASSERT(_is_currently_publishing_subprogram() == TRUE);

  _cc_out << get_iteration_scheme()->_get_cc_type_name();
  _cc_out << " ";
  get_iteration_scheme()->_publish_cc_lvalue( _cc_out );
  _cc_out << "(ObjectBase::VARIABLE);\n";

  sequence_of_statements._publish_cc_decl_for_loop_iterator( _cc_out );
}

void
IIRScram_ForLoopStatement::_build_wait_list(dl_list<IIRScram_WaitStatement>* list) {
  sequence_of_statements._build_wait_list(list);
}

void 
IIRScram_ForLoopStatement::_build_procedure_call_stmt_list(dl_list<IIR_ProcedureCallStatement> *list) {
  sequence_of_statements._build_procedure_call_stmt_list(list);
}

void
IIRScram_ForLoopStatement::_get_list_of_input_signals( set<IIR> *list ){
  sequence_of_statements._get_list_of_input_signals(list) ;
}

void
IIRScram_ForLoopStatement::_get_signal_source_info( set<IIR> *siginfo ){
  sequence_of_statements._get_signal_source_info(siginfo);
}

void 
IIRScram_ForLoopStatement::_type_check(){
  ASSERT( get_iteration_scheme() != NULL );  
  get_iteration_scheme()->set_subtype( _type_check_iteration_scheme(get_iteration_scheme() ) );
}

IIR_Boolean 
IIRScram_ForLoopStatement::_type_check_return_statements( set<IIR_TypeDefinition> *context_set, 
							  IIR_SubprogramDeclaration *subprogram_decl ){
  IIR_Boolean retval;

  ASSERT( get_iteration_scheme() != NULL && get_iteration_scheme()->_is_resolved() == TRUE );
  
  _get_symbol_table()->open_scope( this );
  _get_symbol_table()->make_visible( get_iteration_scheme() );
  retval = IIR_SequentialStatement::_type_check_return_statements( context_set, 
								   &sequence_of_statements, 
								   subprogram_decl );
  _get_symbol_table()->close_scope( this );

  return retval;
}

set<IIR_Declaration> *
IIRScram_ForLoopStatement::_find_declarations( IIR_Name *to_find ){
  ASSERT( get_iteration_scheme() != NULL );
  IIR_TextLiteral *loop_param = get_iteration_scheme()->get_declarator();
  if( IIR_TextLiteral::_cmp( loop_param, to_find ) == 0 ){
    return new set<IIR_Declaration>(get_iteration_scheme());
  }
  else{
    return NULL;
  }
}

IIR_Boolean
IIRScram_ForLoopStatement::_is_above_attribute_found() {
  return sequence_of_statements._is_above_attribute_found();
}

void
IIRScram_ForLoopStatement::
_build_above_attribute_set(set<IIR_AboveAttribute> *to_build) {
  sequence_of_statements._build_above_attribute_set(to_build);
}

visitor_return_type *IIRScram_ForLoopStatement::_accept_visitor(node_visitor *visitor, visitor_argument_type *arg) {
  ASSERT(visitor != NULL);
  return visitor->visit_IIR_ForLoopStatement(this, arg);
};
