#ifndef IIRSCRAM_FILE_TYPE_DEFINITION_HH
#define IIRSCRAM_FILE_TYPE_DEFINITION_HH
// Copyright (c) 1996-2000 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu
//          Swaminathan Subramanian ssubrama@ececs.uc.edu

//---------------------------------------------------------------------------
#include "IIRBase_FileTypeDefinition.hh"

class IIR_TypeDeclaration;
class IIR_FileTypeDefinition;

class IIRScram_FileTypeDefinition : public IIRBase_FileTypeDefinition {

public:

  /// Accept visitations \Ref{_accept_visitor}.
  visitor_return_type* _accept_visitor(node_visitor *, visitor_argument_type *);

  void _publish_vhdl_decl(ostream &);

  /** This function builds the implicit declarations associated with
      file types.  It also adds the declarations to the symbol table
      and to the type's list of implicit_declarations. */
  void  _come_into_scope( symbol_table *, IIR_TypeDeclaration * );

  void _publish_cc_headers( published_file &_cc_out );
  const string _get_cc_kernel_type();
  void _publish_cc_data_members( published_file &_cc_out );
  void _publish_cc_decl_constructors( published_file &_cc_out );
  void _publish_cc_decl_operator_equalto( published_file &_cc_out );
  void _publish_cc_decl_type_attributes( published_file &_cc_out );
  void _publish_cc_decl_cc( published_file &_cc_out );
  void _publish_cc_decl_destructors( published_file &_cc_out );
  void _publish_cc_decl_predefined_procedures_prototypes( published_file &_cc_out );
  const string _get_cc_type_name();

  void _publish_cc_extern_type_info( published_file &_cc_out );
  void _publish_cc_type_info( published_file &_cc_out );
  
  virtual IIR_Boolean _is_file_type(){ return TRUE; }  

  IIR_Boolean _is_locally_static(){ return TRUE; }
  IIR_Boolean _is_globally_static(){ return TRUE; }

  void _set_resolution_function( IIR_FunctionDeclaration * );

protected:
  IIRScram_FileTypeDefinition() {}
  virtual ~IIRScram_FileTypeDefinition() = 0;
    
private:
};
#endif
