#ifndef IIRSCRAM_ELSIF_HH
#define IIRSCRAM_ELSIF_HH

// Copyright (c) 1996-2000 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu

//---------------------------------------------------------------------------

#include "IIRBase_Elsif.hh"
class IIRScram_WaitStatement;
class IIR_DesignatorList;
class IIR_TypeDefinition;
template <class type> class set;
class IIR_SubprogramDeclaration;
class IIR_ProcedureCallStatement;
class IIR_List ;

class IIRScram_Elsif : public IIRBase_Elsif {




public:

  /// Accept visitations \Ref{_accept_visitor}.
  visitor_return_type* _accept_visitor(node_visitor *, visitor_argument_type *);

  void _publish_vhdl(ostream &);

  void _publish_cc( published_file &_cc_out );
  void _publish_cc_decl_for_loop_iterator( published_file &_cc_out );

  void _build_wait_list(dl_list<IIRScram_WaitStatement>* );
  void _build_procedure_call_stmt_list(dl_list<IIR_ProcedureCallStatement>*);
  void _get_list_of_input_signals( set<IIR> *list );
  void _get_signal_source_info( set<IIR> *siginfo );
  void _type_check( set<IIR_TypeDefinition> * );
  IIR_Boolean _type_check_return_statements( set<IIR_TypeDefinition> *,
			     IIR_SubprogramDeclaration *subprogram_decl );
    
  IIR *_clone();

protected:
  IIRScram_Elsif() {};
  virtual ~IIRScram_Elsif() = 0;

private:
};
#endif
