
#ifndef IIRSCRAM_COMPONENT_INSTANTIATION_STATEMENT_HH
#define IIRSCRAM_COMPONENT_INSTANTIATION_STATEMENT_HH

// Copyright (c) 1996-2003 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	philip.wilsey@ieee.org
//          Dale E. Martin	dmartin@cliftonlabs.com
//          Malolan Chetlur     
//          Umesh Kumar V. Rajasekaran
//          Krishnan Subramani  
//          Narayanan Thondugulam
//          Timothy J. McBrayer

#include "IIRBase_ComponentInstantiationStatement.hh"

class IIR_DeclarationList;
class IIR_ConfigurationSpecification;
class IIR_ComponentDeclaration;
class IIR_ConfigurationSpecification;
class IIR_ComponentInstantiationStatement;

class IIRScram_ComponentInstantiationStatement : public IIRBase_ComponentInstantiationStatement{

public:
  /// Accept visitations \Ref{_accept_visitor}.
  visitor_return_type* _accept_visitor(node_visitor *, visitor_argument_type *);

  void _publish_vhdl(ostream &);

  // This method _only_ resolves the instantiated unit, and it gets called
  // from the parser during the parse.  (Type check of configuration
  // specifications and component configurations requires this information
  // to be resolved.)
  void _type_check_instantiated_unit();

  // This does the _rest_ of the type checking, which can only happen
  // _after_ configuration specifications are resolved.
  void _type_check();

  // This method is overriding one defined in IIRScram_ConcurrentStatement
  // to actually do the type checking for this statement.
  void _type_check_instantiate_statements(){ _type_check(); }


  void _publish_cc_binding_name( ostream& outstream );
  void _publish_createNetInfo( published_file &_cc_out );

  void _publish_cc_elaborate_Add( published_file &_cc_out, 
				  IIR_AssociationElement* actual_clause, 
				  IIR_Label* label);

  void _publish_cc_elaborate_addChild( published_file &_cc_out,
				       IIR_AssociationElement* actual_clause, 
				       IIR_Label* label);

  void _publish_cc_elaborate_UpType( published_file &_cc_out,
				     IIR_AssociationElement* actual_clause, 
				     IIR_Label* label);

  void _publish_cc_elaborate_DownType( published_file &_cc_out,
				       IIR_AssociationElement* actual_clause, 
				       IIR_Label* label);
  /** Publish the full call to "connect". */
  void _publish_cc_connect_call( published_file &_cc_out );
  /**
     Used by _publish_cc_connect_call.
  */
  void _publish_connect( published_file &_cc_out );
  void _publish_connect_terminals( published_file &_cc_out );
  void _publish_form_characteristic_expressions( published_file & );

#ifdef PROCESS_GRAPH
  void _publish_cc_driver_info( published_file &_cc_out );
#endif
  void _publish_cc_concurrent_stmt_init( published_file &_cc_out, IIR_DeclarationList *decl_list );
  IIR_ConfigurationSpecification* _get_configuration_specification(IIR_DeclarationList* decl_list);
  IIR_ConfigurationSpecification* _get_configuration_specification_from_any_scope(IIR_DeclarationList* decl_list);
  IIR_AssociationList *_get_generic_map_aspect() {
    return &generic_map_aspect;
  }
  
  IIR_TypeDefinition *_get_port_type( int );

  /** These methods provide a place for the parser to store what type
      of declaration the semantic routines should be looking for... */
  void _set_instantiation_type( IIR_Kind );
  IIR_Kind _get_instantiation_type();

#ifdef PROCESS_COMBINATION
  void _static_elaborate(IIR_ArchitectureDeclaration*, IIR_DeclarationList*,
			 char*);
#endif

  IIR_Label *_find_instantiate_label( IIR_SimpleName * );

  IIR* _transmute();

  /** This returns the configuration for this component.  It can be an
      IIR_ConfigurationSpecification, or an IIR_ComponentConfiguration. */
  IIR *_get_configuration();
  void _set_configuration( IIR *new_config );
  
protected:
  IIRScram_ComponentInstantiationStatement();
  virtual ~IIRScram_ComponentInstantiationStatement() = 0;

  // Methods used to _transmute()
  IIR_ComponentDeclaration *
  _build_implicit_component_declaration(IIR_EntityDeclaration *, const string &componentName );

  IIR_ConfigurationSpecification *
  _build_implicit_configuration_specification(IIR_LibraryUnit *, IIR_ComponentDeclaration *);
  
  void _add_to_configuration_specification(IIR_DeclarationList *, IIR_ComponentDeclaration *, IIR_ComponentInstantiationStatement *);


private:
  /** Returns the instantiated unit - the instantiation type is ENTITY. */
  void _resolve_instantiated_unit_for_entity();
  /** Returns the instantiated unit - the instantiation type is COMPONENT. */
  void _resolve_instantiated_unit_for_component();

  /** Returns the default entity/architecture if there is one, by the rules
      of 5.2.2 in the '93 LRM.  */
  IIR_ConfigurationSpecification *_get_default_binding_indication();
  /** Does the actual building for _get_default_binding_indication() */
  IIR_ConfigurationSpecification *_build_default_entity_aspect( IIR *component_name,
								IIR_ArchitectureDeclaration *arch);


  IIR_Kind my_instantiation_type;
  IIR *my_configuration;
};
#endif
