// Copyright (c) 1996-2000 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu
//	    Magnus Danielson	cfmd@swipnet.se

//---------------------------------------------------------------------------

#include "IIRScram.hh"
#include "IIRScram_AttributeDeclaration.hh"
#include "IIR_TypeDefinition.hh"
#include "IIR_Attribute.hh"
#include "IIR_Identifier.hh"
#include "set.hh"

IIRScram_AttributeDeclaration::IIRScram_AttributeDeclaration(){
  _set_attribute( NULL );
}

IIRScram_AttributeDeclaration::~IIRScram_AttributeDeclaration(){
}


void 
IIRScram_AttributeDeclaration::_publish_vhdl_decl(ostream &_vhdl_out) {
  _vhdl_out << "attribute ";
  get_declarator()->_publish_vhdl(_vhdl_out);
  _vhdl_out << " : ";
  get_subtype()->_get_declarator()->_publish_vhdl(_vhdl_out);
  _vhdl_out << ";\n";
}

void 
IIRScram_AttributeDeclaration::_publish_vhdl(ostream &_vhdl_out) {
  get_declarator()->_publish_vhdl(_vhdl_out);
}

void 
IIRScram_AttributeDeclaration::_publish_vhdl_entity_class(ostream &_vhdl_out) {
  get_declarator()->_publish_vhdl(_vhdl_out);
}

IIR_Boolean 
IIRScram_AttributeDeclaration::_is_signal(){
  if( _get_attribute() != NULL ){
    return _get_attribute()->_is_signal();
  }
  else{
    // It must be user defined, and then it can't be signal valued..
    return FALSE;
  }
}


IIR_Attribute *
IIRScram_AttributeDeclaration::_get_attribute(){
  return one_attribute;
}

void
IIRScram_AttributeDeclaration::_set_attribute( IIR_Attribute *new_attr ){
  one_attribute = new_attr;
}


IIRScram_Declaration::declaration_type 
IIRScram_AttributeDeclaration::_get_type(){
   return ATTRIBUTE;
}

IIR_TypeDefinition *
IIRScram_AttributeDeclaration::get_subtype(){
  if( IIRBase_AttributeDeclaration::get_subtype() == NULL ){
    ASSERT( _get_attribute() != NULL );
    return _get_attribute()->get_subtype();
  }
  else{
    return IIRBase_AttributeDeclaration::get_subtype();
  }
}

IIR_Declaration*
IIRScram_AttributeDeclaration::_get_prefix_declaration(){
  return this;
}

void 
IIRScram_AttributeDeclaration::_publish_cc_lvalue( published_file & ){
  // Dummy method.
}

void 
IIRScram_AttributeDeclaration::_publish_cc_elaborate( published_file &_cc_out ){

  SCRAM_CC_REF( _cc_out, "IIRScram_AttributeDeclaration::_publish_cc_elaborate" );

  if(_is_implicit_declaration()) {
    _get_attribute()->_publish_cc_elaborate( _cc_out );
  }
  else {
    if(_get_attribute() != NULL) {
      _get_attribute()->_publish_cc_elaborate( _cc_out );     
    }
    else {
      // _cc_out << *get_declarator();
      _get_declarator()->_publish_cc_elaborate( _cc_out );
    }
  }
}

void 
IIRScram_AttributeDeclaration::_publish_cc_headers( published_file &_cc_out ) {

  SCRAM_CC_REF( _cc_out, "IIRScram_AttributeDeclaration::_publish_cc_headers" );

  get_subtype()->_publish_cc_headers( _cc_out );
}

void 
IIRScram_AttributeDeclaration::_add_decl_into_cgen_symbol_table() {
  // Dummy function
}

IIR_TypeDefinition *
IIRScram_AttributeDeclaration::_get_type_of_element( int element_number ){
  return get_subtype()->_get_type_of_element( element_number );
}

set<IIR_Declaration> *
IIRScram_AttributeDeclaration::_find_declarations( IIR_Name *to_find ){
  return get_subtype()->_find_declarations( to_find );
}

visitor_return_type *IIRScram_AttributeDeclaration::_accept_visitor(node_visitor *visitor, visitor_argument_type *arg) {
  ASSERT(visitor != NULL);
  return visitor->visit_IIR_AttributeDeclaration(this, arg);
};
