#ifndef IIRSCRAM_ARRAY_TYPE_DEFINITION_HH
#define IIRSCRAM_ARRAY_TYPE_DEFINITION_HH
// Copyright (c) 1996-2000 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Radharamanan Radhakrishnan  ramanan@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu
//          Swaminathan Subramanian ssubrama@ececs.uc.edu

//---------------------------------------------------------------------------
#include "IIRBase_ArrayTypeDefinition.hh"
#include "set.hh"

class IIR_ScalarTypeDefinition;
class IIR_ArraySubtypeDefinition;

/**
   The extension base for array type definitions.
 */
class IIRScram_ArrayTypeDefinition : public IIRBase_ArrayTypeDefinition {
  friend class StandardPackage;

public:

  /// Accept visitations \Ref{_accept_visitor}.
  visitor_return_type* _accept_visitor(node_visitor *, visitor_argument_type *);

  void _publish_vhdl_subtype_decl(ostream &);
  void _publish_vhdl_decl(ostream &);

  void _publish_vhdl(ostream &);
  virtual ostream &_print(ostream &);
  void _publish_cc_lvalue( published_file &_cc_out );
  void _publish_cc_left( published_file &_cc_out );
  void _publish_cc_composite_init( published_file &_cc_out );
  void _publish_cc_init_signal( published_file &_cc_out );
  void _publish_cc_range( published_file &_cc_out );
  void _publish_cc_universal_type( published_file &_cc_out );
  
  void _publish_cc_array_info( published_file &_cc_out );
  void _publish_cc_bounds( published_file &_cc_out );

  virtual void _publish_cc_constructor_prelude( published_file &_cc_out );
  virtual void _publish_cc_constructor_args( published_file &_cc_out );

  virtual void _publish_cc_range_args( published_file &_cc_out );
  virtual void _publish_cc_constructor_ranges( published_file &_cc_out );
  virtual void _publish_cc_necessary_decl_in_state( published_file &_cc_out );
  
  virtual void _publish_cc_headers( published_file &_cc_out );
  virtual const string _get_cc_kernel_type();

  virtual void _publish_cc_define_array_type_attributes( published_file &_cc_out );
  void _publish_cc_extern_type_info( published_file &_cc_out );
  void _publish_cc_constructor_args_type_info( published_file &_cc_out,
					       IIR *initializer );

  void _publish_cc_temporary_type_info( published_file &_cc_out, char * = NULL, char * = NULL);
  void _publish_cc_type_info( published_file &_cc_out, char*, char*);
  void _publish_cc_type_info( published_file &_cc_out );
  const string _get_cc_type_name();

  IIR_Boolean _is_array_type() { return TRUE; }
  
  /** _is_character_type() is TRUE for an Enumeration type, that has
      at least one character literal in its set of enumerations.  But
      scram/code-generator overloads this function for single dimensional
      array types whose element is a scalar type and is a character
      type. */
  IIR_Boolean _is_character_type();

  IIR_Boolean _is_iir_array_type_definition() { return TRUE; }
  IIR_Boolean _is_single_dimensional_array_type();

  virtual IIR_Boolean _is_unconstrained_array_type( );
  virtual IIR_Boolean _has_access_type();
  IIR_Boolean _is_discrete_type();
  IIR_Int32 _get_num_indexes();

  IIR_TypeDefinition *_get_element_subtype();
  void _set_element_subtype( IIR_TypeDefinition * );

  /** Due to the complexities of the IIR, sometimes
      _get_element_subtype() doesn't actually return the element
      subtype.  This is the case for multidimensional arrays, for
      instance.  _get_final_subtype() _will_ return the _real_ element
      subtype. */
  virtual IIR_TypeDefinition *_get_final_subtype();

  virtual IIR_ScalarTypeDefinition *_get_index_subtype();
  void _set_index_subtype( IIR_ScalarTypeDefinition * );

  set<IIR_Declaration> *_find_declarations( IIR_Name * );

  void _publish_cc_decl_operators( published_file &_cc_out );
  void _publish_cc_concatenation_operator( published_file &_cc_out );

  void _add_decl_into_cgen_symbol_table();

  /** This method takes the range passed in, applies the semantic rules
      given in LRM ('93) section 3.2.1.1, and returns the proper type. */
  static IIR_ScalarTypeDefinition *_build_proper_index( IIR_RangeTypeDefinition * );

  IIR_TypeDefinition *_index_constrain_array( IIR_ScalarTypeDefinition * );

  IIR_TypeDefinition *_get_new_subtype();

  IIR_TypeDefinition *
  _construct_new_subtype( IIR_Name *resolution_function,
			  IIR_ScalarTypeDefinition *new_constraint );  

  static IIR_ArrayTypeDefinition *_construct_array_type( IIR_ScalarTypeDefinition *index_subtype,
							 IIR_TypeDefinition *element_subtype,
							 IIR_TypeDeclaration *declaration );

  IIR *_clone();
  virtual void _clone( IIR *my_clone );

  IIR_Boolean _is_element(){ return is_element(); };

  virtual void _type_check();

protected:
  IIRScram_ArrayTypeDefinition();
  virtual ~IIRScram_ArrayTypeDefinition() = 0;
  
  virtual void _publish_cc_object_type( published_file &_cc_out,
					IIR_Boolean typeNameFlag = TRUE, 
					const char* suffix = NULL);

  //The following function returns TRUE if the element of the
  //array is a restriction of an unconstrained array
  IIR_Boolean _is_element_unconstrained_subtype();
  void _publish_cc_set_element_range_info( published_file &_cc_out );
  void  _publish_cc_restore_range_info( published_file &_cc_out );
  void _publish_cc_event_vector_instantiation( published_file &_cc_out );
  void _publish_cc_last_event_vector_instantiation( published_file &_cc_out );

  void _come_into_scope( symbol_table *sym_tab, IIR_TypeDeclaration * );
  void _come_out_of_scope( symbol_table *sym_tab );
  void _build_implicit_operators( set<IIR_Declaration> * );
  
  virtual void _set_resolution_function( IIR_FunctionDeclaration * );

private:  
  static IIR_ArraySubtypeDefinition *_construct_constrained(IIR_ScalarTypeDefinition *index_subtype,
							    IIR_TypeDefinition *element_subtype,
							    IIR_TypeDeclaration *declaration );

  static IIR_ArraySubtypeDefinition *_construct_unconstrained(IIR_ScalarTypeDefinition *index_subtype,
							      IIR_TypeDefinition *element_subtype,
							      IIR_TypeDeclaration *declaration );

  IIR_TypeDefinition* _get_element_type();
};
#endif
