// Copyright (c) 1996-2000 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcrbaye@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Radharamanan Radhakrishnan  ramanan@ece.uc.edu
//          Umesh Kumar V. Rajasekaran  urajasek@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//	    Magnus Danielson	cfmd@swipnet.se

//---------------------------------------------------------------------------

#include "IIRScram.hh"
#include "IIR_ActiveAttribute.hh"
#include "IIR_Identifier.hh"
#include "IIR_SignalDeclaration.hh"
#include "IIR_EnumerationSubtypeDefinition.hh"
#include "StandardPackage.hh"
#include "published_file.hh"

IIRScram_ActiveAttribute::~IIRScram_ActiveAttribute() {}

void 
IIRScram_ActiveAttribute::_publish_vhdl(ostream &_vhdl_out) {
  ASSERT(get_prefix() != NULL);
  get_prefix()->_publish_vhdl(_vhdl_out);
  _vhdl_out << "'ACTIVE ";
}


IIR_TextLiteral *
IIRScram_ActiveAttribute::_build_attribute_name() {
  char *name = "active";
  return IIR_Identifier::get( name, strlen(name) );
}

IIR_Boolean 
IIRScram_ActiveAttribute::_is_readable(){
  return get_prefix()->_is_readable();
}


// The active attribute is a boolean function valued attribute...
IIR_TypeDefinition *
IIRScram_ActiveAttribute::get_subtype(){
  return StandardPackage::get_boolean_type();
}

IIR_Declaration *
IIRScram_ActiveAttribute::_get_implicit_declaration( const string &decl_name,
						     IIR_TypeDefinition *decl_type ){
  return _build_signal_declaration( decl_name, decl_type );
}


void 
IIRScram_ActiveAttribute::_publish_cc_lvalue( published_file &_cc_out ) {

  SCRAM_CC_REF( _cc_out, "IIRScram_ActiveAttribute::_publish_cc" );

  _publish_cc_signal_attribute( _cc_out, "Active" );
}

void
IIRScram_ActiveAttribute::_publish_cc_necessary_decl_in_state( published_file &_cc_out ) {

  SCRAM_CC_REF( _cc_out, "IIRScram_ActiveAttribute::_publish_cc_necessary_decl_in_state" );

  _publish_cc_necessary_signal_decl_in_state( _cc_out, LAST_ACTIVE, "_last_active");
  _publish_cc_necessary_signal_decl_in_state( _cc_out, ACTIVE, "_active" );
}

// Initialization value of the signal, in UserState::initstate()
void
IIRScram_ActiveAttribute::_publish_cc_init_val( published_file &_cc_out ) { 
  _cc_out << "true";
}

void
IIRScram_ActiveAttribute::_publish_cc_name_in_caps( published_file &_cc_out ) {
  _cc_out << "ACTIVE";
}

void
IIRScram_ActiveAttribute::_publish_cc_attrib_type( published_file &_cc_out ) {
  _cc_out << "function";
}


void
IIRScram_ActiveAttribute::_publish_cc_necessary_decl_init( published_file &_cc_out ) {

  SCRAM_CC_REF( _cc_out, "IIRScram_ActiveAttribute::_publish_cc_necessary_decl_init" );

  ASSERT( get_prefix() != NULL );
  ASSERT(get_prefix()->_is_resolved() == TRUE );
  ASSERT(get_prefix()->_is_signal() == TRUE );

  _publish_cc_necessary_signal_init( _cc_out, LAST_ACTIVE, "_last_active" );
}


void
IIRScram_ActiveAttribute::_publish_cc_elaborate( published_file &_cc_out ){

  SCRAM_CC_REF( _cc_out, "IIRScram_ActiveAttribute::_publish_cc_elaborate" );

  ASSERT( get_prefix() != NULL );
  ASSERT(get_prefix()->_is_resolved() == TRUE );
  ASSERT(get_prefix()->_is_signal() == TRUE );
  get_prefix()->_publish_cc_elaborate( _cc_out );
  _cc_out << "_active";
}


void
IIRScram_ActiveAttribute::_publish_cc_sigtype( published_file &_cc_out ) {
  _cc_out << " I_ACTIVE;\n";
}


void
IIRScram_ActiveAttribute::_publish_cc_state_object_init( published_file &_cc_out ) {

  SCRAM_CC_REF( _cc_out, "IIRScram_ActiveAttribute::_publish_cc_state_object_init" );

  _publish_cc_necessary_signal_state_object_init( _cc_out, LAST_ACTIVE, "_last_active" );
  _publish_cc_necessary_signal_state_object_init( _cc_out, ACTIVE, "_active", TRUE );
}

void
IIRScram_ActiveAttribute::_publish_cc_init( published_file &_cc_out ) {

  SCRAM_CC_REF( _cc_out, "IIRScram_ActiveAttribute::_publish_cc_init" );

  _publish_cc_necessary_signal_init( _cc_out, LAST_ACTIVE, "_last_active" );
  _publish_cc_necessary_signal_init( _cc_out, ACTIVE, "_active", TRUE );
}

void
IIRScram_ActiveAttribute::_publish_cc_necessary_copying( published_file &_cc_out ) {

  SCRAM_CC_REF( _cc_out, "IIRScram_ActiveAttribute::_publish_cc_necessary_copying" );

  _publish_cc_necessary_attribute_copying( _cc_out, LAST_ACTIVE, "_last_active");
  _publish_cc_necessary_attribute_copying( _cc_out, ACTIVE, "_active");
}

void
IIRScram_ActiveAttribute::_publish_cc_read_or_write( published_file &_cc_out,
						     const string &functionName, 
						     const string &streamName) {
  SCRAM_CC_REF( _cc_out, "IIRScram_ActiveAttribute::_publish_cc_read_or_write" );

  _publish_cc_attribute_read_or_write(_cc_out, 
				      LAST_ACTIVE, 
				      "_last_active", 
				      functionName, 
				      streamName);

  _publish_cc_attribute_read_or_write( _cc_out, 
				       ACTIVE, 
				       "_active", 
				       functionName, 
				       streamName);
}


IIR*
IIRScram_ActiveAttribute::_clone() {
  IIR_ActiveAttribute *my_clone = new IIR_ActiveAttribute;
  IIR_Attribute::_clone(my_clone);
  return my_clone;
}

visitor_return_type *IIRScram_ActiveAttribute::_accept_visitor(node_visitor *visitor, visitor_argument_type *arg) {
  ASSERT(visitor != NULL);
  return visitor->visit_IIR_ActiveAttribute(this, arg);
};
