
#ifndef IIRBASE_TYPE_DEFINITION_HH
#define IIRBASE_TYPE_DEFINITION_HH

// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu

//---------------------------------------------------------------------------

#include "IIR.hh"

class IIR_TypeDefinition;
class IIR_Declaration;

class IIRBase_TypeDefinition : public IIR {

public:
  void set_base_type(IIR_TypeDefinition *);
  IIR_TypeDefinition *get_base_type();

  // These are added here, because we think they'll become part of the
  // standard.  "_get_declaration()" was promised many moons ago.
  IIR_Declaration *_get_declaration();
  void _set_declaration( IIR_Declaration *);

  IIR_TypeDefinition *_get_type_mark();
  void _set_type_mark( IIR_TypeDefinition * );

protected:
  
  IIRBase_TypeDefinition();
  virtual ~IIRBase_TypeDefinition() = 0;
    
private:
  IIR_TypeDefinition *my_base_type;
  IIR_Declaration *_my_declaration;
  IIR_TypeDefinition *_my_type_mark;
};

#endif
