
#ifndef IIR_KIND_HH
#define IIR_KIND_HH

// Copyright (c) 1996-2003 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	philip.wilsey@ieee.org
//          Dale E. Martin	dmartin@cliftonlabs.com

#include <cassert>
#include <cstdlib>

#include <iostream>
using std::ostream;

class published_file;

enum IIR_Kind {
  IIR_ABOVE_ATTRIBUTE,
  IIR_ABSOLUTE_OPERATOR,
  IIR_ACCESS_SUBTYPE_DEFINITION,
  IIR_ACCESS_TYPE_DEFINITION,
  IIR_ACROSS_ATTRIBUTE,
  IIR_ACTIVE_ATTRIBUTE,
  IIR_ADDITION_OPERATOR,
  IIR_AGGREGATE,
  IIR_ALIAS_DECLARATION,
  IIR_ALLOCATOR,
  IIR_AND_OPERATOR,
  IIR_ARCHITECTURE_DECLARATION,
  IIR_ARCHITECTURE_STATEMENT_LIST,
  IIR_ARRAY_NATURE_DEFINITION,
  IIR_ARRAY_SUBNATURE_DEFINITION,
  IIR_ARRAY_SUBTYPE_DEFINITION,
  IIR_ARRAY_TYPE_DEFINITION,
  IIR_ASCENDING_ATTRIBUTE,
  IIR_ASSERTION_STATEMENT,
  IIR_ASSOCIATION_ELEMENT_BY_EXPRESSION,
  IIR_ASSOCIATION_ELEMENT_BY_OPEN,
  IIR_ASSOCIATION_LIST,
  IIR_ATTRIBUTE_DECLARATION,
  IIR_ATTRIBUTE_SPECIFICATION,
  IIR_ATTRIBUTE_SPECIFICATION_LIST,
  IIR_BASE_ATTRIBUTE,
  IIR_BIT_STRING_LITERAL,
  IIR_BLOCK_CONFIGURATION,
  IIR_BLOCK_STATEMENT,
  IIR_BRANCH_QUANTITY_DECLARATION,
  IIR_BREAK_ELEMENT,
  IIR_BREAK_LIST,
  IIR_BREAK_STATEMENT,
  IIR_CASE_STATEMENT,
  IIR_CASE_STATEMENT_ALTERNATIVE_BY_CHOICES,
  IIR_CASE_STATEMENT_ALTERNATIVE_BY_EXPRESSION,
  IIR_CASE_STATEMENT_ALTERNATIVE_BY_OTHERS,
  IIR_CASE_STATEMENT_ALTERNATIVE_LIST,
  IIR_CHARACTER_LITERAL,
  IIR_CHOICE,
  IIR_CHOICE_LIST,
  IIR_COMMENT,
  IIR_COMMENT_LIST,
  IIR_COMPONENT_CONFIGURATION,
  IIR_COMPONENT_DECLARATION,
  IIR_COMPONENT_INSTANTIATION_STATEMENT,
  IIR_CONCATENATION_OPERATOR,
  IIR_CONCURRENT_ASSERTION_STATEMENT,
  IIR_CONCURRENT_BREAK_STATEMENT,
  IIR_CONCURRENT_CONDITIONAL_SIGNAL_ASSIGNMENT,
  IIR_CONCURRENT_GENERATE_FOR_STATEMENT,
  IIR_CONCURRENT_GENERATE_IF_STATEMENT,
  IIR_CONCURRENT_PROCEDURE_CALL_STATEMENT,
  IIR_CONCURRENT_SELECTED_SIGNAL_ASSIGNMENT,
  IIR_CONDITIONAL_WAVEFORM,
  IIR_CONDITIONAL_WAVEFORM_LIST,
  IIR_CONFIGURATION_DECLARATION,
  IIR_CONFIGURATION_ITEM,
  IIR_CONFIGURATION_ITEM_LIST,
  IIR_CONFIGURATION_SPECIFICATION,
  IIR_CONSTANT_DECLARATION,
  IIR_CONSTANT_INTERFACE_DECLARATION,
  IIR_CONTRIBUTION_ATTRIBUTE,
  IIR_DECLARATION_LIST,
  IIR_DELAYED_ATTRIBUTE,
  IIR_DESIGN_FILE,
  IIR_DESIGN_FILE_LIST,
  IIR_DESIGN_UNIT_LIST,
  IIR_DESIGNATOR_BY_ALL,
  IIR_DESIGNATOR_BY_OTHERS,
  IIR_DESIGNATOR_EXPLICIT,
  IIR_DESIGNATOR_LIST,
  IIR_DIVISION_OPERATOR,
  IIR_DISCONNECT_SPECIFICATION,
  IIR_DOT_ATTRIBUTE,
  IIR_DRIVING_ATTRIBUTE,
  IIR_DRIVING_VALUE_ATTRIBUTE,
  IIR_DYADIC_OPERATOR,
  IIR_ELEMENT_DECLARATION,
  IIR_ELEMENT_DECLARATION_LIST,
  IIR_ELSIF,
  IIR_ENTITY_CLASS_ENTRY,
  IIR_ENTITY_CLASS_ENTRY_LIST,
  IIR_ENTITY_DECLARATION,
  IIR_ENTITY_NAME_LIST,
  IIR_ENUMERATION_LITERAL,
  IIR_ENUMERATION_LITERAL_LIST,
  IIR_ENUMERATION_SUBTYPE_DEFINITION,
  IIR_ENUMERATION_TYPE_DEFINITION,
  IIR_EQUALITY_OPERATOR,
  IIR_EVENT_ATTRIBUTE,
  IIR_EXIT_STATEMENT,
  IIR_EXPONENTIATION_OPERATOR,
  IIR_FILE_DECLARATION,
  IIR_FILE_INTERFACE_DECLARATION,
  IIR_FILE_TYPE_DEFINITION,
  IIR_FLOATING_POINT_LITERAL,
  IIR_FLOATING_POINT_LITERAL32,
  IIR_FLOATING_POINT_LITERAL64,
  IIR_FLOATING_SUBTYPE_DEFINITION,
  IIR_FLOATING_TYPE_DEFINITION,
  IIR_FOR_LOOP_STATEMENT,
  IIR_FREE_QUANTITY_DECLARATION,
  IIR_FUNCTION_CALL,
  IIR_FUNCTION_DECLARATION,
  IIR_GENERIC_LIST,
  IIR_GREATER_THAN_OPERATOR,
  IIR_GREATER_THAN_OR_EQUAL_OPERATOR,
  IIR_GROUP_CONSTITUENT,
  IIR_GROUP_DECLARATION,
  IIR_GROUP_TEMPLATE_DECLARATION,
  IIR_HIGH_ATTRIBUTE,
  IIR_IDENTIFIER,
  IIR_IDENTIFIER_LIST,
  IIR_IDENTITY_OPERATOR,
  IIR_IF_STATEMENT,
  IIR_IMAGE_ATTRIBUTE,
  IIR_INDEXED_NAME,
  IIR_INEQUALITY_OPERATOR,
  IIR_INSTANCE_NAME_ATTRIBUTE,
  IIR_INTEGER_LITERAL,
  IIR_INTEGER_LITERAL32,
  IIR_INTEGER_LITERAL64,
  IIR_INTEGER_SUBTYPE_DEFINITION,
  IIR_INTEGER_TYPE_DEFINITION,
  IIR_INTERFACE_LIST,
  IIR_LABEL,
  IIR_LAST_ACTIVE_ATTRIBUTE,
  IIR_LAST_EVENT_ATTRIBUTE,
  IIR_LAST_VALUE_ATTRIBUTE,
  IIR_LEFT_ATTRIBUTE,
  IIR_LEFT_OF_ATTRIBUTE,
  IIR_LENGTH_ATTRIBUTE,
  IIR_LESS_THAN_OPERATOR,
  IIR_LESS_THAN_OR_EQUAL_OPERATOR,
  IIR_LIBRARY_CLAUSE,
  IIR_LIBRARY_DECLARATION,
  IIR_LIBRARY_UNIT_LIST,
  IIR_LITERAL,
  IIR_LOW_ATTRIBUTE,
  IIR_LTF_ATTRIBUTE,
  IIR_MODULUS_OPERATOR,
  IIR_MULTIPLICATION_OPERATOR,
  IIR_NAME,
  IIR_NAME_LIST,
  IIR_NAND_OPERATOR,
  IIR_NATURE_DECLARATION,
  IIR_NATURE_DEFINITION,
  IIR_NEGATION_OPERATOR,
  IIR_NEXT_STATEMENT,
  IIR_NOR_OPERATOR,
  IIR_NOT_OPERATOR,
  IIR_NULL_STATEMENT,
  IIR_OR_OPERATOR,
  IIR_OTHERS_INITIALIZATION,
  IIR_PACKAGE_BODY_DECLARATION,
  IIR_PACKAGE_DECLARATION,
  IIR_PATH_NAME_ATTRIBUTE,
  IIR_PHYSICAL_LITERAL,
  IIR_PHYSICAL_SUBTYPE_DEFINITION,
  IIR_PHYSICAL_TYPE_DEFINITION,
  IIR_PHYSICAL_UNIT,
  IIR_PORT_LIST,
  IIR_POS_ATTRIBUTE,
  IIR_PRED_ATTRIBUTE,
  IIR_PROCEDURE_CALL_STATEMENT,
  IIR_PROCEDURE_DECLARATION,
  IIR_PROCESS_STATEMENT,
  IIR_QUALIFIED_EXPRESSION,
  IIR_QUANTITY_DECLARATION,
  IIR_QUIET_ATTRIBUTE,
  IIR_ROL_OPERATOR,
  IIR_ROR_OPERATOR,
  IIR_RANGE_ATTRIBUTE,
  IIR_RANGE_TYPE_DEFINITION,
  IIR_RECORD_TYPE_DEFINITION,
  IIR_REFERENCE_ATTRIBUTE,
  IIR_REMAINDER_OPERATOR,
  IIR_REPORT_STATEMENT,
  IIR_RETURN_STATEMENT,
  IIR_REVERSE_RANGE_ATTRIBUTE,
  IIR_RIGHT_ATTRIBUTE,
  IIR_RIGHT_OF_ATTRIBUTE,
  IIR_SCALAR_NATURE_DEFINITION,
  IIR_SLA_OPERATOR,
  IIR_SLL_OPERATOR,
  IIR_SRA_OPERATOR,
  IIR_SRL_OPERATOR,
  IIR_SELECTED_NAME,
  IIR_SELECTED_NAME_BY_ALL,
  IIR_SELECTED_WAVEFORM,
  IIR_SELECTED_WAVEFORM_LIST,
  IIR_SENSITIZED_PROCESS_STATEMENT,
  IIR_SEQUENTIAL_STATEMENT_LIST,
  IIR_SHARED_VARIABLE_DECLARATION,
  IIR_SIGNAL_ASSIGNMENT_STATEMENT,
  IIR_SIGNAL_DECLARATION,
  IIR_SIGNAL_INTERFACE_DECLARATION,
  IIR_SIGNATURE,
  IIR_SIMPLE_NAME,
  IIR_SIMPLE_NAME_ATTRIBUTE,
  IIR_SIMPLE_SIMULTANEOUS_STATEMENT,
  IIR_SIMULTANEOUS_IF_STATEMENT,
  IIR_SIMULTANEOUS_ELSIF,
  IIR_SIMULTANEOUS_STATEMENT,
  IIR_SLICE_NAME,
  IIR_SOURCE_QUANTITY_DECLARATION,
  IIR_STABLE_ATTRIBUTE,
  IIR_STRING_LITERAL,
  IIR_SUBPROGRAM_DECLARATION,
  IIR_SUBTRACTION_OPERATOR,
  IIR_SUBTYPE_DECLARATION,
  IIR_SUCC_ATTRIBUTE,
  IIR_TERMINAL_DECLARATION,
  IIR_TERMINAL_INTERFACE_DECLARATION,
  IIR_THROUGH_ATTRIBUTE,
  IIR_TRANSACTION_ATTRIBUTE,
  IIR_TUPLE,
  IIR_TYPE_CONVERSION,
  IIR_TYPE_DECLARATION,
  IIR_UNIT_LIST,
  IIR_USE_CLAUSE,
  IIR_USER_ATTRIBUTE,
  IIR_VAL_ATTRIBUTE,
  IIR_VALUE_ATTRIBUTE,
  IIR_VARIABLE_ASSIGNMENT_STATEMENT,
  IIR_VARIABLE_DECLARATION,
  IIR_VARIABLE_INTERFACE_DECLARATION,
  IIR_WAIT_STATEMENT,
  IIR_WAVEFORM_ELEMENT,
  IIR_WAVEFORM_LIST,
  IIR_WHILE_LOOP_STATEMENT,
  IIR_XNOR_OPERATOR,
  IIR_XOR_OPERATOR,
  IIR_ZTF_ATTRIBUTE,
  _IIR_STRING,
  _IIR_ERROR
};

ostream&
operator <<(ostream &, const IIR_Kind);

published_file &
operator <<( published_file &, const IIR_Kind );

#endif
