/*
 * AUTHOR: Pedro Lineu Orso                         pedro.orso@gmail.com
 *                                                            1998, 2009
 * SARG Squid Analysis Report Generator      http://sarg.sourceforge.net
 *
 * SARG donations:
 *      please look at http://sarg.sourceforge.net/donations.php
 * ---------------------------------------------------------------------
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 */

#include "include/conf.h"
#include "include/defs.h"

void language_load(const char *language)
{
   char lfile[FILENAME_MAX];
   FILE *fp_text;
   char buf[MAXLEN];
   int record=0;

   if (snprintf(lfile,sizeof(lfile),LANGDIR"/%s",language)>=sizeof(lfile)) {
      fprintf(stderr, "SARG: (language) language name is too long: %s/%s\n",LANGDIR,language);
      exit(1);
   }

   if((fp_text=fopen(lfile,"r"))==NULL) {
     fprintf(stderr, "SARG: (language) Cannot open language file: %s\n",lfile);
     exit(1);
   }
   if(langcode)
      printf("Reading language from %s\n",lfile);

   while(record<sizeof(text)/sizeof(text[0]) && fgets(buf,sizeof(buf),fp_text)!=NULL) {
      if (getword(warea,sizeof(warea),buf,'"')<0 || getword(warea,sizeof(warea),buf,'"')<0) {
         printf("SARG: Maybe you have a broken record or garbage in your %s file.\n",lfile);
         exit(1);
      }
      strcpy(text[record],warea);

      if(langcode)
         printf("%d %s\n",record,warea);

      record++;
   }

   fclose(fp_text);

   if(langcode) {
      /*
      The listing of the language strings is only used when adding new string so there is
      no need to let sarg run any further than this point.
      */
      exit(0);
   }

   return;
}
