/*
 * sarg - Squid user management log
 * Mar/98 - Pedro L Orso - orso@brturbo.com
 */

#include "include/conf.h"

extern numlist hours, weekdays;

char wbuf[MAXLEN];
char Msg[255];

void getconf(debugm, ConfigFile, AccessLog, debug, BgColor, TxColor, TxBgColor, TiColor, LogoImage, LogoText, LogoTextColor, Width, Height, Title, BgImage, FontFace, HeaderColor, HeaderBgColor, FontSize, PasswdFile, TempDir, OutputDir, OutputEmail, Ip2Name, TopuserSortField, UserSortField, TopuserSortOrder, UserSortOrder, UserAgentLog, ExcludeHosts, DateFormat, ExcludeUsers, PerUserLimitFile, PerUserLimit, UserIp, MaxElapsed)
   int debug;
   int  debugm;
   char *ConfigFile;
   char *AccessLog;
   char *BgColor;
   char *TxColor;
   char *TxBgColor;
   char *TiColor;
   char *LogoImage;
   char *LogoText;
   char *LogoTextColor;
   char *Width;
   char *Height;
   char *Title;
   char *BgImage;
   char *FontFace;
   char *HeaderColor;
   char *HeaderBgColor;
   char *FontSize;
   char *PasswdFile;
   char *TempDir;
   char *OutputDir;
   char *OutputEmail;
   char *Ip2Name;
   char *TopuserSortField;
   char *UserSortField;
   char *TopuserSortOrder;
   char *UserSortOrder;
   char *UserAgentLog;
   char *ExcludeHosts;
   char *ExcludeUsers;
   char *DateFormat;
   char *PerUserLimitFile;
   char *PerUserLimit;
   char *UserIp;
   char *MaxElapsed;
{

   FILE *fp_in;
   char buf[MAXLEN];

   if(debug) {
      sprintf(Msg,"Loading configuration from: %s",ConfigFile);
      debuga(Msg);
   }

   if ((fp_in = fopen(ConfigFile, "r")) == NULL) {
      fprintf(stderr, "SARG: (getconf) Cannot open file: %s\n",ConfigFile);
      exit(1);
   }

   while (fgets(buf, MAXLEN, fp_in) != NULL) {
      if(strstr(buf,"\n") != 0)
         buf[strlen(buf)-1]='\n';

      if(debugm)
         printf("SYSCONFDIR %s",buf);

      if(strncmp(buf,"#",1) == 0)
         continue;

      parmtest(buf);

   }

   fclose(fp_in);
   language_load(language);
   return;
}


int parmtest(char *buf)
{

      if(strstr(buf,"background_color") != 0) {
         getword(wbuf,buf,' ');
         strcpy(BgColor,buf);
         fixnone(BgColor);
         return;
      }

      if(strstr(buf,"text_color") != 0) {
         if(strstr(buf,"logo_text_color") == 0) {
            getword(wbuf,buf,' ');
            strcpy(TxColor,buf);
            fixnone(TxColor);
            return;
         }
      }

      if(strstr(buf,"text_bgcolor") != 0) {
         getword(wbuf,buf,' ');
         strcpy(TxBgColor,buf);
         fixnone(TxBgColor);
         return;
      }

      if(strstr(buf,"title_color") != 0) {
         getword(wbuf,buf,' ');
         strcpy(TiColor,buf);
         fixnone(TiColor);
         return;
      }

      if(strstr(buf,"logo_image") != 0) {
         getword(wbuf,buf,' ');
         strcpy(LogoImage,buf);
         fixnone(LogoImage);
         return;
      }

      if(strstr(buf,"logo_text") != 0) {
         if(strstr(buf,"logo_text_color") == 0) {
            getword(wbuf,buf,'"');
            getword(LogoText,buf,'"');
            fixnone(LogoText);
            return;
         }
      }

      if(strstr(buf,"logo_text_color") != 0) {
         getword(wbuf,buf,' ');
         strcpy(LogoTextColor,buf);
         fixnone(LogoTextColor);
         return;
      }

      if(strstr(buf,"background_image") != 0) {
         getword(wbuf,buf,' ');
         strcpy(BgImage,buf);
         fixnone(BgImage);
         return;
      }

      if(strstr(buf,"show_sarg_info") != 0) {
         getword(wbuf,buf,' ');
         strcpy(ShowSargInfo,buf);
         fixnone(ShowSargInfo);
         return;
      }

      if(strstr(buf,"font_face") != 0) {
         getword(wbuf,buf,' ');
         strcpy(FontFace,buf);
         fixnone(FontFace);
         return;
      }

      if(strstr(buf,"header_color") != 0) {
         getword(wbuf,buf,' ');
         strcpy(HeaderColor,buf);
         fixnone(HeaderColor);
         return;
      }

      if(strstr(buf,"header_bgcolor") != 0) {
         getword(wbuf,buf,' ');
         strcpy(HeaderBgColor,buf);
         fixnone(HeaderBgColor);
         return;
      }

      if(strstr(buf,"font_size") != 0) {
         getword(wbuf,buf,' ');
         strcpy(FontSize,buf);
         fixnone(FontSize);
         return;
      }

      if(strstr(buf,"image_size") != 0) {
         getword(wbuf,buf,' ');
         getword(Width,buf,' ');
         strcpy(Height,buf);
         fixnone(Width);
         fixnone(Height);
         return;
      }

      if(strstr(buf,"title") != 0) {
         getword(wbuf,buf,'"');
         getword(Title,buf,'"');
         fixnone(Title);
         return;
      }

      if(strstr(buf,"resolve_ip") != 0) {
         getword(wbuf,buf,' ');
         strcpy(Ip2Name,buf);
         fixnone(Ip2Name);
         return;
      }

      if(strstr(buf,"user_ip") != 0) {
         getword(wbuf,buf,' ');
         strcpy(UserIp,buf);
         fixnone(UserIp);
         return;
      }

      if(strstr(buf,"max_elapsed") != 0) {
         getword(wbuf,buf,' ');
         strcpy(MaxElapsed,buf);
         fixnone(MaxElapsed);
         return;
      }

      if(strstr(buf,"date_format") != 0) {
         getword(wbuf,buf,' ');
         strcpy(DateFormat,buf);
         fixnone(DateFormat);
         return;
      }

      if( strstr( buf, "hours" ) != 0 ) {
         if( getnumlist( buf, &hours, 24, 24 ) ) {
            fprintf( stderr, "Error: Invalid syntax in hours tag!\n" );
            exit( 1 );
         }
       }

      if( strstr( buf, "weekdays" ) != 0 ) {
         if( getnumlist( buf, &weekdays, 7, 7 ) ) {
            fprintf( stderr, "Error: Invalid syntax in weekdays tag!\n" );
            exit( 1 );
         }
      }

      if(strstr(buf,"topuser_sort_field") != 0) {
         getword(wbuf,buf,' ');
         getword(TopuserSortField,buf,' ');
         strcpy(TopuserSortOrder,buf);
         fixnone(TopuserSortOrder);
         return;
      }

      if(strstr(buf,"user_sort_field") != 0) {
         getword(wbuf,buf,' ');
         getword(UserSortField,buf,' ');
         strcpy(UserSortOrder,buf);
         fixnone(UserSortOrder);
         return;
      }

      if(strstr(buf,"access_log") != 0) {
         getword(wbuf,buf,' ');
         strcpy(AccessLog,buf);
         fixnone(AccessLog);
         return;
      }

      if(strstr(buf,"useragent_log") != 0) {
         getword(wbuf,buf,' ');
         strcpy(UserAgentLog,buf);
         fixnone(UserAgentLog);
         return;
      }

      if(strstr(buf,"exclude_hosts") != 0) {
         getword(wbuf,buf,' ');
         strcpy(ExcludeHosts,buf);
         fixnone(ExcludeHosts);
         return;
      }

      if(strstr(buf,"exclude_codes") != 0) {
         getword(wbuf,buf,' ');
         strcpy(ExcludeCodes,buf);
         fixnone(ExcludeCodes);
         return;
      }

      if(strstr(buf,"exclude_users") != 0) {
         getword(wbuf,buf,' ');
         strcpy(ExcludeUsers,buf);
         fixnone(ExcludeUsers);
         return;
      }

      if(strstr(buf,"password") != 0) {
         getword(wbuf,buf,' ');
         strcpy(PasswdFile,buf);
         fixnone(PasswdFile);
         return;
      }

      if(strstr(buf,"temporary_dir") != 0) {
         getword(wbuf,buf,' ');
         strcpy(TempDir,buf);
         fixnone(TempDir);
         return;
      }

      if(strstr(buf,"report_type") != 0) {
         getword(wbuf,buf,' ');
         strcpy(ReportType,buf);
         fixnone(ReportType);
         return;
      }

      if(strstr(buf,"output_dir") != 0) {
         if(strstr(buf,"output_dir_form") == 0) {
            getword(wbuf,buf,' ');
            strcpy(OutputDir,buf);
            fixnone(OutputDir);
            return;
         }
      }

      if(strstr(buf,"output_email") != 0) {
         getword(wbuf,buf,' ');
         strcpy(OutputEmail,buf);
         fixnone(OutputEmail);
         return;
      }

      if(strstr(buf,"per_user_limit") != 0) {
         getword(wbuf,buf,' ');
         getword(PerUserLimitFile,buf,' ');
         strcpy(PerUserLimit,buf);
         fixnone(PerUserLimitFile);
         fixnone(PerUserLimit);
         return;
      }


      if(strstr(buf,"lastlog") != 0) {
         getword(wbuf,buf,' ');
         strcpy(LastLog,buf);
         fixnone(LastLog);
         return;
      }

      if(strstr(buf,"remove_temp_files") != 0) {
         getword(wbuf,buf,' ');
         strcpy(RemoveTempFiles,buf);
         fixnone(RemoveTempFiles);
         return;
      }

      if(strstr(buf,"replace_index") != 0) {
         getword(wbuf,buf,' ');
         strcpy(ReplaceIndex,buf);
         fixnone(ReplaceIndex);
         return;
      }      

      if(strstr(buf,"index") != 0) {
         if(strstr(buf,"index_sort_order") == 0) {
            getword(wbuf,buf,' ');
            strcpy(Index,buf);
            fixnone(Index);
            return;
         }
      }

      if(strstr(buf,"overwrite_report") != 0) {
         getword(wbuf,buf,' ');
         strcpy(OverwriteReport,buf);
         fixnone(OverwriteReport);
         return;
      }

      if(strstr(buf,"records_without_userid") != 0) {
         getword(wbuf,buf,' ');
         strcpy(RecordsWithoutUser,buf);
         fixnone(RecordsWithoutUser);
         return;
      }

      if(strstr(buf,"use_comma") != 0) {
         getword(wbuf,buf,' ');
         strcpy(UseComma,buf);
         fixnone(UseComma);
         return;
      }

      if(strstr(buf,"mail_utility") != 0) {
         getword(wbuf,buf,' ');
         strcpy(MailUtility,buf);
         fixnone(MailUtility);
         return;
      }

      if(strstr(buf,"topsites_num") != 0) {
         getword(wbuf,buf,' ');
         strcpy(TopSitesNum,buf);
         fixnone(TopSitesNum);
         return;
      }

      if(strstr(buf,"topuser_num") != 0) {
         getword(wbuf,buf,' ');
         strcpy(TopUsersNum,buf);
         fixnone(TopUsersNum);
         return;
      }

      if(strstr(buf,"usertab") != 0) {
         getword(wbuf,buf,' ');
         strcpy(UserTabFile,buf);
         fixnone(UserTabFile);
         return;
      }

      if(strstr(buf,"index_sort_order") != 0) {
         getword(wbuf,buf,' ');
         strcpy(IndexSortOrder,buf);
         fixnone(IndexSortOrder);
         return;
      }

      if(strstr(buf,"topsites_sort_order") != 0) {
         getword(wbuf,buf,' ');
         getword(TopsitesSortField,buf,' ');
         strcpy(TopsitesSortType,buf);
         fixnone(TopsitesSortField);
         fixnone(TopsitesSortType);
         return;
      }

      if(strstr(buf,"long_url") != 0) {
         getword(wbuf,buf,' ');
         strcpy(LongUrl,buf);
         fixnone(LongUrl);
         return;
      }

      if(strstr(buf,"language") != 0) {
         getword(wbuf,buf,' ');
         strcpy(language,buf);
         fixnone(language);
         return;
      }

      if(strstr(buf,"squidguard_log") != 0) {
         getword(wbuf,buf,' ');
         strcpy(SquidGuardLogPath,buf);
         fixnone(SquidGuardLogPath);
         return;
      }

      if(strstr(buf,"date_time_by") != 0) {
         getword(wbuf,buf,' ');
         strcpy(datetimeby,buf);
         fixnone(datetimeby);
         return;
      }

      if(strstr(buf,"charset") != 0) {
         getword(wbuf,buf,' ');
         strcpy(CharSet,buf);
         fixnone(CharSet);
         ccharset(CharSet);
         return;
      }

      if(strstr(buf,"user_invalid_char") != 0) {
         getword(wbuf,buf,'"');
         getword(UserInvalidChar,buf,'"');
         fixnone(UserInvalidChar);
         return;
      }

      if(strstr(buf,"include_users") != 0) {
         getword(wbuf,buf,'"');
         getword(wbuf,buf,'"');
	 sprintf(IncludeUsers,":%s:",wbuf);
         fixnone(IncludeUsers);
         return;
      }

      if(strstr(buf,"exclude_string") != 0) {
         getword(wbuf,buf,'"');
         getword(ExcludeString,buf,'"');
         fixnone(ExcludeString);
         return;
      }

      if(strstr(buf,"privacy") != 0) {
         if(strstr(buf,"privacy_string") == 0 && \
	    strstr(buf,"privacy_string_color") == 0) {
            getword(wbuf,buf,' ');
            strcpy(Privacy,buf);
            fixnone(Privacy);
            return;
	 }
      }

      if(strstr(buf,"privacy_string") != 0) {
	 if(strstr(buf,"privacy_string_color") == 0) {
            getword(wbuf,buf,'"');
            getword(PrivacyString,buf,'"');
            fixnone(PrivacyString);
            return;
	 }
      }

      if(strstr(buf,"privacy_string_color") != 0) {
         getword(wbuf,buf,' ');
         strcpy(PrivacyStringColor,buf);
         fixnone(PrivacyStringColor);
         return;
      }

      if(strstr(buf,"show_successful_message") != 0) {
         getword(wbuf,buf,' ');
         strcpy(SuccessfulMsg,buf);
         fixnone(SuccessfulMsg);
         return;
      }

      if(strstr(buf,"show_read_statistics") != 0) {
         getword(wbuf,buf,' ');
         strcpy(ShowReadStatistics,buf);
         fixnone(ShowReadStatistics);
         return;
      }

      if(strstr(buf,"topuser_fields") != 0) {
         getword(wbuf,buf,' ');
         strcpy(TopUserFields,buf);
         fixnone(TopUserFields);
         return;
      }

      if(strstr(buf,"user_report_fields") != 0) {
         getword(wbuf,buf,' ');
         strcpy(UserReportFields,buf);
         fixnone(UserReportFields);
         return;
      }

      if(strstr(buf,"site_user_time_date_type") != 0) {
         getword(wbuf,buf,' ');
         strcpy(SiteUserTimeDateType,buf);
         fixnone(SiteUserTimeDateType);
         return;
      }

      if(strstr(buf,"datafile ") != 0) {
         getword(wbuf,buf,' ');
         strcpy(DataFile,buf);
         fixnone(DataFile);
         return;
      }

      if(strstr(buf,"datafile_delimiter") != 0) {
         getword(wbuf,buf,' ');
         getword(wbuf,buf,'"');
         getword(DataFileDelimiter,buf,'"');
         fixnone(DataFileDelimiter);
         return;
      }

      if(strstr(buf,"datafile_fields") != 0) {
         getword(wbuf,buf,' ');
         strcpy(DataFileFields,buf);
         fixnone(DataFileFields);
         return;
      }

      if(strstr(buf,"parsed_output_log") != 0) {
	 if(strstr(buf,"parsed_output_log_compress") == 0) {
            getword(wbuf,buf,' ');
            strcpy(ParsedOutputLog,buf);
            fixnone(ParsedOutputLog);
            return;
         }
      }

      if(strstr(buf,"parsed_output_log_compress") != 0) {
         getword(wbuf,buf,' ');
         strcpy(ParsedOutputLogCompress,buf);
         fixnone(ParsedOutputLogCompress);
         return;
      }

      if(strstr(buf,"displayed_values") != 0) {
         getword(wbuf,buf,' ');
         strcpy(DisplayedValues,buf);
         fixnone(DisplayedValues);
         return;
      }
    
      return;
}
