from __future__ import print_function
from _mock import _Mock

ultratb = __import__('IPython.core.ultratb', fromlist=['ultratb'])


crash_handler_lite = _Mock()

os = _Mock()

pformat = _Mock()

print_function = _Mock()

sys = _Mock()

sys_info = _Mock()

traceback = _Mock()

_default_message_template = "Oops, {app_name} crashed. We do our best to make it stable, but...\n\nA crash report was automatically generated with the following information:\n  - A verbatim copy of the crash traceback.\n  - A copy of your input history during this session.\n  - Data on your current {app_name} configuration.\n\nIt was left in the file named:\n\t'{crash_report_fname}'\nIf you can email this file to the developers, the information in it will help\nthem in understanding and correcting the problem.\n\nYou can mail it to: {contact_name} at {contact_email}\nwith the subject '{app_name} Crash Report'.\n\nIf you want to do it now, the following command will work (under Unix):\nmail -s '{app_name} Crash Report' {contact_email} < {crash_report_fname}\n\nTo ensure accurate tracking of this issue, please file a report about it at:\n{bug_tracker}\n"

_lite_message_template = '\nIf you suspect this is an IPython bug, please report it at:\n    https://github.com/ipython/ipython/issues\nor send an email to the mailing list at {email}\n\nYou can print a more detailed traceback right now with "%tb", or use "%debug"\nto interactively debug it.\n\nExtra-detailed tracebacks for bug-reporting purposes can be enabled via:\n    {config}Application.verbose_crash=True\n'

author_email = 'ipython-dev@scipy.org'

class CrashHandler(_Mock):
  pass
  message_template = "Oops, {app_name} crashed. We do our best to make it stable, but...\n\nA crash report was automatically generated with the following information:\n  - A verbatim copy of the crash traceback.\n  - A copy of your input history during this session.\n  - Data on your current {app_name} configuration.\n\nIt was left in the file named:\n\t'{crash_report_fname}'\nIf you can email this file to the developers, the information in it will help\nthem in understanding and correcting the problem.\n\nYou can mail it to: {contact_name} at {contact_email}\nwith the subject '{app_name} Crash Report'.\n\nIf you want to do it now, the following command will work (under Unix):\nmail -s '{app_name} Crash Report' {contact_email} < {crash_report_fname}\n\nTo ensure accurate tracking of this issue, please file a report about it at:\n{bug_tracker}\n"
  section_sep = '\n\n***************************************************************************\n\n'

