// Copyright (C) 1999-2012
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __basepanda_h__
#define __basepanda_h__

#include "vector.h"

class BasePanda {
 protected:
  double *angles_;
  int numAngles_;

  void sortAngles();
  void setAngles(double, double, int);
  void setAngles(int, const double*);
  void addAngle(double);
  void deleteAngle(int);

  int isIn(Vector&, int);

 public:
  BasePanda(const BasePanda& a);
  BasePanda(double a1, double a2, int an);
  BasePanda(int an, double* a);
  ~BasePanda();

  int numAngles() {return numAngles_;}
  double angles(int i) {return angles_[i];}
};

#endif
