// Copyright (C) 1999-2012
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __sigbus_h__
#define __sigbus_h__

// Signal Support
#include <setjmp.h>
#include <signal.h>

static sigjmp_buf crashbuf;
static struct sigaction osigact, sigact;
static void crashHandler(int dummy) {
  siglongjmp(crashbuf, 1);
}
#define INTERP interp
#define SETSIGBUS \
  if (sigsetjmp(crashbuf, 1)) { \
    Tcl_SetVar2(INTERP, "ds9", "msg", "SIGBUS has been received. Please exit Immdiately.", TCL_GLOBAL_ONLY); \
    Tcl_SetVar2(INTERP, "ds9", "msg,level", "error", TCL_GLOBAL_ONLY); \
  } \
  else { \
    sigact.sa_handler = crashHandler; \
    sigemptyset(&sigact.sa_mask); \
    sigact.sa_flags = 0; \
    sigaction(SIGBUS, &sigact, &osigact);
  
#define CLEARSIGBUS \
  } \
  sigaction(SIGBUS, &osigact, NULL); \

#endif
