// Copyright (C) 1999-2012
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

%pure-parser
%parse-param {SAOColorMap* cm}
%lex-param {liFlexLexer* ll}
%parse-param {liFlexLexer* ll}

%{
#define YYDEBUG 1

#define DISCARD_(x) {yyclearin; liDiscard(x);}

#include <string.h>
#include <iostream>

#include "sao.h"

#undef yyFlexLexer
#define yyFlexLexer liFlexLexer
#include <FlexLexer.h>

extern int lilex(void*, liFlexLexer*);
extern void lierror(SAOColorMap*, liFlexLexer*, const char*);
extern void liDiscard(int);
%}

%union {
#define SAOBUFSIZE 4096
  char str[SAOBUFSIZE];
  int integer;
  float real;
}

%type <real> numeric
%type <integer> yesno

%token <real> REAL
%token <integer> INT
%token <str> STRING

%token EOF_

%token BLUE_
%token DEBUG_
%token GREEN_
%token FALSE_
%token NO_
%token OFF_
%token ON_
%token PSEUDOCOLOR_
%token RED_
%token TRUE_
%token YES_

%%

commands: commands command terminator
	| command terminator
	;

command : DEBUG_ yesno {yydebug=$2;}
	| RED_ ':' {cm->setChannel(SAOColorMap::RED);}
	| GREEN_ ':' {cm->setChannel(SAOColorMap::GREEN);}
	| BLUE_ ':' {cm->setChannel(SAOColorMap::BLUE);}
	| PSEUDOCOLOR_
	| '#' {DISCARD_(1)} STRING
	| lis
	;

lis	: lis li
	| li
	;

li	: '(' numeric ',' numeric ')' {cm->newLIColor($2,$4);}
	;

terminator: '\n'
	| ';'
	| EOF_ {YYACCEPT;}
	;

numeric	: REAL {$$=$1;}
	| INT {$$=$1;}
	;

yesno	: INT {$$=($1 ? 1 : 0);}

	| YES_ {$$=1;}
	| 'Y' {$$=1;}
	| ON_ {$$=1;}
	| TRUE_ {$$=1;}

	| NO_ {$$=0;}
	| 'N' {$$=0;}
	| OFF_ {$$=0;}
	| FALSE_ {$$=0;}
	;

%%
