// Copyright (C) 1999-2005
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __basemarker_h__
#define __basemarker_h__

#include "marker.h"

#define MAXANNULI 512
#define MAXANGLES 720

class BaseMarker : public Marker {
protected:
  Vector* annuli_;
  int numAnnuli_;

  int numPoints_;
  Vector** vertices_;

  double startAng_;
  double stopAng_;

protected:
  virtual void render(Drawable, const Matrix&, RenderMode);
  virtual void updateHandles() =0;
  virtual void newVertices() =0;
  virtual void deleteVertices();

  void sortAnnuli();
  int insertAnnuli(Vector);

  Matrix fwdRefMatrix();
  Matrix fwdCanvasMatrix();
  Matrix bckRefMatrix();
  Matrix bckCanvasMatrix();

public:
  BaseMarker(const BaseMarker&);
  BaseMarker(FrameBase*, const Vector&, 
	     double, int, 
	     const char*, int, const char*, 
	     const char*, unsigned short, const char*,
	     const List<Tag>&, const List<CallBack>& cb);
  virtual ~BaseMarker();

  virtual Marker* dup() =0;
  virtual void updateBBox();
  void updateCoords(const Matrix&);

  virtual void ps(int);
  
  int numAnnuli() {return numAnnuli_;}
  Vector annuli(int i) {return annuli_[i];}

  void setAnnuli(const Vector&);
  void setAnnuli(const Vector&, const Vector&, int);
  void setAnnuli(const Vector*, int);
  
  virtual int addAnnuli() {}
  void deleteAnnuli(int h);
};

#endif
