// Copyright (C) 1999-2005
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __basebox_h__
#define __basebox_h__

#include "basemarker.h"

class BaseBox : public BaseMarker {
 private:
  void newVerticesA();
  void newVerticesB();

  void vertBTest(int* s1, int* s2, double a1, double a2, 
		 double b1, double b2, int quad, int ii, int* cnt);
  void vertBPrep(double a1, double a2, double ll, double ul, 
		 int quad, int ii, int* cnt);
  void vertBSeg(double ang1, double ang2, int quad, int ii, int* cnt);

protected:
  virtual void updateHandles();
  virtual void newVertices();

public:
  BaseBox(const BaseBox&);
  BaseBox(FrameBase* p, const Vector& ctr, 
	  double a,
	  const char* clr, int w, const char* f,
	  const char* t, unsigned short prop, const char* c, 
	  const List<Tag>& tag, const List<CallBack>& cb);

  virtual Marker* dup() =0;
  int isIn(const Vector&);
};

#endif
