// Copyright (C) 1999-2005
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

%{
#define YYPARSE_PARAM cb
#define CBB ((ColorbarBase*)cb)
#define CB ((Colorbar*)cb)
#define CBRGB ((ColorbarRGB*)cb)
#define YYDEBUG 1

#include <stdlib.h>

#include "colorbarbase.h"
#include "colorbar.h"
#include "colorbarrgb.h"

extern int cblex(void);
extern void cberror(const char*);

%}

%union {
  float real;
  int integer;
  char str[256];
}

%type <real> numeric
%type <integer> yesno

%type <integer> pscolorspace

%token <integer> INT
%token <real> REAL
%token <str> STRING

%token ADJUST_
%token BIAS_
%token BW_
%token CHANNEL_
%token COLORMAP_
%token COLORSPACE_
%token COLORS_
%token CONTRAST_
%token CMYK_
%token DEBUG_
%token GET_
%token GRAY_
%token FALSE_
%token FILE_
%token HEIGHT_
%token HIDE_
%token ID_
%token INVERT_
%token ITT_
%token LEVEL_
%token LIST_
%token LOAD_
%token MAP_
%token N_
%token NAME_
%token NO_
%token OFF_
%token ON_
%token POSTSCRIPT_
%token RESET_
%token RESOLUTION_
%token RGB_
%token SAVE_
%token SET_
%token SHOW_
%token TRUE_
%token VERSION_
%token WIDTH_
%token WINDOW_
%token Y_
%token YES_

%%

command : DEBUG_ debug

	| ADJUST_ numeric numeric {CBB->adjustCmd($2,$3);}
	| GET_ get
	| HIDE_ {CBB->hideCmd();}
	| INVERT_ yesno {CB->invertCmd($2 );}
	| ITT_ itt
	| LIST_ list
	| LOAD_ load
	| MAP_ map
	| POSTSCRIPT_ postscript
	| RESET_ {CBB->resetCmd();}
	| RGB_ CHANNEL_ STRING {CBRGB->setRGBChannelCmd($3);}
	| SAVE_ STRING {CB->saveCmd($2);}
	| SET_ set
	| SHOW_ {CBB->showCmd();}
	| VERSION_ {CBB->msg("Colorbar 1.0");}
	;

numeric	: REAL {$$=$1;}
	| INT {$$=$1;}
	;

debug	: ON_ {yydebug=1;}
	| OFF_ {yydebug=0;}
	;

yesno	: INT {$$=($1 ? 1 : 0);}

	| YES_ {$$=1;}
	| Y_ {$$=1;}
	| ON_ {$$=1;}
	| TRUE_ {$$=1;}

	| NO_ {$$=0;}
	| N_ {$$=0;}
	| OFF_ {$$=0;}
	| FALSE_ {$$=0;}
	;

get	: BIAS_ {CBB->getBiasCmd();}
	| COLORMAP_ {CBB->getColormapCmd();}
	| CONTRAST_ {CBB->getContrastCmd();}
	| FILE_ NAME_ {CBB->getCurrentFileNameCmd();}
	| HEIGHT_ {CBB->getHeightCmd();}
	| ID_ {CBB->getCurrentIDCmd();}
	| INVERT_ {CBB->getInvertCmd();}
	| NAME_ {CBB->getCurrentNameCmd();}
	| NAME_ INT {CBB->getColormapNameCmd($2);}
	| RGB_ CHANNEL_ {CBRGB->getRGBChannelCmd();}
	| WIDTH_ {CBB->getWidthCmd();}
	;

itt	: STRING {CB->ittCmd($1);}
	| INT {CB->ittCmd($1);}
	;

list	: /* empty */ {CB->listNameCmd();}
	| ID_ {CB->listIDCmd();}
	| NAME_ {CB->listNameCmd();}
	| ITT_ {CB->listITTNameCmd();}
	| ITT_ ID_ {CB->listITTIDCmd();}
	| ITT_ NAME_ {CB->listITTNameCmd();}
	;

load	: STRING {CB->loadCmd($1,NULL);}
	| STRING STRING {CB->loadCmd($1,$2);}
	| ITT_ STRING {CB->loadITTCmd($2);}
	;

map	: STRING {CB->mapCmd($1);}
	| INT {CB->mapCmd($1);}
	;

set	: COLORMAP_ setColormap
	;

setColormap: STRING numeric numeric INT {CB->setColormapCmd($1, $2, $3, $4);}
	| INT numeric numeric INT {CB->setColormapCmd($1, $2, $3, $4);}
	| RGB_ numeric numeric numeric numeric numeric numeric 
	  {CBRGB->setColormapCmd($2, $3, $4, $5, $6, $7);}
	| WINDOW_ STRING {CB->setColormapWindowCmd($2);}
	;

postscript : COLORSPACE_ pscolorspace 
	  {CBB->psColorSpaceCmd((Widget::PSColorSpace)$2);}
	| LEVEL_ INT {CBB->psLevelCmd($2);}
	| RESOLUTION_ INT {CBB->psResolutionCmd($2);}
	;

pscolorspace : BW_ {$$ = Widget::BW;}
	| GRAY_ {$$ = Widget::GRAY;}
	| RGB_ {$$ = Widget::RGB;}
	| CMYK_ {$$ = Widget::CMYK;}
	;
%%
