.\" Automatically generated by Pod::Man v1.37, Pod::Parser v1.14
.\"
.\" Standard preamble:
.\" ========================================================================
.de Sh \" Subsection heading
.br
.if t .Sp
.ne 5
.PP
\fB\\$1\fR
.PP
..
.de Sp \" Vertical space (when we can't use .PP)
.if t .sp .5v
.if n .sp
..
.de Vb \" Begin verbatim text
.ft CW
.nf
.ne \\$1
..
.de Ve \" End verbatim text
.ft R
.fi
..
.\" Set up some character translations and predefined strings.  \*(-- will
.\" give an unbreakable dash, \*(PI will give pi, \*(L" will give a left
.\" double quote, and \*(R" will give a right double quote.  | will give a
.\" real vertical bar.  \*(C+ will give a nicer C++.  Capital omega is used to
.\" do unbreakable dashes and therefore won't be available.  \*(C` and \*(C'
.\" expand to `' in nroff, nothing in troff, for use with C<>.
.tr \(*W-|\(bv\*(Tr
.ds C+ C\v'-.1v'\h'-1p'\s-2+\h'-1p'+\s0\v'.1v'\h'-1p'
.ie n \{\
.    ds -- \(*W-
.    ds PI pi
.    if (\n(.H=4u)&(1m=24u) .ds -- \(*W\h'-12u'\(*W\h'-12u'-\" diablo 10 pitch
.    if (\n(.H=4u)&(1m=20u) .ds -- \(*W\h'-12u'\(*W\h'-8u'-\"  diablo 12 pitch
.    ds L" ""
.    ds R" ""
.    ds C` ""
.    ds C' ""
'br\}
.el\{\
.    ds -- \|\(em\|
.    ds PI \(*p
.    ds L" ``
.    ds R" ''
'br\}
.\"
.\" If the F register is turned on, we'll generate index entries on stderr for
.\" titles (.TH), headers (.SH), subsections (.Sh), items (.Ip), and index
.\" entries marked with X<> in POD.  Of course, you'll have to process the
.\" output yourself in some meaningful fashion.
.if \nF \{\
.    de IX
.    tm Index:\\$1\t\\n%\t"\\$2"
..
.    nr % 0
.    rr F
.\}
.\"
.\" For nroff, turn off justification.  Always turn off hyphenation; it makes
.\" way too many mistakes in technical documents.
.hy 0
.if n .na
.\"
.\" Accent mark definitions (@(#)ms.acc 1.5 88/02/08 SMI; from UCB 4.2).
.\" Fear.  Run.  Save yourself.  No user-serviceable parts.
.    \" fudge factors for nroff and troff
.if n \{\
.    ds #H 0
.    ds #V .8m
.    ds #F .3m
.    ds #[ \f1
.    ds #] \fP
.\}
.if t \{\
.    ds #H ((1u-(\\\\n(.fu%2u))*.13m)
.    ds #V .6m
.    ds #F 0
.    ds #[ \&
.    ds #] \&
.\}
.    \" simple accents for nroff and troff
.if n \{\
.    ds ' \&
.    ds ` \&
.    ds ^ \&
.    ds , \&
.    ds ~ ~
.    ds /
.\}
.if t \{\
.    ds ' \\k:\h'-(\\n(.wu*8/10-\*(#H)'\'\h"|\\n:u"
.    ds ` \\k:\h'-(\\n(.wu*8/10-\*(#H)'\`\h'|\\n:u'
.    ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'^\h'|\\n:u'
.    ds , \\k:\h'-(\\n(.wu*8/10)',\h'|\\n:u'
.    ds ~ \\k:\h'-(\\n(.wu-\*(#H-.1m)'~\h'|\\n:u'
.    ds / \\k:\h'-(\\n(.wu*8/10-\*(#H)'\z\(sl\h'|\\n:u'
.\}
.    \" troff and (daisy-wheel) nroff accents
.ds : \\k:\h'-(\\n(.wu*8/10-\*(#H+.1m+\*(#F)'\v'-\*(#V'\z.\h'.2m+\*(#F'.\h'|\\n:u'\v'\*(#V'
.ds 8 \h'\*(#H'\(*b\h'-\*(#H'
.ds o \\k:\h'-(\\n(.wu+\w'\(de'u-\*(#H)/2u'\v'-.3n'\*(#[\z\(de\v'.3n'\h'|\\n:u'\*(#]
.ds d- \h'\*(#H'\(pd\h'-\w'~'u'\v'-.25m'\f2\(hy\fP\v'.25m'\h'-\*(#H'
.ds D- D\\k:\h'-\w'D'u'\v'-.11m'\z\(hy\v'.11m'\h'|\\n:u'
.ds th \*(#[\v'.3m'\s+1I\s-1\v'-.3m'\h'-(\w'I'u*2/3)'\s-1o\s+1\*(#]
.ds Th \*(#[\s+2I\s-2\h'-\w'I'u*3/5'\v'-.3m'o\v'.3m'\*(#]
.ds ae a\h'-(\w'a'u*4/10)'e
.ds Ae A\h'-(\w'A'u*4/10)'E
.    \" corrections for vroff
.if v .ds ~ \\k:\h'-(\\n(.wu*9/10-\*(#H)'\s-2\u~\d\s+2\h'|\\n:u'
.if v .ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'\v'-.4m'^\v'.4m'\h'|\\n:u'
.    \" for low resolution devices (crt and lpr)
.if \n(.H>23 .if \n(.V>19 \
\{\
.    ds : e
.    ds 8 ss
.    ds o a
.    ds d- d\h'-1'\(ga
.    ds D- D\h'-1'\(hy
.    ds th \o'bp'
.    ds Th \o'LP'
.    ds ae ae
.    ds Ae AE
.\}
.rm #[ #] #H #V #F C
.\" ========================================================================
.\"
.IX Title "regcoords n"
.TH regcoords n "August 12, 2005" "version 1.3.0b9" "SAORD Documentation"
.SH "NAME"
\&\fBRegCoords: Spatial Region Coordinates\fR
.SH "SYNOPSIS"
.IX Header "SYNOPSIS"
This document describes the specification of coordinate systems, and the 
interpretation of coordinate values, for spatial region filtering.
.SH "DESCRIPTION"
.IX Header "DESCRIPTION"
\&\fBPixel coordinate systems\fR
.PP
The default coordinate system for regions is \s-1PHYSICAL\s0, which means
that region position and size values are taken from the original
data. (Note that this is a change from the original \s-1IRAF/PROS\s0
implementation, in which the \s-1IMAGE\s0 coordinate system was the default.)
\&\s-1PHYSICAL\s0 coordinates always refer to pixel positions on the original
image (using \s-1IRAF\s0 \s-1LTM\s0 and \s-1LTV\s0 keywords).  With \s-1PHYSICAL\s0 coordinates,
if a set of coordinates specifies the position of an object in an
original \s-1FITS\s0 file, the same coordinates will specify the same object
in any \s-1FITS\s0 derived from the original.  Physical coordinates are
invariant with blocking of \s-1FITS\s0 files or taking sections of images,
even when a blocked section is written to a new file.
.PP
Thus, although a value in pixels refers, by default, to the \s-1PHYSICAL\s0
coordinate system, you may specify that position values refer to the
image coordinate system using the \fBglobal\fR or \fBlocal\fR
properties commands:
.PP
.Vb 2
\&  global coordsys image
\&  circle 512 512 100
.Ve
.PP
The \fBglobal\fR command changes the coordinate system for all
regions that follow, while the \fBlocal\fR command changes the
coordinate system only for the region immediately following:
.PP
.Vb 3
\&  local coordsys image
\&  circle 512 512 100
\&  circle 1024 1024 200
.Ve
.PP
This changes the coordinate system only for the region that follows.
In the above example, the second region uses the global coordinate
system (\s-1PHYSICAL\s0 by default).
.PP
\&\fBWorld Coordinate Systems\fR
.PP
If World Coordinate System information is contained in the data file
being filtered, it also is possible to define regions using a sky
coordinate system. Supported systems include:
.PP
.Vb 10
\&  name                  description
\&  ----                  -----------
\&  PHYSICAL              pixel coords of original file using LTM/LTV
\&  IMAGE                 pixel coords of current file
\&  FK4, B1950            sky coordinate systems
\&  FK5, J2000            sky coordinate systems
\&  GALACTIC              sky coordinate systems
\&  ECLIPTIC              sky coordinate systems
\&  ICRS                  currently same as J2000
\&  LINEAR                linear wcs as defined in file
.Ve
.PP
In addition, two mosaic coordinate systems have been defined that
utilize the (evolving) \s-1IRAF\s0 mosaic keywords:
.PP
.Vb 4
\&  name                  description
\&  ----                  -----------
\&  AMPLIFIER             mosaic coords of original file using ATM/ATV
\&  DETECTOR              mosaic coords of original file using DTM/DTV
.Ve
.PP
Again, to use one of these coordinate systems, the \fBglobal\fR or
\&\fBlocal\fR properties commands are used:
.PP
.Vb 1
\&  global coordsys galactic
.Ve
.PP
\&\fB\s-1WCS\s0 Positions and Sizes\fR
.PP
In addition to pixels, positional values in a WCS-enabled region can
be specified using sexagesimal or degrees format:
.PP
.Vb 11
\&  position arguments    description
\&  ------------------    -----------
\&  [num]                 context-dependent (see below)
\&  [num]d                degrees
\&  [num]r                radians
\&  [num]p                physical pixels
\&  [num]i                image pixels
\&  [num]:[num]:[num]     hms for 'odd' position arguments
\&  [num]:[num]:[num]     dms for 'even' position arguments
\&  [num]h[num]m[num]s    explicit hms
\&  [num]d[num]m[num]s    explicit dms
.Ve
.PP
If ':' is used as sexagesimal separator, the value is considered to be
specifying hours/minutes/seconds if it is the first argument of a
positional pair, and degrees/minutes/seconds for the second argument
of a pair (except for galactic coordinates, which always use degrees):
.PP
.Vb 7
\&  argument      description
\&  -----------   -----------
\&  10:20:30.0    10 hours, 20 minutes, 30 seconds for 1st positional argument
\&                10 degrees, 20 minutes, 30 seconds for 2nd positional argument
\&  10h20m30.0    10 hours, 20 minutes, 30 seconds
\&  10d20m30.0    10 degrees, 20 minutes, 30 seconds
\&  10.20d        10.2 degrees
.Ve
.PP
Similarly, the units of size values are defined by the formating
character(s) attached to a number:
.PP
.Vb 9
\&  size arguments        description
\&  --------------        -----------
\&  [num]                 context-dependent (see below)
\&  [num]"                arc sec
\&  [num]'                arc min
\&  [num]d                degrees
\&  [num]r                radians
\&  [num]p                physical pixels
\&  [num]i                image pixels
.Ve
.PP
For example:
.PP
.Vb 8
\&  argument      description
\&  -----------   -----------
\&  10            ten pixels
\&  10'           ten minutes of arc
\&  10"           ten seconds of arc
\&  10d           ten degrees
\&  10p           ten pixels
\&  0.5r          half of a radian
.Ve
.PP
An example of using sky coordinate systems follows:
.PP
.Vb 4
\&  global coordsys B1950
\&  -box 175.54d 20.01156d 10' 10'
\&  local coordsys J2000
\&  pie 179.57d 22.4d 0 360 n=4 && annulus 179.57d 22.4d 3' 24' n=5
.Ve
.PP
At the \s-1FK4\s0 1950 coordinates 175.54d \s-1RA\s0, 20.01156d \s-1DEC\s0 exclude a 10
minute by 10 minute box.  Then at the \s-1FK5\s0 2000 coordinates 179.57d \s-1RA\s0
22.4d \s-1DEC\s0 draw a radial profile regions pattern with 4 quadrants and 5
annuli ranging from 3 minutes to 24 minutes in diameter.  In this
example, the default coordinate system is overridden by the commands
in the regions spec.
.PP
\&\fB\s-1NB:\s0 The Meaning of Pure Numbers Are Context Sensitive\fR
.PP
When a \*(L"pure number\*(R" (i.e. one without a format directive such as 'd'
for 'degrees') is specified as a position or size, its interpretation
depends on the context defined by the 'coordsys' keyword. In general,
the rule is:
.PP
All pure numbers have implied units corresponding to the current
coordinate system.
.PP
If no coordinate system is explicitly specified, the default system is
implicitly assumed to be \s-1PHYSICAL\s0.  In practice this means that for
\&\s-1IMAGE\s0 and \s-1PHYSICAL\s0 systems, pure numbers are pixels.  Otherwise,
for all systems other than \s-1LINEAR\s0, pure numbers are degrees. For
\&\s-1LINEAR\s0 systems, pure numbers are in the units of the linear system.
This rule covers both positions and sizes.
.PP
As a corollary, when a sky-formatted number is used with the \s-1IMAGE\s0
or \s-1PHYSICAL\s0 coordinate system (which includes the default case of no
coordsys being specified), the formatted number is assumed to be in
the units of the \s-1WCS\s0 contained in the current file. If no sky \s-1WCS\s0 is
specified, an error results.
.PP
Examples:
.PP
.Vb 2
\&  circle(512,512,10)
\&  ellipse 202.44382d 47.181656d 0.01d 0.02d
.Ve
.PP
In the absence of a specified coordinate system, the circle uses the
default \s-1PHYSICAL\s0 units of pixels, while the ellipse explicitly uses degrees,
presumably to go with the \s-1WCS\s0 in the current file.
.PP
.Vb 5
\& global coordsys=fk5 
\& global color=green font="system 10 normal"
\& circle 202.44382 47.181656 0.01
\& circle 202.44382 47.181656 10p
\& ellipse(512p,512p,10p,15p,20)
.Ve
.PP
Here, the circles use the \s-1FK5\s0 units of degrees (except for the
explicit use of pixels in the second radius), while the ellipse
explicitly specifies pixels. The ellipse angle is in degrees.
.PP
Note that Chandra data format appears to use \*(L"coordsys=physical\*(R"
implicitly.  Therefore, for most Chandra applications, valid regions
can be generated safely by asking ds9 to save/display regions in
pixels using the \s-1PHYSICAL\s0 coordsys.
.SH "SEE ALSO"
.IX Header "SEE ALSO"
See funtools(n) for a list of Funtools help pages
