#  Copyright (C) 1999-2005
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc NSVRServer {varname} {
    upvar #0 $varname var
    global $varname

    global http

    ARStatus $varname "Looking up $var(name)"
    set var(x) {}
    set var(y) {}

    switch -- $var(nameserver) {
	ned-sao {
	    set query "[regsub -all {\ } $var(name) {%20}]"
	    set url "http://cfa-www.harvard.edu/catalog/ned"
	    set cmd NSVRNEDSAO
	}
	ned-eso {
	    set query "&o=[regsub -all {\ } $var(name) {%20}]"
	    set url "http://archive.eso.org/skycat/servers/ned-server"
	    set cmd NSVRNEDESO
	}
	simbad-sao {
	    set query "[regsub -all {\ } $var(name) {%20}]"
	    set url "http://cfa-www.harvard.edu/catalog/simbad-cfa"
	    set cmd NSVRSIMBADSAO
	}
	simbad-eso {
	    set query "&o=[regsub -all {\ } $var(name) {%20}]"
	    set url "http://archive.eso.org/skycat/servers/sim-server"
	    set cmd NSVRSIMBADESO
	}
    }

    if {$var(sync)} {
	set token [http::geturl $url?$query -headers "[ProxyHTTP]"]
	set var(state) 1
	set var(token) $token

	eval $cmd $varname $token
    } else {
	set token [http::geturl $url?$query \
		       -command [list $cmd $varname] \
		       -headers "[ProxyHTTP]"]
	set var(state) 1
	set var(token) $token
    }
}

proc NSVRNEDSAO {varname token} {
    upvar #0 $varname var
    global $varname

    HTTPLog $token
    if {$var(state)} {
	# check for error
	set code [http::ncode $token]
	if {$code != "200"} {
	    ARError $varname $code
	    return
	}

	# data is in sexagesmal
	set data [http::data $token]
	set r [lindex $data 0]
	set d  [lindex $data 1]
	if {($r != {}) && ($d != {})} {
	    switch -- $var(skyformat) {
		degrees {NSVRParse $varname [h2d [Sex2H $r]] [Sex2D $d]}
		sexagesimal {NSVRParse $varname $r $d}
	    }
	} else {
	    NSVRParse $varname {} {}
	}
    } else {
	ARStatus $varname {Cancelled}
	ARReset $varname
    }
}

proc NSVRNEDESO {varname token} {
    upvar #0 $varname var
    global $varname

    HTTPLog $token
    if {$var(state)} {
	# check for error
	set code [http::ncode $token]
	if {$code != "200"} {
	    ARError $varname $code
	    return
	}

	# data is in degrees
	set data [http::data $token]
	set l [llength $data]
	set r [lindex $data [expr $l-3]]
	set d [lindex $data [expr $l-2]]
	if {[string is double -strict $r] && [string is double -strict $d]} {
	    switch -- $var(skyformat) {
		degrees {NSVRParse $varname $r $d}
		sexagesimal {
		    NSVRParse $varname [uformat d h: $r] [uformat d d: $d]
		}
	    }
	} else {
	    NSVRParse $varname {} {}
	}
    } else {
	ARStatus $varname {Cancelled}
	ARReset $varname
    }
}

proc NSVRSIMBADSAO {varname token} {
    upvar #0 $varname var
    global $varname

    HTTPLog $token
    if {$var(state)} {
	# check for error
	set code [http::ncode $token]
	if {$code != "200"} {
	    ARError $varname $code
	    return
	}

	# data is in sexagesmal
	set data [http::data $token]
	set r [lindex $data 0]
	set d  [lindex $data 1]
	if {($r != {}) && ($d != {})} {
	    switch -- $var(skyformat) {
		degrees {NSVRParse $varname [h2d [Sex2H $r]] [Sex2D $d]}
		sexagesimal {NSVRParse $varname $r $d}
	    }
	} else {
	    NSVRParse $varname {} {}
	}
    } else {
	ARStatus $varname {Cancelled}
	ARReset $varname
    }
}

proc NSVRSIMBADESO {varname token} {
    upvar #0 $varname var
    global $varname

    HTTPLog $token
    if {$var(state)} {
	# check for error
	set code [http::ncode $token]
	if {$code != "200"} {
	    ARError $varname $code
	    return
	}

	# data is in degrees
	set data [http::data $token]
	set l [llength $data]
	set r [lindex $data [expr $l-3]]
	set d [lindex $data [expr $l-2]]
	if {[string is double -strict $r] && [string is double -strict $d]} {
	    switch -- $var(skyformat) {
		degrees {NSVRParse $varname $r $d}
		sexagesimal {
		    NSVRParse $varname [uformat d h: $r] [uformat d d: $d]
		}
	    }
	} else {
	    NSVRParse $varname {} {}
	}
    } else {
	ARStatus $varname {Cancelled}
	ARReset $varname
    }
}

proc NSVRParse {varname x y} {
    upvar #0 $varname var
    global $varname

    set var(x) $x
    set var(y) $y

    if {($var(x) == {}) || ($var(y) == {})} {
	set var(x) {}
	set var(y) {}
	ARStatus $varname "$var(name) not found"
	ARReset $varname
    } else {
	eval $var(proc,next) $varname
    }
}

proc NSVRServerMenu {varname} {
    upvar #0 $varname var
    global $varname

    global menu

    $var(mb) add cascade -label "Name Server" -menu $var(mb).name
    menu $var(mb).name -tearoff 0 -selectcolor $menu(selectcolor)
    $var(mb).name add radiobutton -label "NED@SAO" \
	-variable ${varname}(nameserver) -value ned-sao
    $var(mb).name add radiobutton -label "NED@ESO" \
	-variable ${varname}(nameserver) -value ned-eso
    $var(mb).name add radiobutton -label "SIMBAD@SAO" \
	-variable ${varname}(nameserver) -value simbad-sao
    $var(mb).name add radiobutton -label "SIMBAD@ESO" \
	-variable ${varname}(nameserver) -value simbad-eso
}
