#  Copyright (C) 1999-2005
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc CompassDialog {frame id} {
    global menu
    global marker

    set w ".marker$id"

    # see if we already have a header window visible
    if [winfo exist $w] {
	raise $w
	return
    }

    # variables
    set arrows [$frame get marker $id compass arrow]
    set marker($frame,$id,narrow) [lindex $arrows 0]
    set marker($frame,$id,earrow) [lindex $arrows 1]

    set labels [$frame get marker $id compass label]
    set marker($frame,$id,north) [lindex $labels 0]
    set marker($frame,$id,east) [lindex $labels 1]

    set s [$frame get marker $id compass system]
    set marker($frame,$id,system) [lindex $s 0]
    set marker($frame,$id,sky) [lindex $s 1]

    # base
    MarkerBaseCenterDialog $frame $id 275 150

    # Labels
    label $w.ref.f.ntitle -text "North"
    entry $w.ref.f.north -textvariable marker($frame,$id,north) -width 13
    checkbutton $w.ref.f.narrow -variable marker($frame,$id,narrow) \
	-text "Arrow" -selectcolor $menu(selectcolor) \
	-command "CompassArrow $frame $id"
    label $w.ref.f.etitle -text "East"
    entry $w.ref.f.east -textvariable marker($frame,$id,east) -width 13
    checkbutton $w.ref.f.earrow -variable marker($frame,$id,earrow) \
	-text "Arrow" -selectcolor $menu(selectcolor) \
	-command "CompassArrow $frame $id"

    grid $w.ref.f.ntitle $w.ref.f.north $w.ref.f.narrow -padx 4 -sticky w
    grid $w.ref.f.etitle $w.ref.f.east $w.ref.f.earrow -padx 4 -sticky w
}

# actions

proc CompassClose {frame id} {
    MarkerBaseCenterClose $frame $id
}

proc CompassApply {frame id} {
    global marker

    $frame marker $id compass label \
	"\{$marker($frame,$id,north)\}" "\{$marker($frame,$id,east)\}"

    MarkerBaseCenterApply $frame $id
}

proc CompassArrow {frame id} {
    global marker
    
    $frame marker $id compass arrow \
	$marker($frame,$id,narrow) $marker($frame,$id,earrow)
}

# callbacks

proc CompassCoordCB {frame id} {
    global marker

    MarkerBaseCoordCB $frame $id
    MarkerBaseCenterMoveCB $frame $id

    $frame marker $id compass system \
	$marker($frame,$id,system) $marker($frame,$id,sky)
}



