// Copyright (C) 1999-2004
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __basebox_h__
#define __basebox_h__

#include "basemarker.h"

class BaseBox : public BaseMarker {
protected:
  Vector* size;
  Matrix flip;

  void calcPoints(double);
  virtual void updateHandles() {}
  double getWCSAngle();

public:
  BaseBox(const BaseBox&);
  BaseBox(FrameBase* p, const Vector& ctr, double a,
	  const char* clr, int w, const char* f,
	  const char* t, unsigned short prop, const char* c, 
	  const List<Tag>& tag);
  virtual ~BaseBox();

  virtual Marker* dup() =0;
  void updateCoords(const Matrix&);
  int isIn(const Vector&);

  virtual void list(ostream&, CoordSystem, SkyFrame, SkyFormat, char) =0;
  virtual void listCiao(ostream&, CoordSystem, SkyFrame, SkyFormat, char) {}
  virtual void listSAOimage(ostream&,CoordSystem,SkyFrame,SkyFormat,char) =0;
  virtual void listPros(ostream&, CoordSystem, SkyFrame, SkyFormat, char) =0;
};

#endif
