/*
 *	Copyright (c) 1999-2003 Smithsonian Astrophysical Observatory
 */

/*
 *
 * GIO.H -- include file for gio.c
 *
 */

#ifndef _gio_h

#if HAVE_CONFIG_H
#include <conf.h>
#endif

#include <stdio.h>
#ifdef HAVE_STRING_H
#include <string.h>
#endif
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_MALLOC_H
#include <malloc.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <ctype.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/stat.h>
#ifdef HAVE_SYS_SHM_H
#include <sys/shm.h>
#endif
#ifdef HAVE_SYS_MMAN_H
#include <sys/mman.h>
#endif
#include <prsetup.h>

#ifdef __STDC__
#include <stdarg.h>
#else
#include <varargs.h>
#endif

/* socket support */
#include <fcntl.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/socket.h>         /* struct sockaddr, SOCK_STREAM, ... */
#include <netinet/in.h>         /* struct in_addr, struct sockaddr_in */
#include <netdb.h>              /* gethostbyname() */
#include <arpa/inet.h>		/* inet_addr() */

/* make sure socklen_t is available, since some systems don't use it */
#ifndef HAVE_SOCKLEN_T
#define socklen_t int
#endif

#ifndef NewString
#define NewString(str) \
	((str) != (char *)NULL ? \
	((char *)strcpy((char *)malloc((unsigned)strlen(str)+1), str)) : \
	(char *)NULL)
#endif

#ifndef SZ_LINE
#define SZ_LINE 4096
#endif

#ifndef MIN
#define MIN(x, y)	(((x) < (y)) ? (x) : (y))
#endif

#ifndef MAX
#define MAX(x, y)	(((x) > (y)) ? (x) : (y))
#endif

#ifndef ABS
#define ABS(x)		((x)<0?(-x):(x))
#endif

/* define the types of "file" we can open */
#define GIO_DISK	1
#define GIO_STREAM	2
#define GIO_MEMORY	4
#define GIO_MMAP	8
#define GIO_SHM		16
#define GIO_PIPE	32
#define GIO_SOCKET	64
#define GIO_GZIP       128

/* define the size of the memory buffer increment we allocate */
#define GIO_BUFINC 81920

/* define socket parameters */
#define GIO_RETRIES   6000
#define GIO_MAXLISTEN 1000
#define GIO_TIMEOUT     60

typedef struct {
  int type;
  char *name;
  char *mode;
  /* memory types */
  char *buf;
  long len;
  long cur;
  int extend;
  /* disk files and streams */
  FILE *fp;
  int unbuffered;
  /* gzip */
  void *gz;
  /* shared memory */
  int shmid;
  int shmoff;
  /* command pipes and sockets */
  int pid;
  int ifd;
  int ofd;
} *GIO, GIORec, GFile;

_PRbeg

GIO gopen _PRx((char *name, char *mode));
GIO gmemopen _PRx((char *buf, int len, char *mode));
void *_gread _PRx((GIO gio, char *buf, int size, int n, int *got));
int gread _PRx((GIO gio, char *buf, int size, int n));
int gwrite _PRx((GIO gio, char *buf, int size, int n));
int gflush _PRx((GIO gio));
off_t gseek _PRx((GIO gio, long offset, int whence));
long gtell _PRx((GIO gio));
int gskip _PRx((GIO gio, int n));
int ginfo _PRx((GIO gio, 
		char **name, int *type, int *cur, char **buf, int *len));
void gfreebuf _PRx((GIO gio, void *buf));
void gclose _PRx((GIO gio));
int setgerror _PRx((int flag));
char *gerrorstring _PRx((void));
#ifdef __STDC__
void gerror(FILE *fd, char *format, ...);
void gwarning(FILE *fd, char *format, ...);
#else
void gerror();
void gwarning();
#endif
int setgwarning _PRx((int flag));
char *gwarningstring _PRx((void));
void gsleep _PRx((int millisec));

_PRend

#define _gio_h

#endif
