#  Copyright (C) 1999-2004
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc UpdateWCSMenu {} {
    global ds9
    global current
    global buttons
    global menu

    global debug
    if {$debug(tcl,update)} {
	puts "UpdateWCSMenu"
    }

    if {$current(frame) != ""} {
	$ds9(mb) entryconfig $menu(wcs) -state normal
	$buttons(name).major.wcs1 configure -state normal

	UpdateWCSCoordMenu "$current(frame)" $ds9(mb).wcs

    } else {
	$ds9(mb) entryconfig $menu(wcs) -state disabled
	$buttons(name).major.wcs1 configure -state disabled
    }
}

proc UpdateWCS {} {
    global wcs

    # info panel
    # first see if more that one wcs is displayed
    global info
    set cnt 0
    foreach l {{} A B C D E F G H I J K L M N O P Q R S T U V W X Y Z} {
	if {$info(wcs$l)} {incr cnt}
    }
    # if one one displayed, replace
    if {$cnt == 1} {
	foreach l {{} A B C D E F G H I J K L M N O P Q R S T U V W X Y Z} {
	    set info(wcs$l) 0
	}
    }
    set info($wcs(system)) 1
    UpdateInfoPanel

    # align
    set wcs(align,system) $wcs(system)
    set wcs(align,sky) $wcs(sky)
    AlignWCSFrame

    # compass
    global panner
    set panner(compass,wcs,system) $wcs(system)
    set panner(compass,wcs,sky) $wcs(sky)
    ChangeWCSCompass

    # grid
    global grid
    set grid(system) $wcs(system)
    set grid(sky) $wcs(sky)
    set grid(skyformat) $wcs(skyformat)
    GridUpdate

    # regions
    global marker
    set marker(system) $wcs(system)
    set marker(sky) $wcs(sky)
    set marker(skyformat) $wcs(skyformat)
    UpdateMarkerFormatMenu

    # print coords
    global coord
    set cnt 0
    foreach l {{} A B C D E F G H I J K L M N O P Q R S T U V W X Y Z} {
	if {$coord(wcs$l)} {incr cnt}
    }
    # if one one displayed, replace
    if {$cnt == 1} {
	foreach l {{} A B C D E F G H I J K L M N O P Q R S T U V W X Y Z} {
	    set coord(wcs$l) 0
	}
    }
    set coord($wcs(system)) 1
    set coord(sky) $wcs(sky)
    set coord(skyformat) $wcs(skyformat)

    # panzoom dialog
    global panzoom
    set panzoom(system) $wcs(system)
    set panzoom(sky) $wcs(sky)
    set panzoom(skyformat) $wcs(skyformat)
    UpdatePanZoomDialog
}

proc AlignWCSFrame {} {
    global current
    global wcs
    global ds9

    if {$current(frame) != ""} {
	SetWatchCursor
	$current(frame) wcs align $wcs(align) $wcs(align,system) \
	    $wcs(align,sky)
	UnsetWatchCursor
	UpdateAlignWCSMenu $ds9(mb).zoom
    }
}

proc UpdateAlignWCSMenu {which} {
    global current
    global wcs

    # no frame
    if {$current(frame) == ""} {
	$which entryconfig "Align to WCS" -state disabled
	$which entryconfig "Align Coord System" -state disabled
	return
    }

    # unloaded frame
    if {![$current(frame) has fits]} {
	$which entryconfig "Align to WCS" -state normal
	$which entryconfig "Align Coord System" -state normal

	$which.align entryconfig "WCS" -state normal
	$which.align entryconfig "Multiple WCS" -state normal

	$which.align entryconfig "Equatorial B1950" -state normal
	$which.align entryconfig "Equatorial J2000" -state normal
	$which.align entryconfig "ICRS" -state normal
	$which.align entryconfig "Galactic" -state normal
	$which.align entryconfig "Ecliptic" -state normal

	foreach l {A B C D E F G H I J K L M N O P Q R S T U V W X Y Z} {
	    $which.align.wcs entryconfig "WCS $l" -state normal
	}
	return
    }

    # loaded frame
    $which entryconfig "Align to WCS" -state normal
    $which entryconfig "Align Coord System" -state normal

    if {[$current(frame) has wcs WCS]} {
	$which.align entryconfig "WCS" -state normal
    } else {
	$which.align entryconfig "WCS" -state disabled
    }
    $which.align entryconfig "Multiple WCS" -state normal
    foreach l {A B C D E F G H I J K L M N O P Q R S T U V W X Y Z} {
	if {[$current(frame) has wcs WCS$l]} {
	    $which.align.wcs entryconfig "WCS $l" -state normal
	} else {
	    $which.align.wcs entryconfig "WCS $l" -state disabled
	}
    }

    SetSkyFrameMenu2 $which.align disabled

    if {$current(frame) != ""} {
	if {[$current(frame) has fits]} {
	    switch -- $wcs(align,system) {
		wcs {}
		default {
		    if {![$current(frame) has wcs $wcs(align,system)]} {
			    set wcs(align,system) wcs
		    }
		}
	    }

	    if [$current(frame) has wcs equatorial $wcs(align,system)] {
		SetSkyFrameMenu2 $which.align normal
	    }
	}
    }
}

proc ProcessWCSCmd {varname iname} {
    upvar $varname var
    upvar $iname i

    global wcs
    global current

    switch -- [string tolower [lindex $var $i]] {
	system {
	    incr i
	    set wcs(system) [string tolower [lindex $var $i]]
	    UpdateWCS
	}
	sky {
	    incr i
	    set wcs(sky) [string tolower [lindex $var $i]]
	    UpdateWCS
	}
	format -
	skyformat {
	    incr i
	    set wcs(skyformat) [string tolower [lindex $var $i]]
	    UpdateWCS
	}
	align {
	    incr i
	    set wcs(align) [FromYesNo [lindex $var $i]]
	    AlignWCSFrame
	}
	reset {
	    $current(frame) wcs reset
	}
	replace {
	    incr i
	    if {[lindex $var $i] == "file"} {
		incr i
	    }
	    $current(frame) wcs replace [lindex $var $i]
	}
	append {
	    incr i
	    if {[lindex $var $i] == "file"} {
		incr i
	    }
	    $current(frame) wcs append [lindex $var $i]
	}
	default {
	    set wcs(system) [string tolower [lindex $var $i]]
	    switch -- $wcs(system) {
		fk4 -
		fk5 -
		icrs -
		galactic -
		ecliptic {
		    set wcs(sky) $wcs(system)
		    set wcs(system) wcs
		}
	    }
	    UpdateWCS
	}
    }
}




