#  Copyright (C) 1999-2004
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc SaveState {} {
    global ds9
    global message

    set fn [SaveFileDialog statefbox]
    if {[string length $fn] == 0} {
	return
    }

    set file [open $fn w]
    if {$file == ""} {
	tk_messageBox -message \
	    "$message(error,state,save)" \
	    -type ok -icon error
	return
    }

    close $file
}

proc LoadState {} {
    set fn [OpenFileDialog statefbox]
    if {[string length $fn] == 0} {
	return
    }

    # wipe the slate clean
    DeleteAllFrames

    # and load the world
    # catch {source $fn}
    source $fn

    # and update it
    UpdateDS9
}



