#  Copyright (C) 1999-2004
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc RulerDialog {frame id} {
    global menu
    global marker
    global ds9

    # see if we already have a header window visible

    set w ".marker$id"
    set mb ".mb$id"

    if [winfo exist $w] {
	raise $w
	return
    }

    # init marker variables

    set marker($frame,$id,system) $marker(dialog,system)
    set marker($frame,$id,clabel) $marker(dialog,system)
    set marker($frame,$id,sky) $marker(dialog,sky)
    set marker($frame,$id,skyformat) $marker(dialog,skyformat)

    set marker($frame,$id,dcoord) $marker(dialog,dist,system)
    set marker($frame,$id,dlabel) $marker(dialog,dist,system)
    set marker($frame,$id,dformat) $marker(dialog,dist,format)

    # ruler specific callbacks

    $frame marker $id callback move EditRulerCB $frame
    $frame marker $id callback edit EditRulerCB $frame
    $frame marker $id callback text TextMarkerCB $frame
    $frame marker $id callback color ColorMarkerCB $frame
    $frame marker $id callback width LineWidthMarkerCB $frame
    $frame marker $id callback property PropertyMarkerCB $frame
    $frame marker $id callback font FontMarkerCB $frame
    $frame marker $id callback delete DeleteRulerDialog $frame

    # define menus

    MBMarkerDialog $frame $mb
    FileMenuMarkerDialog $frame $mb $id
    ColorMenuMarkerDialog $frame $mb $id
    WidthMenuMarkerDialog $frame $mb $id
    PropMenuRulerDialog $frame $mb $id
    FontMenuMarkerDialog $frame $mb $id
    CoordMenuMarkerDialog $frame $mb $id CoordRulerCB

    DistMenuMarkerDialog $frame $mb $id DistRulerCB dist dcoord dformat
    $mb add cascade -label Distance -menu $mb.dist

    # Init ruler variables

    EditRulerCB $frame $id
    TextMarkerCB $frame $id
    ColorMarkerCB $frame $id
    LineWidthMarkerCB $frame $id
    PropertyMarkerCB $frame $id
    FontMarkerCB $frame $id
    DistRulerCB $frame $id
    CoordRulerCB $frame $id

    # file menu items

    $mb.file add command -label "Apply" \
	-command "ApplyRulerDialog $frame $id"
    $mb.file add separator
    $mb.file add command -label "Close" \
	-command "CloseRulerDialog $frame $id"

    # create window

    set type [string toupper "[$frame get marker $id type]"]

    toplevel $w -colormap $ds9(main)
    wm title $w $type
    wm iconname $w $type
    wm group $w $ds9(top)
    wm protocol $w WM_DELETE_WINDOW "CloseRulerDialog $frame $id"
    wm minsize $w 400 250

    $w configure -menu $mb

    # Dialog

    frame $w.basic -relief groove -borderwidth 2
    frame $w.basic.f
    frame $w.ref -relief groove -borderwidth 2
    frame $w.ref.f
    frame $w.dist -relief groove -borderwidth 2
    frame $w.dist.f
    frame $w.buttons -relief groove -borderwidth 2
    pack $w.basic.f $w.ref.f $w.dist.f -anchor w -padx 4 -pady 4
    pack $w.basic $w.ref $w.dist -fill x 
    pack $w.buttons -fill x -ipadx 4 -ipady 4

    # ID

    label $w.basic.f.idTitle -text "Id"
    label $w.basic.f.idValue -text "$id"

    # Text

    label $w.basic.f.textTitle -text "Text"
    entry $w.basic.f.textValue -textvariable marker($frame,$id,text) -width 40

    grid $w.basic.f.idTitle $w.basic.f.idValue -padx 4 -sticky w
    grid $w.basic.f.textTitle $w.basic.f.textValue -padx 4 -sticky w

    # Points

    label $w.ref.f.title -text "Points   "
    entry $w.ref.f.x -textvariable marker($frame,$id,x) -width 13
    entry $w.ref.f.y -textvariable marker($frame,$id,y) -width 13
    label $w.ref.f.coord -relief groove -width 9 -padx 4 \
	-textvariable marker($frame,$id,system)

    entry $w.ref.f.x2 -textvariable marker($frame,$id,x2) -width 13
    entry $w.ref.f.y2 -textvariable marker($frame,$id,y2) -width 13

    grid $w.ref.f.title $w.ref.f.x $w.ref.f.y $w.ref.f.coord -padx 4 -sticky w
    grid x $w.ref.f.x2 $w.ref.f.y2 -padx 4 -sticky w

    # Distance

    label $w.dist.f.dtitle -text "Distance"
    label $w.dist.f.dist -relief groove -width 13  \
	-textvariable marker($frame,$id,dist)
    label $w.dist.f.format -relief groove -width 8 -padx 4 \
	-textvariable marker($frame,$id,dlabel)
    label $w.dist.f.atitle -text "Axis Dist"
    label $w.dist.f.x -relief groove -width 13  \
	-textvariable marker($frame,$id,distx)
    label $w.dist.f.y -relief groove -width 13  \
	-textvariable marker($frame,$id,disty)

    grid $w.dist.f.dtitle $w.dist.f.dist x $w.dist.f.format -padx 4 -sticky w
    grid $w.dist.f.atitle $w.dist.f.x $w.dist.f.y -padx 4 -pady 2 -sticky w

    # Angle

    label $w.dist.f.angtitle -text "Angle"
    label $w.dist.f.angle -relief groove -width 13  \
	-textvariable marker($frame,$id,angle)
    label $w.dist.f.angformat -text "degrees" -relief groove \
	-width 8 -padx 4

    grid $w.dist.f.angtitle $w.dist.f.angle x $w.dist.f.angformat \
	-padx 4 -sticky w

    # Buttons

    button $w.buttons.apply -text "Apply" \
	-command "ApplyRulerDialog $frame $id"
    button $w.buttons.close -text "Close" \
	-command "CloseRulerDialog $frame $id"
    pack $w.buttons.apply $w.buttons.close -side left -padx 10 -expand true

    bind $w <Return> "ApplyRulerDialog $frame $id"

    # some window managers need a hint
    raise $w
}

proc PropMenuRulerDialog {frame mb id} {
    global menu
    global marker

    menu $mb.properties -tearoff 0 -selectcolor $menu(selectcolor)
    $mb.properties add checkbutton -label "Can Edit" \
	-variable marker($frame,$id,edit) \
	-command "PropertyMarkerDialog $frame $id edit"
    $mb.properties add checkbutton -label "Can Move" \
	-variable marker($frame,$id,move) \
	-command "PropertyMarkerDialog $frame $id move"
    $mb.properties add checkbutton -label "Can Delete" \
	-variable marker($frame,$id,delete) \
	-command "PropertyMarkerDialog $frame $id delete"
}

proc ApplyRulerDialog {frame id} {
    global marker

    EditRulerDialog $frame $id
    $frame marker $id text \{$marker($frame,$id,text)\}

    UpdateMarkerMenu
}

proc CloseRulerDialog {frame id} {
    global marker

    $frame marker $id delete callback edit EditRulerCB
    $frame marker $id delete callback move EditRulerCB
    $frame marker $id delete callback text TextMarkerCB
    $frame marker $id delete callback color ColorMarkerCB
    $frame marker $id delete callback width LineWidthMarkerCB
    $frame marker $id delete callback property PropertyMarkerCB
    $frame marker $id delete callback font FontMarkerCB
    $frame marker $id delete callback delete DeleteRulerDialog

    DeleteRulerDialog $frame $id
}

proc DeleteRulerDialog {frame id} {
    global marker

    DeleteMarkerDialog $frame $id

    unset marker($frame,$id,x2)
    unset marker($frame,$id,y2)
    unset marker($frame,$id,angle)
    unset marker($frame,$id,dist)
    unset marker($frame,$id,distx)
    unset marker($frame,$id,disty)
    unset marker($frame,$id,dcoord)
    unset marker($frame,$id,dformat)
    unset marker($frame,$id,dlabel)
}

proc EditRulerDialog {frame id} {
    global marker

    $frame marker $id ruler point \
	$marker($frame,$id,system) $marker($frame,$id,sky) \
	$marker($frame,$id,x) $marker($frame,$id,y) \
	$marker($frame,$id,x2) $marker($frame,$id,y2)

    set d [$frame get marker $id ruler distance \
	       $marker($frame,$id,dcoord) $marker($frame,$id,dformat)]
    set marker($frame,$id,angle) [lindex $d 0]
    set marker($frame,$id,dist) [lindex $d 1]
    set marker($frame,$id,distx) [lindex $d 2]
    set marker($frame,$id,disty) [lindex $d 3]
}

proc EditRulerCB {frame id} {
    global marker

    set p [$frame get marker $id ruler point $marker($frame,$id,system) \
	       $marker($frame,$id,sky) $marker($frame,$id,skyformat)]

    set marker($frame,$id,x) [lindex $p 0]
    set marker($frame,$id,y) [lindex $p 1]
    set marker($frame,$id,x2) [lindex $p 2]
    set marker($frame,$id,y2) [lindex $p 3]

    set d [$frame get marker $id ruler distance \
	       $marker($frame,$id,dcoord) $marker($frame,$id,dformat)]
    set marker($frame,$id,angle) [lindex $d 0]
    set marker($frame,$id,dist) [lindex $d 1]
    set marker($frame,$id,distx) [lindex $d 2]
    set marker($frame,$id,disty) [lindex $d 3]
}

proc CoordRulerCB {frame id} {
    global marker

    CoordMarkerCB $frame $id

    $frame marker $id ruler system \
	$marker($frame,$id,system) $marker($frame,$id,sky) \
	$marker($frame,$id,dcoord) $marker($frame,$id,dformat)

    EditRulerCB $frame $id
}

proc DistRulerCB {frame id} {
    global marker
    set mb ".mb$id"

    AdjustDist $frame marker($frame,$id,dcoord)

    set marker($frame,$id,dlabel) $marker($frame,$id,dcoord)
    switch -- $marker($frame,$id,dcoord) {
	image -
	physical -
	amplifier -
	detector {}
	default {
	    if [$frame has wcs $marker($frame,$id,dcoord)] {
		if [$frame has wcs equatorial $marker($frame,$id,dcoord)] {
		    set marker($frame,$id,dlabel) $marker($frame,$id,dformat)
		} else {
		    set name [$frame get wcs name $marker($frame,$id,dcoord)]
		    if {$name != ""} {
			set marker($frame,$id,dlabel) $name
		    }
		}
	    }
	}
    }

    $frame marker $id ruler system \
	$marker($frame,$id,system) $marker($frame,$id,sky) \
	$marker($frame,$id,dcoord) $marker($frame,$id,dformat)

    set d [$frame get marker $id ruler distance \
	       $marker($frame,$id,dcoord) $marker($frame,$id,dformat)]
    set marker($frame,$id,angle) [lindex $d 0]
    set marker($frame,$id,dist) [lindex $d 1]
    set marker($frame,$id,distx) [lindex $d 2]
    set marker($frame,$id,disty) [lindex $d 3]
}

