# Samizdat member preferences
#
#   Copyright (c) 2002-2007  Dmitry Borodaenko <angdraug@debian.org>
#
#   This program is free software.
#   You can distribute/modify this program under the terms of
#   the GNU General Public License version 2 or later.
#
# vim: et sw=2 sts=2 ts=8 tw=0

require 'samizdat/engine'

# miscellaneous member preferences
#
# stored in a text field as a YAML hash
#
class Preferences < SimpleDelegator
  # load member preferences by login
  #
  def initialize(login)
    @login = login

    if 'guest' == @login
      @prefs = {}
    else
      # todo: do we need to cache this?
      prefs, = db.select_one 'SELECT prefs FROM Member WHERE login = ?', @login
      @prefs = yaml_hash(prefs)
    end

    super @prefs
  end

  # save updated member preferences to database
  #
  # _confirm_ is an optional confirmation hash
  #
  def save(confirm=nil)
    return if 'guest' == @login
    @prefs or raise RuntimeError, 'No preferences to save'
    db.do 'UPDATE Member SET prefs = ?, confirm = ? WHERE login = ?',
      YAML.dump(@prefs), confirm, @login
  end
end
